/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.workspace;

import com.google.common.base.Objects;
import java.io.File;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.workspace.FileSourceFolder;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.workspace.WorkspaceConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class FileProjectConfig
implements IProjectConfig {
    private final URI path;
    private final String name;
    private final Set<FileSourceFolder> sourceFolders = CollectionLiterals.newHashSet();
    private final IWorkspaceConfig workspaceConfig;

    public FileProjectConfig(URI path) {
        this(path, (IWorkspaceConfig)null);
    }

    public FileProjectConfig(URI path, String name) {
        this(path, name, (IWorkspaceConfig)null);
    }

    public FileProjectConfig(File root, String name) {
        this(root, name, (IWorkspaceConfig)null);
    }

    public FileProjectConfig(File root) {
        this(root, (IWorkspaceConfig)null);
    }

    public FileProjectConfig(URI path, IWorkspaceConfig workspaceConfig) {
        this(path, path.lastSegment(), workspaceConfig);
    }

    public FileProjectConfig(URI path, String name, IWorkspaceConfig workspaceConfig) {
        this.path = UriUtil.toFolderURI(path);
        this.name = name;
        IWorkspaceConfig _elvis = null;
        if (workspaceConfig != null) {
            _elvis = workspaceConfig;
        } else {
            WorkspaceConfig _workspaceConfig = new WorkspaceConfig(this);
            _elvis = _workspaceConfig;
        }
        this.workspaceConfig = _elvis;
    }

    public FileProjectConfig(File root, String name, IWorkspaceConfig workspaceConfig) {
        this(UriUtil.createFolderURI(root), name, workspaceConfig);
    }

    public FileProjectConfig(File root, IWorkspaceConfig workspaceConfig) {
        this(UriUtil.createFolderURI(root), root.getName(), workspaceConfig);
    }

    public FileSourceFolder addSourceFolder(String relativePath) {
        FileSourceFolder _xblockexpression = null;
        FileSourceFolder sourceFolder = new FileSourceFolder(this, relativePath);
        this.sourceFolders.add(sourceFolder);
        _xblockexpression = sourceFolder;
        return _xblockexpression;
    }

    @Override
    public FileSourceFolder findSourceFolderContaining(URI member) {
        Functions.Function1<FileSourceFolder, Boolean> _function = sourceFolder -> sourceFolder.contains(member);
        return IterableExtensions.findFirst(this.sourceFolders, _function);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileProjectConfig) {
            return Objects.equal(this.path, ((FileProjectConfig)obj).path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Project ");
        _builder.append(this.name);
        _builder.append(" (");
        _builder.append(this.path);
        _builder.append(")");
        return _builder.toString();
    }

    @Override
    @Pure
    public URI getPath() {
        return this.path;
    }

    @Override
    @Pure
    public String getName() {
        return this.name;
    }

    @Pure
    public Set<FileSourceFolder> getSourceFolders() {
        return this.sourceFolders;
    }

    @Override
    @Pure
    public IWorkspaceConfig getWorkspaceConfig() {
        return this.workspaceConfig;
    }
}

