/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.LiveShadowedChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Beta
@FinalFieldsConstructor
public class LiveShadowedChunkedContainer
implements IContainer {
    private final LiveShadowedChunkedResourceDescriptions descriptions;
    private final String containerName;
    private IProjectConfig projectConfig;
    private boolean isProjectConfigSet = false;

    protected ChunkedResourceDescriptions getChunkedResourceDescriptions() {
        IResourceDescriptions _globalDescriptions = this.descriptions.getGlobalDescriptions();
        return (ChunkedResourceDescriptions)_globalDescriptions;
    }

    protected IProjectConfig getProjectConfig() {
        if (!this.isProjectConfigSet) {
            IWorkspaceConfig _workspaceConfig = this.descriptions.getWorkspaceConfig();
            IProjectConfig _findProjectByName = null;
            if (_workspaceConfig != null) {
                _findProjectByName = _workspaceConfig.findProjectByName(this.containerName);
            }
            this.projectConfig = _findProjectByName;
            this.isProjectConfigSet = true;
        }
        return this.projectConfig;
    }

    protected ResourceDescriptionsData getChunk() {
        ResourceDescriptionsData _resourceDescriptionsData;
        ResourceDescriptionsData _elvis = null;
        ResourceDescriptionsData _container = this.getChunkedResourceDescriptions().getContainer(this.containerName);
        _elvis = _container != null ? _container : (_resourceDescriptionsData = new ResourceDescriptionsData(Collections.unmodifiableList(CollectionLiterals.newArrayList())));
        return _elvis;
    }

    protected Iterable<IResourceDescription> getContainedLocalDescriptions() {
        Functions.Function1<IResourceDescription, Boolean> _function = it -> this.isContained(it.getURI());
        return IterableExtensions.filter(this.descriptions.getLocalDescriptions().getAllResourceDescriptions(), _function);
    }

    protected boolean isContained(URI uri) {
        boolean _tripleNotEquals;
        boolean _or = false;
        IResourceDescription _resourceDescription = this.getChunk().getResourceDescription(uri);
        boolean bl = _tripleNotEquals = _resourceDescription != null;
        if (_tripleNotEquals) {
            _or = true;
        } else {
            boolean _tripleNotEquals_1;
            IProjectConfig _projectConfig = this.getProjectConfig();
            ISourceFolder _findSourceFolderContaining = null;
            if (_projectConfig != null) {
                _findSourceFolderContaining = _projectConfig.findSourceFolderContaining(uri);
            }
            _or = _tripleNotEquals_1 = _findSourceFolderContaining != null;
        }
        return _or;
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        IResourceDescription _xifexpression = null;
        boolean _isContained = this.isContained(uri);
        _xifexpression = _isContained ? this.descriptions.getResourceDescription(uri) : null;
        return _xifexpression;
    }

    @Override
    public int getResourceDescriptionCount() {
        return IterableExtensions.size(this.getResourceDescriptions());
    }

    @Override
    public Iterable<IResourceDescription> getResourceDescriptions() {
        Set<URI> localURIs = this.getExistingOrRenamedResourceURIs();
        Iterable<IResourceDescription> _containedLocalDescriptions = this.getContainedLocalDescriptions();
        Functions.Function1<IResourceDescription, Boolean> _function = it -> {
            boolean _contains = localURIs.contains(it.getURI());
            return !_contains;
        };
        Iterable<IResourceDescription> _filter = IterableExtensions.filter(this.getChunk().getAllResourceDescriptions(), _function);
        return Iterables.concat(_containedLocalDescriptions, _filter);
    }

    @Override
    public boolean hasResourceDescription(URI uri) {
        IResourceDescription _resourceDescription = this.getChunk().getResourceDescription(uri);
        return _resourceDescription != null;
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects() {
        Set<URI> localURIs = this.getExistingOrRenamedResourceURIs();
        Functions.Function1<IResourceDescription, Iterable> _function = it -> it.getExportedObjects();
        Iterable flatten = Iterables.concat(IterableExtensions.map(this.getContainedLocalDescriptions(), _function));
        Functions.Function1<IEObjectDescription, Boolean> _function_1 = it -> {
            boolean _contains = localURIs.contains(it.getEObjectURI().trimFragment());
            return !_contains;
        };
        Iterable<IEObjectDescription> _filter = IterableExtensions.filter(this.getChunk().getExportedObjects(), _function_1);
        return Iterables.concat(flatten, _filter);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
        Set<URI> localURIs = this.getExistingOrRenamedResourceURIs();
        Functions.Function1<IResourceDescription, Iterable> _function = it -> it.getExportedObjects(type, name, ignoreCase);
        Iterable _flatten = Iterables.concat(IterableExtensions.map(this.getContainedLocalDescriptions(), _function));
        Functions.Function1<IEObjectDescription, Boolean> _function_1 = it -> {
            boolean _contains = localURIs.contains(it.getEObjectURI().trimFragment());
            return !_contains;
        };
        Iterable<IEObjectDescription> _filter = IterableExtensions.filter(this.getChunk().getExportedObjects(type, name, ignoreCase), _function_1);
        return Iterables.concat(_flatten, _filter);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        Set<URI> localURIs = this.getExistingOrRenamedResourceURIs();
        Functions.Function1<IResourceDescription, Iterable> _function = it -> it.getExportedObjectsByObject(object);
        Iterable _flatten = Iterables.concat(IterableExtensions.map(this.getContainedLocalDescriptions(), _function));
        Functions.Function1<IEObjectDescription, Boolean> _function_1 = it -> {
            boolean _contains = localURIs.contains(it.getEObjectURI().trimFragment());
            return !_contains;
        };
        Iterable<IEObjectDescription> _filter = IterableExtensions.filter(this.getChunk().getExportedObjectsByObject(object), _function_1);
        return Iterables.concat(_flatten, _filter);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        Set<URI> localURIs = this.getExistingOrRenamedResourceURIs();
        Functions.Function1<IResourceDescription, Iterable> _function = it -> it.getExportedObjectsByType(type);
        Iterable _flatten = Iterables.concat(IterableExtensions.map(this.getContainedLocalDescriptions(), _function));
        Functions.Function1<IEObjectDescription, Boolean> _function_1 = it -> {
            boolean _contains = localURIs.contains(it.getEObjectURI().trimFragment());
            return !_contains;
        };
        Iterable<IEObjectDescription> _filter = IterableExtensions.filter(this.getChunk().getExportedObjectsByType(type), _function_1);
        return Iterables.concat(_flatten, _filter);
    }

    @Override
    public boolean isEmpty() {
        return IterableExtensions.isEmpty(this.getContainedLocalDescriptions()) && this.getChunk().isEmpty();
    }

    protected Set<URI> getExistingOrRenamedResourceURIs() {
        ResourceSet resourceSet = this.descriptions.getResourceSet();
        if (resourceSet instanceof ResourceSetImpl) {
            return ((ResourceSetImpl)resourceSet).getURIResourceMap().keySet();
        }
        throw new IllegalStateException("ResourceSet is not a ResourceSetImpl");
    }

    public LiveShadowedChunkedContainer(LiveShadowedChunkedResourceDescriptions descriptions, String containerName) {
        this.descriptions = descriptions;
        this.containerName = containerName;
    }
}

