/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.annotations.Beta;
import java.util.concurrent.BlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.generator.FileSystemAccessRequest;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class FileSystemAccessQueue
extends AdapterImpl {
    private final BlockingQueue<FileSystemAccessRequest> requestQueue;
    private final IProgressMonitor monitor;

    @FinalFieldsConstructor
    public FileSystemAccessQueue(BlockingQueue<FileSystemAccessRequest> requestQueue, IProgressMonitor monitor) {
        this.requestQueue = requestQueue;
        this.monitor = monitor;
    }

    public void sendAsync(URI uri, Runnable runMe) {
        FileSystemAccessRequest _fileSystemAccessRequest = new FileSystemAccessRequest(uri, runMe);
        this.send(_fileSystemAccessRequest);
    }

    protected FileSystemAccessRequest send(FileSystemAccessRequest request) {
        try {
            boolean _isCanceled = this.monitor.isCanceled();
            if (_isCanceled) {
                throw new OperationCanceledException();
            }
            this.requestQueue.put(request);
            return request;
        }
        catch (Throwable _t) {
            if (_t instanceof InterruptedException) {
                throw new OperationCanceledException();
            }
            throw Exceptions.sneakyThrow(_t);
        }
    }

    @Beta
    public void waitForEmptyQueue() {
        while (!this.requestQueue.isEmpty()) {
            Thread.yield();
        }
    }
}

