/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.base.Function;
import java.util.Comparator;
import org.eclipse.xtext.util.ITextRegion;

public class RegionComparator<T>
implements Comparator<T> {
    private final Function<? super T, ? extends ITextRegion> regionAccess;

    public RegionComparator(Function<? super T, ? extends ITextRegion> regionAccess) {
        this.regionAccess = regionAccess;
    }

    public Function<? super T, ? extends ITextRegion> getRegionAccess() {
        return this.regionAccess;
    }

    @Override
    public int compare(T t1, T t2) {
        ITextRegion o1 = this.regionAccess.apply(t1);
        ITextRegion o2 = this.regionAccess.apply(t2);
        int cmp1 = o1.getOffset() - o2.getOffset();
        if (cmp1 != 0) {
            return cmp1;
        }
        int cmp2 = o1.getLength() - o2.getLength();
        if (cmp2 != 0) {
            return cmp2;
        }
        return 0;
    }
}

