/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.descriptions;

import com.google.common.base.Splitter;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.EqualsHashCode;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.common.types.descriptions.ITypeDescriptor;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
@EqualsHashCode
@Accessors
public class ClasspathTypeDescriptor
implements ITypeDescriptor {
    private static final Splitter PACKAGE_AND_NESTED_CLASS_SPLITTER = Splitter.onPattern("\\.|\\$");
    private final String name;
    private final int modifiers;

    @Override
    public String getSimpleName() {
        return this.getQualifiedName().getLastSegment();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.create((String[])Conversions.unwrapArray(PACKAGE_AND_NESTED_CLASS_SPLITTER.split(this.name), String.class));
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClasspathTypeDescriptor other = (ClasspathTypeDescriptor)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return other.modifiers == this.modifiers;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return 31 * result + this.modifiers;
    }

    public ClasspathTypeDescriptor(String name, int modifiers) {
        this.name = name;
        this.modifiers = modifiers;
    }

    @Override
    @Pure
    public String getName() {
        return this.name;
    }

    @Override
    @Pure
    public int getModifiers() {
        return this.modifiers;
    }
}

