/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.descriptions;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.Resource;
import io.github.classgraph.ScanResult;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.common.types.descriptions.ClasspathTypeDescriptor;
import org.eclipse.xtext.common.types.descriptions.ITypeDescriptor;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Singleton
public class ClasspathScanner {
    @Inject
    private Provider<ClassGraph> classGraphProvider = () -> new ClassGraph();
    private Cache<ClassLoaderPackageConfig, Iterable<ITypeDescriptor>> classLoaderDescriptors = this.createClassLoaderCache();
    private String[] systemClasspath = null;

    protected Cache<ClassLoaderPackageConfig, Iterable<ITypeDescriptor>> createClassLoaderCache() {
        return CacheBuilder.newBuilder().initialCapacity(8).concurrencyLevel(2).maximumSize(32L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    public Iterable<ITypeDescriptor> getDescriptors(ClassLoader classLoader, Collection<String> packagePrefixes) {
        return this.getDescriptors(classLoader, false, packagePrefixes);
    }

    protected Iterable<ITypeDescriptor> getDescriptors(ClassLoader classLoader, boolean bootstrap, Collection<String> packagePrefixes) {
        try {
            ClassLoaderPackageConfig _classLoaderPackageConfig = new ClassLoaderPackageConfig(classLoader, bootstrap, packagePrefixes);
            Callable<Iterable> _function = () -> this.loadDescriptors(classLoader, bootstrap, packagePrefixes);
            return this.classLoaderDescriptors.get(_classLoaderPackageConfig, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    public Iterable<ITypeDescriptor> getBootClasspathDescriptors(Collection<String> packagePrefixes) {
        return this.getDescriptors(ClassLoader.getSystemClassLoader(), true, packagePrefixes);
    }

    public String[] getSystemClasspath() {
        if (this.systemClasspath != null) {
            return this.systemClasspath;
        }
        try (ScanResult scanResult = this.classGraphProvider.get().enableSystemJarsAndModules().addClassLoader(ClassLoader.getSystemClassLoader()).scan();){
            List<URI> classpathURIs = scanResult.getClasspathURIs();
            Functions.Function1<URI, String> _function = it -> it.getPath();
            this.systemClasspath = (String[])Conversions.unwrapArray(IterableExtensions.filterNull(ListExtensions.map(classpathURIs, _function)), String.class);
            String[] stringArray = this.systemClasspath;
            return stringArray;
        }
    }

    protected Iterable<ITypeDescriptor> loadDescriptors(ClassLoader classLoader, boolean bootstrap, Collection<String> packagePrefixes) {
        ClassGraph classGraph = this.classGraphProvider.get().ignoreClassVisibility().enableClassInfo().whitelistPackages(packagePrefixes.toArray(new String[0])).addClassLoader(classLoader);
        if (bootstrap) {
            classGraph.enableSystemJarsAndModules();
        }
        try (ScanResult scanResult = classGraph.scan();){
            Iterable<ITypeDescriptor> iterable = this.loadDescriptors(scanResult);
            return iterable;
        }
    }

    protected Iterable<ITypeDescriptor> loadDescriptors(ScanResult scanResult) {
        ArrayList<ITypeDescriptor> result = new ArrayList<ITypeDescriptor>();
        Consumer<ClassInfo> _function = clazz -> {
            boolean _tripleNotEquals;
            Resource _resource = clazz.getResource();
            boolean bl = _tripleNotEquals = _resource != null;
            if (_tripleNotEquals) {
                result.add(this.newDescriptor(clazz.getName(), clazz.getModifiers()));
            }
        };
        scanResult.getAllClasses().forEach(_function);
        return result;
    }

    protected ITypeDescriptor newDescriptor(String name, int modifiers) {
        return new ClasspathTypeDescriptor(name, modifiers);
    }

    @Data
    protected static class ClassLoaderPackageConfig {
        private final ClassLoader loader;
        private final boolean bootstrap;
        private final Collection<String> packagePrefixes;

        public ClassLoaderPackageConfig(ClassLoader loader, boolean bootstrap, Collection<String> packagePrefixes) {
            this.loader = loader;
            this.bootstrap = bootstrap;
            this.packagePrefixes = packagePrefixes;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loader == null ? 0 : this.loader.hashCode());
            result = 31 * result + (this.bootstrap ? 1231 : 1237);
            return 31 * result + (this.packagePrefixes == null ? 0 : this.packagePrefixes.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassLoaderPackageConfig other = (ClassLoaderPackageConfig)obj;
            if (this.loader == null ? other.loader != null : !this.loader.equals(other.loader)) {
                return false;
            }
            if (other.bootstrap != this.bootstrap) {
                return false;
            }
            return !(this.packagePrefixes == null ? other.packagePrefixes != null : !this.packagePrefixes.equals(other.packagePrefixes));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder(this);
            b.add("loader", this.loader);
            b.add("bootstrap", this.bootstrap);
            b.add("packagePrefixes", this.packagePrefixes);
            return b.toString();
        }

        @Pure
        public ClassLoader getLoader() {
            return this.loader;
        }

        @Pure
        public boolean isBootstrap() {
            return this.bootstrap;
        }

        @Pure
        public Collection<String> getPackagePrefixes() {
            return this.packagePrefixes;
        }
    }
}

