/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import java.util.Map;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.binary.asm.BinarySignatures;
import org.eclipse.xtext.common.types.access.binary.asm.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.common.types.access.binary.asm.Proxies;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Opcodes;

public class JvmFieldBuilder
extends FieldVisitor
implements Opcodes {
    protected final Proxies proxies;
    private final JvmDeclaredType declarator;
    private final JvmField result;

    public JvmFieldBuilder(JvmDeclaredType declarator, Map<String, JvmTypeParameter> typeParameters, Proxies proxies, int access, String name, String desc, String signature, Object value) {
        super(458752);
        this.proxies = proxies;
        this.declarator = declarator;
        if ((access & 0x4000) != 0) {
            this.result = TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
        } else {
            this.result = TypesFactory.eINSTANCE.createJvmField();
            if (value != null) {
                this.result.setConstant(true);
                if (desc.length() == 1) {
                    switch (desc.charAt(0)) {
                        case 'Z': {
                            this.result.setConstantValue((Integer)value != 0);
                            break;
                        }
                        case 'C': {
                            this.result.setConstantValue(Character.valueOf((char)((Integer)value).intValue()));
                            break;
                        }
                        case 'B': {
                            this.result.setConstantValue(((Number)value).byteValue());
                            break;
                        }
                        case 'S': {
                            this.result.setConstantValue(((Number)value).shortValue());
                            break;
                        }
                        default: {
                            this.result.setConstantValue(value);
                            break;
                        }
                    }
                } else {
                    this.result.setConstantValue(value);
                }
            } else {
                this.result.setConstant(false);
            }
        }
        this.result.internalSetIdentifier(declarator.getIdentifier() + "." + name);
        this.result.setSimpleName(name);
        this.result.setFinal((access & 0x10) != 0);
        this.result.setStatic((access & 8) != 0);
        this.result.setTransient((access & 0x80) != 0);
        this.result.setVolatile((access & 0x40) != 0);
        this.result.setDeprecated((access & 0x20000) != 0);
        proxies.setVisibility(access, this.result);
        this.result.setType(proxies.createTypeReference(BinarySignatures.createTypeSignature(signature != null ? signature : desc), typeParameters));
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new JvmAnnotationReferenceBuilder((InternalEList)this.result.getAnnotations(), desc, this.proxies);
    }

    @Override
    public void visitEnd() {
        InternalEList members = (InternalEList)this.declarator.getMembers();
        members.addUnique(this.result);
    }
}

