/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.build.BuildContext;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.build.Indexer;
import org.eclipse.xtext.build.Source2GeneratedMapping;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider2;
import org.eclipse.xtext.generator.IFilePostProcessor;
import org.eclipse.xtext.generator.IShouldGenerate;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.URIBasedFileSystemAccess;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.DisabledClusteringPolicy;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class IncrementalBuilder {
    @Inject
    private Provider<InternalStatefulIncrementalBuilder> provider;
    @Inject
    @Extension
    private OperationCanceledManager _operationCanceledManager;

    public Result build(BuildRequest request, Functions.Function1<? super URI, ? extends IResourceServiceProvider> languages) {
        DisabledClusteringPolicy _disabledClusteringPolicy = new DisabledClusteringPolicy();
        return this.build(request, languages, _disabledClusteringPolicy);
    }

    public Result build(BuildRequest request, Functions.Function1<? super URI, ? extends IResourceServiceProvider> languages, IResourceClusteringPolicy clusteringPolicy) {
        try {
            XtextResourceSet resourceSet = request.getResourceSet();
            ResourceDescriptionsData _copy = request.getState().getResourceDescriptions().copy();
            Source2GeneratedMapping _copy_1 = request.getState().getFileMappings().copy();
            IndexState oldState = new IndexState(_copy, _copy_1);
            CancelIndicator _cancelIndicator = request.getCancelIndicator();
            BuildContext context = new BuildContext(languages, resourceSet, oldState, clusteringPolicy, _cancelIndicator);
            InternalStatefulIncrementalBuilder builder = this.provider.get();
            builder.setContext(context);
            builder.setRequest(request);
            try {
                return builder.launch();
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) {
                    Throwable t = _t;
                    this._operationCanceledManager.propagateIfCancelException(t);
                    throw t;
                }
                throw Exceptions.sneakyThrow(_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    public static class InternalStatefulIncrementalBuilder {
        @Extension
        @Accessors(value={AccessorType.PROTECTED_SETTER, AccessorType.PROTECTED_GETTER})
        private BuildContext context;
        @Accessors(value={AccessorType.PROTECTED_SETTER, AccessorType.PROTECTED_GETTER})
        private BuildRequest request;
        @Inject
        private Indexer indexer;
        @Inject
        @Extension
        private OperationCanceledManager _operationCanceledManager;

        protected void unloadResource(URI uri) {
            Resource resource = this.request.getResourceSet().getResource(uri, false);
            if (resource != null) {
                this.request.getResourceSet().getResources().remove(resource);
                resource.unload();
            }
        }

        public Result launch() {
            Source2GeneratedMapping newSource2GeneratedMapping = this.request.getState().getFileMappings();
            HashSet unloaded = CollectionLiterals.newHashSet();
            List<URI> _deletedFiles = this.request.getDeletedFiles();
            for (URI uRI : _deletedFiles) {
                boolean _add = unloaded.add(uRI);
                if (!_add) continue;
                this.unloadResource(uRI);
            }
            List<URI> _dirtyFiles = this.request.getDirtyFiles();
            for (URI dirty : _dirtyFiles) {
                boolean _add_1 = unloaded.add(dirty);
                if (!_add_1) continue;
                this.unloadResource(dirty);
            }
            Consumer<URI> consumer = source -> {
                this.request.getAfterValidate().afterValidate((URI)source, (Iterable<Issue>)CollectionLiterals.newArrayList());
                Consumer<URI> _function_1 = generated -> {
                    try {
                        IResourceServiceProvider serviceProvider = this.context.getResourceServiceProvider((URI)source);
                        Set<OutputConfiguration> configs = serviceProvider.get(IContextualOutputConfigurationProvider2.class).getOutputConfigurations(this.request.getResourceSet());
                        String configName = newSource2GeneratedMapping.getOutputConfigName((URI)generated);
                        Functions.Function1<OutputConfiguration, Boolean> _function_2 = it -> {
                            String _name = it.getName();
                            return Objects.equal(_name, configName);
                        };
                        OutputConfiguration config = IterableExtensions.findFirst(configs, _function_2);
                        if (config != null && config.isCleanUpDerivedResources()) {
                            this.context.getResourceSet().getURIConverter().delete((URI)generated, CollectionLiterals.emptyMap());
                            this.request.getAfterDeleteFile().apply((URI)generated);
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow(_e);
                    }
                };
                newSource2GeneratedMapping.deleteSource((URI)source).forEach(_function_1);
            };
            this.request.getDeletedFiles().forEach(consumer);
            Indexer.IndexResult result = this.indexer.computeAndIndexAffected(this.request, this.context);
            this._operationCanceledManager.checkCanceled(this.request.getCancelIndicator());
            List<IResourceDescription.Delta> _resourceDeltas = result.getResourceDeltas();
            for (IResourceDescription.Delta delta : _resourceDeltas) {
                if (delta.getOld() == null || !unloaded.add(delta.getUri())) continue;
                this.unloadResource(delta.getUri());
            }
            ArrayList<IResourceDescription.Delta> resolvedDeltas = CollectionLiterals.newArrayList();
            Functions.Function1<IResourceDescription.Delta, Boolean> _function_1 = it -> {
                IResourceDescription _new = it.getNew();
                return _new == null;
            };
            Iterable<IResourceDescription.Delta> _filter = IterableExtensions.filter(result.getResourceDeltas(), _function_1);
            Iterables.addAll(resolvedDeltas, _filter);
            Functions.Function1<IResourceDescription.Delta, Boolean> _function_2 = it -> {
                IResourceDescription _new = it.getNew();
                return _new != null;
            };
            Functions.Function1<IResourceDescription.Delta, URI> _function_3 = it -> it.getUri();
            Functions.Function1<Resource, IResourceDescription.Delta> _function_4 = resource -> {
                this._operationCanceledManager.checkCanceled(this.request.getCancelIndicator());
                resource.getContents();
                EcoreUtil2.resolveLazyCrossReferences(resource, CancelIndicator.NullImpl);
                this._operationCanceledManager.checkCanceled(this.request.getCancelIndicator());
                IResourceServiceProvider serviceProvider = this.getResourceServiceProvider((Resource)resource);
                IResourceDescription.Manager manager = serviceProvider.getResourceDescriptionManager();
                IResourceDescription description = manager.getResourceDescription((Resource)resource);
                SerializableResourceDescription copiedDescription = SerializableResourceDescription.createCopy(description);
                result.getNewIndex().addDescription(resource.getURI(), copiedDescription);
                this._operationCanceledManager.checkCanceled(this.request.getCancelIndicator());
                if (!this.request.isIndexOnly() && this.validate((Resource)resource) && serviceProvider.get(IShouldGenerate.class).shouldGenerate((Resource)resource, CancelIndicator.NullImpl)) {
                    this._operationCanceledManager.checkCanceled(this.request.getCancelIndicator());
                    this.generate((Resource)resource, this.request, newSource2GeneratedMapping);
                }
                IResourceDescription old = this.context.getOldState().getResourceDescriptions().getResourceDescription(resource.getURI());
                return manager.createDelta(old, copiedDescription);
            };
            Iterable<IResourceDescription.Delta> _executeClustered = this.context.executeClustered(IterableExtensions.map(IterableExtensions.filter(result.getResourceDeltas(), _function_2), _function_3), _function_4);
            Iterables.addAll(resolvedDeltas, _executeClustered);
            IndexState _state = this.request.getState();
            return new Result(_state, resolvedDeltas);
        }

        private IResourceServiceProvider getResourceServiceProvider(Resource resource) {
            if (resource instanceof XtextResource) {
                return ((XtextResource)resource).getResourceServiceProvider();
            }
            return this.context.getResourceServiceProvider(resource.getURI());
        }

        protected boolean validate(Resource resource) {
            IResourceValidator resourceValidator = this.getResourceServiceProvider(resource).getResourceValidator();
            if (resourceValidator == null) {
                return true;
            }
            List<Issue> validationResult = resourceValidator.validate(resource, CheckMode.ALL, null);
            return this.request.getAfterValidate().afterValidate(resource.getURI(), validationResult);
        }

        protected void generate(Resource resource, BuildRequest request, Source2GeneratedMapping newMappings) {
            IResourceServiceProvider serviceProvider = this.getResourceServiceProvider(resource);
            GeneratorDelegate generator = serviceProvider.get(GeneratorDelegate.class);
            if (generator == null) {
                return;
            }
            Set<URI> previous = newMappings.deleteSource(resource.getURI());
            URIBasedFileSystemAccess _createFileSystemAccess = this.createFileSystemAccess(serviceProvider, resource);
            Procedures.Procedure1<URIBasedFileSystemAccess> _function = it -> {
                URIBasedFileSystemAccess.BeforeWrite _function_1 = (uri, outputCfgName, contents) -> {
                    newMappings.addSource2Generated(resource.getURI(), uri, outputCfgName);
                    previous.remove(uri);
                    request.getAfterGenerateFile().apply(resource.getURI(), uri);
                    return contents;
                };
                it.setBeforeWrite(_function_1);
                URIBasedFileSystemAccess.BeforeDelete _function_2 = uri -> {
                    newMappings.deleteGenerated(uri);
                    request.getAfterDeleteFile().apply(uri);
                    return true;
                };
                it.setBeforeDelete(_function_2);
            };
            URIBasedFileSystemAccess fileSystemAccess = ObjectExtensions.operator_doubleArrow(_createFileSystemAccess, _function);
            fileSystemAccess.setContext(resource);
            boolean _isWriteStorageResources = request.isWriteStorageResources();
            if (_isWriteStorageResources) {
                boolean _matched = false;
                if (resource instanceof StorageAwareResource) {
                    boolean _tripleNotEquals;
                    IResourceStorageFacade _resourceStorageFacade = ((StorageAwareResource)resource).getResourceStorageFacade();
                    boolean bl = _tripleNotEquals = _resourceStorageFacade != null;
                    if (_tripleNotEquals) {
                        _matched = true;
                        ((StorageAwareResource)resource).getResourceStorageFacade().saveResource((StorageAwareResource)resource, fileSystemAccess);
                    }
                }
            }
            GeneratorContext generatorContext = new GeneratorContext();
            generatorContext.setCancelIndicator(request.getCancelIndicator());
            generator.generate(resource, fileSystemAccess, generatorContext);
            Consumer<URI> _function_1 = it -> {
                try {
                    this.context.getResourceSet().getURIConverter().delete((URI)it, CollectionLiterals.emptyMap());
                    request.getAfterDeleteFile().apply((URI)it);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow(_e);
                }
            };
            previous.forEach(_function_1);
        }

        protected URIBasedFileSystemAccess createFileSystemAccess(IResourceServiceProvider serviceProvider, Resource resource) {
            return serviceProvider.get(URIBasedFileSystemAccessFactory.class).newFileSystemAccess(resource, this.request);
        }

        @Pure
        protected BuildContext getContext() {
            return this.context;
        }

        protected void setContext(BuildContext context) {
            this.context = context;
        }

        @Pure
        protected BuildRequest getRequest() {
            return this.request;
        }

        protected void setRequest(BuildRequest request) {
            this.request = request;
        }

        @Singleton
        public static class URIBasedFileSystemAccessFactory {
            @Inject
            private IContextualOutputConfigurationProvider outputConfigurationProvider;
            @Inject
            private IFilePostProcessor postProcessor;
            @Inject(optional=true)
            private IEncodingProvider encodingProvider;
            @Inject
            private TraceFileNameProvider traceFileNameProvider;
            @Inject
            private TraceRegionSerializer traceRegionSerializer;
            @Inject(optional=true)
            private IProjectConfigProvider projectConfigProvider;

            public URIBasedFileSystemAccess newFileSystemAccess(Resource resource, BuildRequest request) {
                URIBasedFileSystemAccess _uRIBasedFileSystemAccess = new URIBasedFileSystemAccess();
                Procedures.Procedure1<URIBasedFileSystemAccess> _function = it -> {
                    Functions.Function1<OutputConfiguration, String> _function_1 = it_1 -> it_1.getName();
                    it.setOutputConfigurations(IterableExtensions.toMap(this.outputConfigurationProvider.getOutputConfigurations(resource), _function_1));
                    it.setPostProcessor(this.postProcessor);
                    if (this.encodingProvider != null) {
                        it.setEncodingProvider(this.encodingProvider);
                    }
                    it.setTraceFileNameProvider(this.traceFileNameProvider);
                    it.setTraceRegionSerializer(this.traceRegionSerializer);
                    it.setGenerateTraces(true);
                    it.setBaseDir(request.getBaseDir());
                    if (this.projectConfigProvider != null) {
                        IProjectConfig _projectConfig = this.projectConfigProvider.getProjectConfig(resource.getResourceSet());
                        ISourceFolder _findSourceFolderContaining = null;
                        if (_projectConfig != null) {
                            _findSourceFolderContaining = _projectConfig.findSourceFolderContaining(resource.getURI());
                        }
                        ISourceFolder sourceFolder = _findSourceFolderContaining;
                        String _name = null;
                        if (sourceFolder != null) {
                            _name = sourceFolder.getName();
                        }
                        it.setCurrentSource(_name);
                    }
                    it.setConverter(resource.getResourceSet().getURIConverter());
                };
                return ObjectExtensions.operator_doubleArrow(_uRIBasedFileSystemAccess, _function);
            }
        }
    }

    @Data
    public static class Result {
        private final IndexState indexState;
        private final List<IResourceDescription.Delta> affectedResources;

        public Result(IndexState indexState, List<IResourceDescription.Delta> affectedResources) {
            this.indexState = indexState;
            this.affectedResources = affectedResources;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.indexState == null ? 0 : this.indexState.hashCode());
            return 31 * result + (this.affectedResources == null ? 0 : this.affectedResources.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            if (this.indexState == null ? other.indexState != null : !this.indexState.equals(other.indexState)) {
                return false;
            }
            return !(this.affectedResources == null ? other.affectedResources != null : !this.affectedResources.equals(other.affectedResources));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder(this);
            b.add("indexState", this.indexState);
            b.add("affectedResources", this.affectedResources);
            return b.toString();
        }

        @Pure
        public IndexState getIndexState() {
            return this.indexState;
        }

        @Pure
        public List<IResourceDescription.Delta> getAffectedResources() {
            return this.affectedResources;
        }
    }
}

