/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.ActiveAnnotationContext;
import org.eclipse.xtend.core.macro.ActiveAnnotationContexts;
import org.eclipse.xtend.core.macro.AnnotationProcessor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.validation.IssueSeveritiesProvider;
import org.eclipse.xtext.xbase.annotations.validation.DerivedStateAwareResourceValidator;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.typesystem.computation.DiagnosticOnFirstKeyword;

public class CachingResourceValidatorImpl
extends DerivedStateAwareResourceValidator {
    @Inject
    private OnChangeEvictingCache cache;
    @Inject
    private AnnotationProcessor annotationProcessor;
    @Inject
    private IssueSeveritiesProvider issueSeveritiesProvider;
    @Inject
    @Extension
    private IJvmModelAssociations _iJvmModelAssociations;
    @Inject
    @Extension
    private JvmTypeExtensions _jvmTypeExtensions;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    @Override
    public List<Issue> validate(Resource resource, CheckMode mode, CancelIndicator mon) throws OperationCanceledError {
        Provider<List> _function = () -> {
            this.operationCanceledManager.checkCanceled(mon);
            return super.validate(resource, mode, mon);
        };
        return this.cache.get(mode, resource, _function);
    }

    @Override
    protected void collectResourceDiagnostics(Resource resource, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        this.runActiveAnnotationValidation(resource, monitor);
        this.addWarningsForOrphanedJvmElements(resource, monitor, acceptor);
        super.collectResourceDiagnostics(resource, monitor, acceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runActiveAnnotationValidation(Resource resource, CancelIndicator monitor) {
        ActiveAnnotationContexts contexts = ActiveAnnotationContexts.find(resource);
        if (contexts == null) {
            return;
        }
        try {
            contexts.before(ActiveAnnotationContexts.AnnotationCallback.VALIDATION);
            Collection<ActiveAnnotationContext> _values = contexts.getContexts().values();
            for (ActiveAnnotationContext ctx : _values) {
                this.operationCanceledManager.checkCanceled(monitor);
                try {
                    this.annotationProcessor.validationPhase(ctx, monitor);
                }
                catch (Throwable _t) {
                    if (!(_t instanceof Throwable)) throw Exceptions.sneakyThrow(_t);
                    Throwable t = _t;
                    this.operationCanceledManager.propagateAsErrorIfCancelException(t);
                    ctx.handleProcessingError(resource, t);
                    continue;
                    return;
                }
            }
        }
        finally {
            contexts.after(ActiveAnnotationContexts.AnnotationCallback.VALIDATION);
        }
    }

    private void addWarningsForOrphanedJvmElements(Resource resource, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        IssueSeverities issueSeverities = this.issueSeveritiesProvider.getIssueSeverities(resource);
        Severity severity = issueSeverities.getSeverity("org.eclipse.xtend.core.validation.IssueCodes.orphan_element");
        boolean _equals = Objects.equal((Object)severity, (Object)Severity.IGNORE);
        if (_equals) {
            return;
        }
        Iterable<JvmDeclaredType> _filter = Iterables.filter(IterableExtensions.tail(resource.getContents()), JvmDeclaredType.class);
        for (JvmDeclaredType jvmType : _filter) {
            Functions.Function1<JvmMember, Boolean> _function = it -> {
                boolean _isSynthetic = this._jvmTypeExtensions.isSynthetic((JvmIdentifiableElement)it);
                return !_isSynthetic;
            };
            Iterable<JvmMember> _iterable = IteratorExtensions.toIterable(IteratorExtensions.filter(Iterators.filter(jvmType.eAllContents(), JvmMember.class), _function));
            for (JvmMember jvmMember : _iterable) {
                this.operationCanceledManager.checkCanceled(monitor);
                EObject sourceElement = this._iJvmModelAssociations.getPrimarySourceElement(jvmMember);
                if (sourceElement != null) continue;
                this.addWarningForOrphanedJvmElement(resource, jvmMember, severity, acceptor);
            }
        }
    }

    private void addWarningForOrphanedJvmElement(Resource resource, JvmMember jvmElement, Severity severity, IAcceptor<Issue> acceptor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The generated ");
        String _uiString = this.getUiString(jvmElement);
        _builder.append(_uiString);
        _builder.append(" is not associated with a source element. The producing active annotation should use 'setPrimarySourceElement'.");
        EObject _head = IterableExtensions.head(resource.getContents());
        this.issueFromXtextResourceDiagnostic(new DiagnosticOnFirstKeyword(severity, "org.eclipse.xtend.core.validation.IssueCodes.orphan_element", _builder.toString(), _head, null), severity, acceptor);
    }

    private String getUiString(JvmMember member) {
        String _xblockexpression = null;
        StringBuilder uiString = new StringBuilder();
        String _switchResult = null;
        boolean _matched = false;
        if (member instanceof JvmConstructor) {
            _matched = true;
            _switchResult = "constructor";
        }
        if (!_matched && member instanceof JvmField) {
            _matched = true;
            _switchResult = "field";
        }
        if (!_matched && member instanceof JvmOperation) {
            _matched = true;
            _switchResult = "method";
        }
        if (!_matched && member instanceof JvmDeclaredType) {
            _matched = true;
            _switchResult = "type";
        }
        String type = _switchResult;
        uiString.append(type).append(" '").append(member.getQualifiedName('.'));
        if (member instanceof JvmExecutable) {
            Functions.Function1<JvmFormalParameter, CharSequence> _function = it -> it.getParameterType().getSimpleName();
            String parameterTypes = IterableExtensions.join(((JvmExecutable)member).getParameters(), ", ", _function);
            uiString.append("(").append(parameterTypes).append(")");
        }
        uiString.append("'");
        _xblockexpression = uiString.toString();
        return _xblockexpression;
    }
}

