/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScope;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.scoping.IScope;

public class LocalResourceFilteringTypeScope
extends AbstractTypeScope {
    private AbstractTypeScope delegate;
    private IResourceDescription filterDescription;

    protected LocalResourceFilteringTypeScope(AbstractTypeScope delegate, IResourceDescription filterDescription) {
        super(null, null, null);
        this.delegate = delegate;
        this.filterDescription = filterDescription;
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        if (this.isFiltered(name)) {
            return null;
        }
        return this.delegate.getSingleElement(name);
    }

    private boolean isFiltered(QualifiedName name) {
        Iterable<IEObjectDescription> exportedObjects = this.filterDescription.getExportedObjects(TypesPackage.Literals.JVM_TYPE, name, false);
        return !Iterables.isEmpty(exportedObjects);
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name, boolean binary) {
        if (this.isFiltered(name)) {
            return null;
        }
        return this.delegate.getSingleElement(name, binary);
    }

    @Override
    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        return Iterables.filter(this.delegate.getElements(name), new Predicate<IEObjectDescription>(){

            @Override
            public boolean apply(IEObjectDescription input) {
                return !LocalResourceFilteringTypeScope.this.isFiltered(input.getQualifiedName());
            }
        });
    }

    @Override
    public Iterable<IEObjectDescription> getElements(EObject object) {
        return Iterables.filter(this.delegate.getElements(object), new Predicate<IEObjectDescription>(){

            @Override
            public boolean apply(IEObjectDescription input) {
                return !LocalResourceFilteringTypeScope.this.isFiltered(input.getQualifiedName());
            }
        });
    }

    @Override
    public IScope getParent() {
        return this.delegate.getParent();
    }

    @Override
    public Iterable<IEObjectDescription> getAllElements() {
        return Iterables.filter(this.delegate.getAllElements(), new Predicate<IEObjectDescription>(){

            @Override
            public boolean apply(IEObjectDescription input) {
                return !LocalResourceFilteringTypeScope.this.isFiltered(input.getQualifiedName());
            }
        });
    }

    @Override
    public IJvmTypeProvider getTypeProvider() {
        return this.delegate.getTypeProvider();
    }

    @Override
    public IQualifiedNameConverter getQualifiedNameConverter() {
        return this.delegate.getQualifiedNameConverter();
    }

    @Override
    public IEObjectDescription getSingleElement(EObject object) {
        return this.delegate.getSingleElement(object);
    }
}

