/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend.core.scoping.AbstractScope;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;

public class CachingTypeScope
extends AbstractScope {
    private final AbstractScope parent;
    private final Map<QualifiedName, IEObjectDescription> cache;

    public CachingTypeScope(AbstractScope parent) {
        this.parent = parent;
        this.cache = Maps.newHashMapWithExpectedSize(50);
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription cached = this.cache.get(name);
        if (cached == null) {
            if (this.cache.containsKey(name)) {
                return null;
            }
            cached = this.parent.getSingleElement(name);
            this.cache.put(name, cached);
        }
        return cached;
    }

    @Override
    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        IEObjectDescription element = this.getSingleElement(name);
        if (element == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(element);
    }

    @Override
    protected void doGetElements(JvmType type, List<IEObjectDescription> result) {
        this.parent.doGetElements(type, result);
    }
}

