/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public abstract class AbstractScope
implements IScope {
    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IEObjectDescription getSingleElement(EObject object) {
        Iterator<IEObjectDescription> elements = this.getElements(object).iterator();
        if (elements.hasNext()) {
            IEObjectDescription result = elements.next();
            String resultName = result.getName().toString();
            while (elements.hasNext()) {
                IEObjectDescription candidate = elements.next();
                String candidateName = candidate.getName().toString();
                if (candidateName.length() < resultName.length()) {
                    result = candidate;
                    resultName = candidateName;
                    continue;
                }
                if (candidateName.length() != resultName.length() || candidate.getQualifiedName().getSegmentCount() <= result.getQualifiedName().getSegmentCount()) continue;
                result = candidate;
                resultName = candidateName;
            }
            return result;
        }
        return null;
    }

    @Override
    public final Iterable<IEObjectDescription> getElements(EObject object) {
        if (!(object instanceof JvmType) || object.eIsProxy()) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        LinkedList<IEObjectDescription> result = Lists.newLinkedList();
        this.doGetElements((JvmType)object, result);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            IEObjectDescription description = (IEObjectDescription)iterator.next();
            IEObjectDescription lookUp = this.getSingleElement(description.getName());
            if (lookUp != null && lookUp.getEObjectOrProxy() == object) continue;
            iterator.remove();
        }
        return result;
    }

    protected abstract void doGetElements(JvmType var1, List<IEObjectDescription> var2);

    @Override
    public Iterable<IEObjectDescription> getAllElements() {
        throw new UnsupportedOperationException();
    }
}

