/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.resource;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.resource.XtendResourceDescription;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.DerivedStateAwareResourceDescriptionManager;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;

@Singleton
public class XtendResourceDescriptionManager
extends DerivedStateAwareResourceDescriptionManager
implements IResourceDescription.Manager.AllChangeAware {
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private IQualifiedNameConverter nameConverter;

    @Override
    public IResourceDescription createResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy) {
        IResourceScopeCache _cache = this.getCache();
        return new XtendResourceDescription(resource, strategy, _cache, this.typeResolver, this.nameConverter);
    }

    @Override
    public boolean hasChanges(IResourceDescription.Delta delta, IResourceDescription candidate) {
        return super.hasChanges(delta, candidate) || this.containsActiveAnnotation(candidate);
    }

    private boolean containsActiveAnnotation(IResourceDescription description) {
        Functions.Function1<IEObjectDescription, Boolean> _function = it -> ((List)Conversions.doWrapArray(it.getUserDataKeys())).contains("ACTIVE_ANNOTATION_TIMESTAMP");
        return IterableExtensions.exists(description.getExportedObjects(), _function);
    }

    @Override
    public boolean isAffectedByAny(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) throws IllegalArgumentException {
        return this.isAffected(deltas, candidate, context);
    }
}

