/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.parser;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.xtend.core.parser.InternalFlexer;
import org.eclipse.xtend.core.parser.antlr.internal.FlexerFactory;
import org.eclipse.xtext.parser.impl.TokenRegionProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class FlexTokenRegionProvider
extends TokenRegionProvider {
    @Inject
    private FlexerFactory flexerFactory;

    @Override
    public ITextRegion getTokenRegion(String text, ITextRegion region) {
        try {
            int nextStart;
            InternalFlexer flexer = this.flexerFactory.createFlexer(new StringReader(text));
            int token = flexer.advance();
            int prevStart = 0;
            int regionStartOffset = region.getOffset();
            int regionEnd = regionStartOffset + region.getLength();
            for (nextStart = flexer.getTokenLength(); token != -1 && nextStart <= regionStartOffset; nextStart += flexer.getTokenLength()) {
                prevStart = nextStart;
                token = flexer.advance();
            }
            while (token != -1 && nextStart < regionEnd) {
                token = flexer.advance();
                nextStart += flexer.getTokenLength();
            }
            return new TextRegion(prevStart, nextStart - prevStart);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

