/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.XtendMemberDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public abstract class XtendTypeDeclarationImpl<T extends XtendTypeDeclaration>
extends XtendMemberDeclarationImpl<T>
implements TypeDeclaration {
    public String getPackageName() {
        return EcoreUtil2.getContainerOfType((EObject)this.getDelegate(), XtendFile.class).getPackage();
    }

    @Override
    public String getSimpleName() {
        return ((XtendTypeDeclaration)this.getDelegate()).getName();
    }

    @Override
    public String getQualifiedName() {
        return this.getQualifiedName((XtendTypeDeclaration)this.getDelegate());
    }

    private String getQualifiedName(XtendTypeDeclaration decl) {
        boolean _isAnonymous = decl.isAnonymous();
        if (_isAnonymous) {
            return null;
        }
        EObject container = decl.eContainer();
        if (container instanceof XtendFile) {
            String package_ = ((XtendFile)container).getPackage();
            if (package_ == null) {
                return decl.getName();
            }
            String _name = decl.getName();
            return package_ + "." + _name;
        }
        if (container instanceof XtendTypeDeclaration) {
            String containerName = this.getQualifiedName((XtendTypeDeclaration)container);
            if (containerName == null) {
                return null;
            }
            String _name_1 = decl.getName();
            return containerName + "." + _name_1;
        }
        return null;
    }

    @Override
    public Visibility getVisibility() {
        return ((CompilationUnitImpl)this.getCompilationUnit()).toVisibility(((XtendTypeDeclaration)this.getDelegate()).getVisibility());
    }

    @Override
    public Iterable<? extends MemberDeclaration> getDeclaredMembers() {
        Functions.Function1<XtendMember, MemberDeclaration> _function = it -> ((CompilationUnitImpl)this.getCompilationUnit()).toXtendMemberDeclaration((XtendMember)it);
        return ListExtensions.map(((XtendTypeDeclaration)this.getDelegate()).getMembers(), _function);
    }

    @Override
    public boolean isAssignableFrom(Type otherType) {
        if (otherType == null) {
            return false;
        }
        TypeReference thisTypeRef = ((CompilationUnitImpl)this.getCompilationUnit()).getTypeReferenceProvider().newTypeReference(this, new TypeReference[0]);
        TypeReference thatTypeRef = ((CompilationUnitImpl)this.getCompilationUnit()).getTypeReferenceProvider().newTypeReference(otherType, new TypeReference[0]);
        return thisTypeRef.isAssignableFrom(thatTypeRef);
    }

    @Override
    public ConstructorDeclaration findDeclaredConstructor(TypeReference ... parameterTypes) {
        Functions.Function1<ConstructorDeclaration, Boolean> _function = constructor -> {
            Functions.Function1<ParameterDeclaration, TypeReference> _function_1 = it -> it.getType();
            List<TypeReference> _list = IterableExtensions.toList(IterableExtensions.map(constructor.getParameters(), _function_1));
            List _list_1 = IterableExtensions.toList((Iterable)Conversions.doWrapArray(parameterTypes));
            return Objects.equal(_list, _list_1);
        };
        return IterableExtensions.findFirst(this.getDeclaredConstructors(), _function);
    }

    @Override
    public FieldDeclaration findDeclaredField(String name) {
        Functions.Function1<FieldDeclaration, Boolean> _function = field -> {
            String _simpleName = field.getSimpleName();
            return Objects.equal(_simpleName, name);
        };
        return IterableExtensions.findFirst(this.getDeclaredFields(), _function);
    }

    @Override
    public TypeDeclaration findDeclaredType(String name) {
        Functions.Function1<TypeDeclaration, Boolean> _function = type -> {
            String _simpleName = type.getSimpleName();
            return Objects.equal(_simpleName, name);
        };
        return IterableExtensions.findFirst(this.getDeclaredTypes(), _function);
    }

    @Override
    public MethodDeclaration findDeclaredMethod(String name, TypeReference ... parameterTypes) {
        Functions.Function1<MethodDeclaration, Boolean> _function = method -> Objects.equal(method.getSimpleName(), name) && Objects.equal(IterableExtensions.toList(IterableExtensions.map(method.getParameters(), it -> it.getType())), IterableExtensions.toList((Iterable)Conversions.doWrapArray(parameterTypes)));
        return IterableExtensions.findFirst(this.getDeclaredMethods(), _function);
    }

    @Override
    public Iterable<? extends MethodDeclaration> getDeclaredMethods() {
        return Iterables.filter(this.getDeclaredMembers(), MethodDeclaration.class);
    }

    @Override
    public Iterable<? extends FieldDeclaration> getDeclaredFields() {
        return Iterables.filter(this.getDeclaredMembers(), FieldDeclaration.class);
    }

    @Override
    public Iterable<? extends ClassDeclaration> getDeclaredClasses() {
        return Iterables.filter(this.getDeclaredMembers(), ClassDeclaration.class);
    }

    @Override
    public Iterable<? extends ConstructorDeclaration> getDeclaredConstructors() {
        return Iterables.filter(this.getDeclaredMembers(), ConstructorDeclaration.class);
    }

    @Override
    public Iterable<? extends InterfaceDeclaration> getDeclaredInterfaces() {
        return Iterables.filter(this.getDeclaredMembers(), InterfaceDeclaration.class);
    }

    @Override
    public Iterable<? extends AnnotationTypeDeclaration> getDeclaredAnnotationTypes() {
        return Iterables.filter(this.getDeclaredMembers(), AnnotationTypeDeclaration.class);
    }

    @Override
    public Iterable<? extends EnumerationTypeDeclaration> getDeclaredEnumerationTypes() {
        return Iterables.filter(this.getDeclaredMembers(), EnumerationTypeDeclaration.class);
    }

    @Override
    public Iterable<? extends TypeDeclaration> getDeclaredTypes() {
        return Iterables.filter(this.getDeclaredMembers(), TypeDeclaration.class);
    }
}

