/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.JvmTypeDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.JvmTypeParameterDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.PrimitiveTypeImpl;
import org.eclipse.xtend.core.macro.declaration.VoidTypeImpl;
import org.eclipse.xtend.core.macro.declaration.XtendTypeDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.PrimitiveType;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclarator;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.services.TypeReferenceProvider;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TypeReferenceProviderImpl
implements TypeReferenceProvider {
    @Extension
    private CompilationUnitImpl compilationUnit;

    public TypeReferenceProviderImpl(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    @Override
    public TypeReference getAnyType() {
        return this.compilationUnit.toTypeReference(this.compilationUnit.getTypeReferences().createAnyTypeReference(this.compilationUnit.getXtendFile()));
    }

    @Override
    public TypeReference getList(TypeReference param) {
        return this.newTypeReference("java.util.List", param);
    }

    @Override
    public TypeReference getObject() {
        return this.compilationUnit.toTypeReference(this.createTypeRef(this.compilationUnit.getTypeReferences().findDeclaredType(Object.class, (Notifier)this.compilationUnit.getXtendFile()), new JvmTypeReference[0]));
    }

    @Override
    public TypeReference getPrimitiveBoolean() {
        return this.newTypeReference("boolean", new TypeReference[0]);
    }

    @Override
    public TypeReference getPrimitiveByte() {
        return this.newTypeReference("byte", new TypeReference[0]);
    }

    @Override
    public TypeReference getPrimitiveChar() {
        return this.newTypeReference("char", new TypeReference[0]);
    }

    @Override
    public TypeReference getPrimitiveDouble() {
        return this.newTypeReference("double", new TypeReference[0]);
    }

    @Override
    public TypeReference getPrimitiveFloat() {
        return this.newTypeReference("float", new TypeReference[0]);
    }

    @Override
    public TypeReference getPrimitiveInt() {
        return this.newTypeReference("int", new TypeReference[0]);
    }

    @Override
    public TypeReference getPrimitiveLong() {
        return this.newTypeReference("long", new TypeReference[0]);
    }

    @Override
    public TypeReference getPrimitiveShort() {
        return this.newTypeReference("short", new TypeReference[0]);
    }

    @Override
    public TypeReference getPrimitiveVoid() {
        return this.newTypeReference("void", new TypeReference[0]);
    }

    @Override
    public TypeReference getSet(TypeReference param) {
        return this.newTypeReference("java.util.Set", param);
    }

    @Override
    public TypeReference getString() {
        return this.newTypeReference("java.lang.String", new TypeReference[0]);
    }

    @Override
    public TypeReference newArrayTypeReference(TypeReference componentType) {
        TypeReference _xblockexpression = null;
        this.compilationUnit.checkCanceled();
        _xblockexpression = this.compilationUnit.toTypeReference(this.compilationUnit.getTypeReferences().createArrayType(this.compilationUnit.toJvmTypeReference(componentType)));
        return _xblockexpression;
    }

    @Override
    public TypeReference newTypeReference(String typeName, TypeReference ... typeArguments) {
        TypeReference _xblockexpression = null;
        this.compilationUnit.checkCanceled();
        JvmType type = this.compilationUnit.getTypeReferences().findDeclaredType(typeName, (Notifier)this.compilationUnit.getXtendFile());
        if (type == null) {
            return null;
        }
        Functions.Function1<TypeReference, JvmTypeReference> _function = it -> this.compilationUnit.toJvmTypeReference((TypeReference)it);
        List<JvmTypeReference> _map = ListExtensions.map((List)Conversions.doWrapArray(typeArguments), _function);
        _xblockexpression = this.compilationUnit.toTypeReference(this.createTypeRef(type, (JvmTypeReference[])Conversions.unwrapArray(_map, JvmTypeReference.class)));
        return _xblockexpression;
    }

    public JvmParameterizedTypeReference createTypeRef(JvmType type, JvmTypeReference ... typeArgs) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        JvmParameterizedTypeReference reference = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        reference.setType(type);
        for (JvmTypeReference typeArg : typeArgs) {
            reference.getArguments().add(EcoreUtil2.cloneIfContained(typeArg));
        }
        if (type instanceof JvmGenericType) {
            EList<JvmTypeParameter> list = ((JvmGenericType)type).getTypeParameters();
            if (!reference.getArguments().isEmpty() && list.size() != reference.getArguments().size()) {
                String _identifier = ((JvmGenericType)type).getIdentifier();
                String _plus = "The type " + _identifier;
                String _plus_1 = _plus + " expects ";
                int _size = list.size();
                String _plus_2 = _plus_1 + Integer.valueOf(_size);
                String _plus_3 = _plus_2 + " type arguments, but was ";
                int _size_1 = reference.getArguments().size();
                String _plus_4 = _plus_3 + Integer.valueOf(_size_1);
                String _plus_5 = _plus_4 + ". Either pass zero arguments (raw type) or the correct number.";
                throw new IllegalArgumentException(_plus_5);
            }
        }
        return reference;
    }

    @Override
    public TypeReference newTypeReference(Type typeDeclaration, TypeReference ... typeArguments) {
        TypeReference _xblockexpression = null;
        this.compilationUnit.checkCanceled();
        JvmComponentType _switchResult = null;
        boolean _matched = false;
        if (typeDeclaration instanceof JvmTypeDeclarationImpl) {
            _matched = true;
            _switchResult = (JvmComponentType)((JvmTypeDeclarationImpl)((Object)typeDeclaration)).getDelegate();
        }
        if (!_matched && typeDeclaration instanceof XtendTypeDeclarationImpl) {
            _matched = true;
            _switchResult = this.compilationUnit.getJvmModelAssociations().getInferredType((XtendTypeDeclaration)((XtendTypeDeclarationImpl)typeDeclaration).getDelegate());
        }
        if (!_matched && typeDeclaration instanceof JvmTypeParameterDeclarationImpl) {
            _matched = true;
            _switchResult = (JvmComponentType)((JvmTypeParameterDeclarationImpl)typeDeclaration).getDelegate();
        }
        if (!_matched && typeDeclaration instanceof PrimitiveTypeImpl) {
            _matched = true;
            TypeReference _switchResult_1 = null;
            PrimitiveType.Kind _kind = ((PrimitiveTypeImpl)typeDeclaration).getKind();
            if (_kind != null) {
                switch (_kind) {
                    case BOOLEAN: {
                        _switchResult_1 = this.getPrimitiveBoolean();
                        break;
                    }
                    case BYTE: {
                        _switchResult_1 = this.getPrimitiveByte();
                        break;
                    }
                    case CHAR: {
                        _switchResult_1 = this.getPrimitiveChar();
                        break;
                    }
                    case DOUBLE: {
                        _switchResult_1 = this.getPrimitiveDouble();
                        break;
                    }
                    case FLOAT: {
                        _switchResult_1 = this.getPrimitiveFloat();
                        break;
                    }
                    case INT: {
                        _switchResult_1 = this.getPrimitiveInt();
                        break;
                    }
                    case LONG: {
                        _switchResult_1 = this.getPrimitiveLong();
                        break;
                    }
                    case SHORT: {
                        _switchResult_1 = this.getPrimitiveShort();
                        break;
                    }
                }
            }
            return _switchResult_1;
        }
        if (!_matched && typeDeclaration instanceof VoidTypeImpl) {
            _matched = true;
            return this.getPrimitiveVoid();
        }
        if (!_matched) {
            throw new IllegalArgumentException("couldn't construct type reference for type " + typeDeclaration);
        }
        JvmComponentType type = _switchResult;
        if (type == null) {
            return null;
        }
        Functions.Function1<TypeReference, JvmTypeReference> _function = it -> this.compilationUnit.toJvmTypeReference((TypeReference)it);
        List<JvmTypeReference> _map = ListExtensions.map((List)Conversions.doWrapArray(typeArguments), _function);
        _xblockexpression = this.compilationUnit.toTypeReference(this.createTypeRef(type, (JvmTypeReference[])Conversions.unwrapArray(_map, JvmTypeReference.class)));
        return _xblockexpression;
    }

    @Override
    public TypeReference newWildcardTypeReference() {
        return this.newWildcardTypeReference(null);
    }

    @Override
    public TypeReference newWildcardTypeReference(TypeReference upperBound) {
        TypeReference _xifexpression = null;
        _xifexpression = upperBound == null ? this.compilationUnit.toTypeReference(this.compilationUnit.getTypeReferences().wildCard()) : this.compilationUnit.toTypeReference(this.compilationUnit.getTypeReferences().wildCardExtends(this.compilationUnit.toJvmTypeReference(upperBound)));
        return _xifexpression;
    }

    @Override
    public TypeReference newWildcardTypeReferenceWithLowerBound(TypeReference lowerBound) {
        TypeReference _xifexpression = null;
        _xifexpression = lowerBound == null ? this.compilationUnit.toTypeReference(this.compilationUnit.getTypeReferences().wildCard()) : this.compilationUnit.toTypeReference(this.compilationUnit.getTypeReferences().wildCardSuper(this.compilationUnit.toJvmTypeReference(lowerBound)));
        return _xifexpression;
    }

    @Override
    public TypeReference newTypeReference(Class<?> clazz, TypeReference ... typeArguments) {
        return this.newTypeReference(clazz.getName(), typeArguments);
    }

    @Override
    public TypeReference newSelfTypeReference(Type typeDeclaration) {
        TypeReference _xifexpression = null;
        if (typeDeclaration instanceof TypeParameterDeclarator) {
            Functions.Function1<TypeParameterDeclaration, TypeReference> _function = it -> this.newTypeReference((Type)it, new TypeReference[0]);
            _xifexpression = this.newTypeReference(typeDeclaration, (TypeReference[])Conversions.unwrapArray(IterableExtensions.map(((TypeParameterDeclarator)((Object)typeDeclaration)).getTypeParameters(), _function), TypeReference.class));
        } else {
            _xifexpression = this.newTypeReference(typeDeclaration, new TypeReference[0]);
        }
        return _xifexpression;
    }
}

