/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.XtendTypeDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableEnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.services.SourceTypeLookup;
import org.eclipse.xtend.lib.macro.services.TypeLookup;
import org.eclipse.xtend.lib.macro.services.UpstreamTypeLookup;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtype.XtypePackage;

public class TypeLookupImpl
implements TypeLookup,
SourceTypeLookup,
UpstreamTypeLookup {
    @Extension
    private CompilationUnitImpl compilationUnit;

    public TypeLookupImpl(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    @Override
    public MutableAnnotationTypeDeclaration findAnnotationType(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableAnnotationTypeDeclaration _switchResult = null;
        boolean _matched = false;
        if (type instanceof MutableAnnotationTypeDeclaration) {
            _matched = true;
            _switchResult = (MutableAnnotationTypeDeclaration)type;
        }
        return _switchResult;
    }

    @Override
    public MutableClassDeclaration findClass(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableClassDeclaration _switchResult = null;
        boolean _matched = false;
        if (type instanceof MutableClassDeclaration) {
            _matched = true;
            _switchResult = (MutableClassDeclaration)type;
        }
        return _switchResult;
    }

    @Override
    public MutableEnumerationTypeDeclaration findEnumerationType(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableEnumerationTypeDeclaration _switchResult = null;
        boolean _matched = false;
        if (type instanceof MutableEnumerationTypeDeclaration) {
            _matched = true;
            _switchResult = (MutableEnumerationTypeDeclaration)type;
        }
        return _switchResult;
    }

    @Override
    public MutableInterfaceDeclaration findInterface(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableInterfaceDeclaration _switchResult = null;
        boolean _matched = false;
        if (type instanceof MutableInterfaceDeclaration) {
            _matched = true;
            _switchResult = (MutableInterfaceDeclaration)type;
        }
        return _switchResult;
    }

    private Type findType(String qualifiedName) {
        Functions.Function1<JvmDeclaredType, String> _function = type -> type.getQualifiedName('.');
        Functions.Function1<JvmDeclaredType, Iterable> _function_1 = type -> Iterables.filter(type.getMembers(), JvmDeclaredType.class);
        JvmDeclaredType result = this.recursiveFindType(qualifiedName, Iterables.filter(this.compilationUnit.getXtendFile().eResource().getContents(), JvmDeclaredType.class), _function, _function_1);
        Type _xifexpression = null;
        if (result != null) {
            _xifexpression = this.compilationUnit.toType(result);
        }
        return _xifexpression;
    }

    @Override
    public ClassDeclaration findSourceClass(String qualifiedName) {
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> type = this.findSourceType(qualifiedName);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _switchResult = null;
        boolean _matched = false;
        if (type instanceof ClassDeclaration) {
            _matched = true;
            _switchResult = type;
        }
        return (ClassDeclaration)((Object)_switchResult);
    }

    @Override
    public InterfaceDeclaration findSourceInterface(String qualifiedName) {
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> type = this.findSourceType(qualifiedName);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _switchResult = null;
        boolean _matched = false;
        if (type instanceof InterfaceDeclaration) {
            _matched = true;
            _switchResult = type;
        }
        return (InterfaceDeclaration)((Object)_switchResult);
    }

    @Override
    public EnumerationTypeDeclaration findSourceEnumerationType(String qualifiedName) {
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> type = this.findSourceType(qualifiedName);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _switchResult = null;
        boolean _matched = false;
        if (type instanceof EnumerationTypeDeclaration) {
            _matched = true;
            _switchResult = type;
        }
        return (EnumerationTypeDeclaration)((Object)_switchResult);
    }

    @Override
    public AnnotationTypeDeclaration findSourceAnnotationType(String qualifiedName) {
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> type = this.findSourceType(qualifiedName);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _switchResult = null;
        boolean _matched = false;
        if (type instanceof AnnotationTypeDeclaration) {
            _matched = true;
            _switchResult = type;
        }
        return (AnnotationTypeDeclaration)((Object)_switchResult);
    }

    private XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> findSourceType(String qualifiedName) {
        EObject _head = IterableExtensions.head(this.compilationUnit.getXtendFile().eResource().getContents());
        Functions.Function1<XtendTypeDeclaration, String> _function = type -> this.compilationUnit.getQualifiedNameConverter().toString(this.compilationUnit.getQualifiedNameProvider().getFullyQualifiedName((EObject)type));
        Functions.Function1<XtendTypeDeclaration, Iterable> _function_1 = type -> Iterables.filter(type.getMembers(), XtendTypeDeclaration.class);
        XtendTypeDeclaration result = this.recursiveFindType(qualifiedName, ((XtendFile)_head).getXtendTypes(), _function, _function_1);
        XtendTypeDeclarationImpl<? extends XtendTypeDeclaration> _xifexpression = null;
        if (result != null) {
            _xifexpression = this.compilationUnit.toXtendTypeDeclaration(result);
        }
        return _xifexpression;
    }

    private <T> T recursiveFindType(String qualifiedName, Iterable<? extends T> typeDeclarations, Functions.Function1<? super T, ? extends String> qualifiedNameProvider, Functions.Function1<? super T, ? extends Iterable<? extends T>> subTypeProvider) {
        int dot = 46;
        for (T type : typeDeclarations) {
            String name = qualifiedNameProvider.apply(type);
            boolean _equals = Objects.equal(qualifiedName, name);
            if (_equals) {
                return type;
            }
            if (!qualifiedName.startsWith(name) || qualifiedName.charAt(name.length()) != '.') continue;
            return this.recursiveFindType(qualifiedName, subTypeProvider.apply(type), qualifiedNameProvider, subTypeProvider);
        }
        return null;
    }

    @Override
    public Type findTypeGlobally(Class<?> clazz) {
        return this.findTypeGlobally(clazz.getCanonicalName());
    }

    @Override
    public Type findTypeGlobally(String typeName) {
        Type _elvis = null;
        Type _findType = this.findType(typeName);
        if (_findType != null) {
            _elvis = _findType;
        } else {
            Type _findTypeOnScope;
            Functions.Function1<IEObjectDescription, Boolean> _function = it -> true;
            _elvis = _findTypeOnScope = this.findTypeOnScope(typeName, _function);
        }
        return _elvis;
    }

    @Override
    public Type findUpstreamType(Class<?> clazz) {
        return this.findUpstreamType(clazz.getCanonicalName());
    }

    @Override
    public Type findUpstreamType(String typeName) {
        Functions.Function1<IEObjectDescription, Boolean> _function = it -> {
            Resource _eResource_1;
            Resource _eResource = it.getEObjectOrProxy().eResource();
            return !Objects.equal(_eResource, _eResource_1 = this.compilationUnit.getXtendFile().eResource());
        };
        return this.findTypeOnScope(typeName, _function);
    }

    private Type findTypeOnScope(String typeName, Functions.Function1<? super IEObjectDescription, ? extends Boolean> filter) {
        QualifiedName qualifiedName = this.compilationUnit.getQualifiedNameConverter().toQualifiedName(typeName);
        IEObjectDescription result = this.compilationUnit.getScopeProvider().getScope(this.compilationUnit.getXtendFile(), XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE).getSingleElement(qualifiedName);
        if (result != null && TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(result.getEClass()) && filter.apply(result).booleanValue()) {
            EObject _eObjectOrProxy = result.getEObjectOrProxy();
            return this.compilationUnit.toType((JvmType)_eObjectOrProxy);
        }
        return null;
    }
}

