/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.ExpressionImpl;
import org.eclipse.xtend.core.macro.declaration.JvmConstructorDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.JvmFieldDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.XtendConstructorDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;

public class MutableJvmFieldDeclarationImpl
extends JvmFieldDeclarationImpl
implements MutableFieldDeclaration {
    @Override
    public void markAsRead() {
        this.checkMutable();
        ((CompilationUnitImpl)this.getCompilationUnit()).getReadAndWriteTracking().markReadAccess((EObject)this.getDelegate());
    }

    @Override
    public void markAsInitializedBy(ConstructorDeclaration constructorDeclaration) {
        this.checkMutable();
        JvmConstructor _switchResult = null;
        boolean _matched = false;
        if (constructorDeclaration instanceof JvmConstructorDeclarationImpl) {
            _matched = true;
            _switchResult = (JvmConstructor)((JvmConstructorDeclarationImpl)constructorDeclaration).getDelegate();
        }
        if (!_matched && constructorDeclaration instanceof XtendConstructorDeclarationImpl) {
            _matched = true;
            JvmConstructor _xblockexpression = null;
            EObject jvmElement = ((CompilationUnitImpl)this.getCompilationUnit()).getJvmModelAssociations().getPrimaryJvmElement((EObject)((XtendConstructorDeclarationImpl)constructorDeclaration).getDelegate());
            JvmConstructor _xifexpression = null;
            if (jvmElement instanceof JvmConstructor) {
                _xifexpression = (JvmConstructor)jvmElement;
            }
            _switchResult = _xblockexpression = _xifexpression;
        }
        JvmConstructor constructor = _switchResult;
        ((CompilationUnitImpl)this.getCompilationUnit()).getReadAndWriteTracking().markInitialized((EObject)this.getDelegate(), constructor);
    }

    @Override
    public MutableTypeDeclaration getDeclaringType() {
        TypeDeclaration _declaringType = super.getDeclaringType();
        return (MutableTypeDeclaration)_declaringType;
    }

    @Override
    public void setInitializer(Expression initializer) {
        this.checkMutable();
        if (initializer == null) {
            ((CompilationUnitImpl)this.getCompilationUnit()).getJvmTypesBuilder().removeExistingBody((JvmMember)this.getDelegate());
        } else {
            ((CompilationUnitImpl)this.getCompilationUnit()).getJvmTypesBuilder().setInitializer((JvmField)this.getDelegate(), (XExpression)((ExpressionImpl)initializer).getDelegate());
        }
    }

    @Override
    public void setInitializer(CompilationStrategy initializer) {
        this.checkMutable();
        Preconditions.checkArgument(initializer != null, "initializer cannot be null");
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationStrategy((JvmField)this.getDelegate(), initializer);
    }

    @Override
    public void setInitializer(StringConcatenationClient template) {
        this.checkMutable();
        Preconditions.checkArgument(template != null, "template cannot be null");
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationTemplate((JvmField)this.getDelegate(), template);
    }

    @Override
    public void setFinal(boolean isFinal) {
        this.checkMutable();
        ((JvmField)this.getDelegate()).setFinal(isFinal);
    }

    @Override
    public void setStatic(boolean isStatic) {
        this.checkMutable();
        ((JvmField)this.getDelegate()).setStatic(isStatic);
    }

    @Override
    public void setTransient(boolean isTransient) {
        this.checkMutable();
        ((JvmField)this.getDelegate()).setTransient(isTransient);
    }

    @Override
    public void setVolatile(boolean isVolatile) {
        this.checkMutable();
        ((JvmField)this.getDelegate()).setVolatile(isVolatile);
    }

    @Override
    public void setType(TypeReference type) {
        this.checkMutable();
        Preconditions.checkArgument(type != null, "type cannot be null");
        ((JvmField)this.getDelegate()).setType(((CompilationUnitImpl)this.getCompilationUnit()).toJvmTypeReference(type));
    }

    @Override
    public void setConstantValueAsBoolean(final boolean value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(value);
            }
        };
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    private void internalGenericSetConstantValue(Object value) {
        this.checkMutable();
        Preconditions.checkArgument(value != null, "value cannot be null");
        JvmField _delegate = (JvmField)this.getDelegate();
        _delegate.setConstant(true);
        JvmField _delegate_1 = (JvmField)this.getDelegate();
        _delegate_1.setFinal(true);
        JvmField _delegate_2 = (JvmField)this.getDelegate();
        _delegate_2.setStatic(true);
        JvmField _delegate_3 = (JvmField)this.getDelegate();
        _delegate_3.setConstantValue(value);
    }

    @Override
    public void setConstantValueAsByte(final byte value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(value);
            }
        };
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    @Override
    public void setConstantValueAsInt(final int value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(value);
            }
        };
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    @Override
    public void setConstantValueAsShort(final short value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(value);
            }
        };
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    @Override
    public void setConstantValueAsLong(final long value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(value);
                _builder.append("L");
            }
        };
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    @Override
    public void setConstantValueAsFloat(final float value) {
        this.internalGenericSetConstantValue(Float.valueOf(value));
        StringConcatenationClient _client = new StringConcatenationClient(){

            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Float.valueOf(value));
                _builder.append("f");
            }
        };
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    @Override
    public void setConstantValueAsDouble(final double value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(value);
                _builder.append("d");
            }
        };
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    @Override
    public void setConstantValueAsChar(final char value) {
        this.internalGenericSetConstantValue(Character.valueOf(value));
        StringConcatenationClient _client = new StringConcatenationClient(){

            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("'");
                String _convertToJavaString = Strings.convertToJavaString(Character.toString(value));
                _builder.append(_convertToJavaString);
                _builder.append("'");
            }
        };
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }

    @Override
    public void setConstantValueAsString(final String value) {
        this.internalGenericSetConstantValue(value);
        StringConcatenationClient _client = new StringConcatenationClient(){

            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("\"");
                String _convertToJavaString = Strings.convertToJavaString(value);
                _builder.append(_convertToJavaString);
                _builder.append("\"");
            }
        };
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationTemplate((JvmField)this.getDelegate(), _client);
    }
}

