/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.JvmMemberDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public abstract class JvmTypeDeclarationImpl<T extends JvmDeclaredType>
extends JvmMemberDeclarationImpl<T> {
    public Iterable<? extends MemberDeclaration> getDeclaredMembers() {
        Functions.Function1<JvmMember, MemberDeclaration> _function = it -> ((CompilationUnitImpl)this.getCompilationUnit()).toMemberDeclaration((JvmMember)it);
        return ImmutableList.copyOf(ListExtensions.map(((JvmDeclaredType)this.getDelegate()).getMembers(), _function));
    }

    @Override
    public String getSimpleName() {
        return ((JvmDeclaredType)this.getDelegate()).getSimpleName();
    }

    public String getQualifiedName() {
        return ((JvmDeclaredType)this.getDelegate()).getQualifiedName('.');
    }

    public boolean isAssignableFrom(Type otherType) {
        if (otherType == null) {
            return false;
        }
        TypeReference thisTypeRef = ((CompilationUnitImpl)this.getCompilationUnit()).getTypeReferenceProvider().newTypeReference((Type)((Object)this), new TypeReference[0]);
        TypeReference thatTypeRef = ((CompilationUnitImpl)this.getCompilationUnit()).getTypeReferenceProvider().newTypeReference(otherType, new TypeReference[0]);
        return thisTypeRef.isAssignableFrom(thatTypeRef);
    }

    public MutableConstructorDeclaration addConstructor(Procedures.Procedure1<MutableConstructorDeclaration> initializer) {
        this.checkMutable();
        Preconditions.checkArgument(initializer != null, "initializer cannot be null");
        Functions.Function1<JvmConstructor, Boolean> _function = it -> ((CompilationUnitImpl)this.getCompilationUnit()).getTypeExtensions().isSingleSyntheticDefaultConstructor((JvmConstructor)it);
        JvmConstructor constructor = IterableExtensions.findFirst(Iterables.filter(((JvmDeclaredType)this.getDelegate()).getMembers(), JvmConstructor.class), _function);
        if (constructor != null) {
            EcoreUtil.remove(constructor);
        }
        JvmConstructor newConstructor = TypesFactory.eINSTANCE.createJvmConstructor();
        newConstructor.setVisibility(JvmVisibility.PUBLIC);
        newConstructor.setSimpleName(this.getSimpleName());
        ((JvmDeclaredType)this.getDelegate()).getMembers().add(newConstructor);
        MemberDeclaration _memberDeclaration = ((CompilationUnitImpl)this.getCompilationUnit()).toMemberDeclaration(newConstructor);
        MutableConstructorDeclaration mutableConstructorDeclaration = (MutableConstructorDeclaration)_memberDeclaration;
        initializer.apply(mutableConstructorDeclaration);
        return mutableConstructorDeclaration;
    }

    public MutableFieldDeclaration addField(String name, Procedures.Procedure1<MutableFieldDeclaration> initializer) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        Preconditions.checkArgument(initializer != null, "initializer cannot be null");
        JvmField newField = TypesFactory.eINSTANCE.createJvmField();
        newField.setSimpleName(name);
        newField.setVisibility(JvmVisibility.PRIVATE);
        ((JvmDeclaredType)this.getDelegate()).getMembers().add(newField);
        MemberDeclaration _memberDeclaration = ((CompilationUnitImpl)this.getCompilationUnit()).toMemberDeclaration(newField);
        MutableFieldDeclaration mutableFieldDeclaration = (MutableFieldDeclaration)_memberDeclaration;
        initializer.apply(mutableFieldDeclaration);
        return mutableFieldDeclaration;
    }

    public MutableMethodDeclaration addMethod(String name, Procedures.Procedure1<MutableMethodDeclaration> initializer) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        Preconditions.checkArgument(initializer != null, "initializer cannot be null");
        JvmOperation newMethod = TypesFactory.eINSTANCE.createJvmOperation();
        newMethod.setVisibility(JvmVisibility.PUBLIC);
        newMethod.setSimpleName(name);
        newMethod.setReturnType(((CompilationUnitImpl)this.getCompilationUnit()).toJvmTypeReference(((CompilationUnitImpl)this.getCompilationUnit()).getTypeReferenceProvider().getPrimitiveVoid()));
        ((JvmDeclaredType)this.getDelegate()).getMembers().add(newMethod);
        MemberDeclaration _memberDeclaration = ((CompilationUnitImpl)this.getCompilationUnit()).toMemberDeclaration(newMethod);
        MutableMethodDeclaration mutableMethodDeclaration = (MutableMethodDeclaration)_memberDeclaration;
        initializer.apply(mutableMethodDeclaration);
        return mutableMethodDeclaration;
    }

    public ConstructorDeclaration findDeclaredConstructor(TypeReference ... parameterTypes) {
        ConstructorDeclaration _xblockexpression = null;
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray(parameterTypes), "parameterTypes");
        Functions.Function1<ConstructorDeclaration, Boolean> _function = constructor -> {
            Functions.Function1<ParameterDeclaration, TypeReference> _function_1 = it -> it.getType();
            List<TypeReference> _list = IterableExtensions.toList(IterableExtensions.map(constructor.getParameters(), _function_1));
            List _list_1 = IterableExtensions.toList((Iterable)Conversions.doWrapArray(parameterTypes));
            return Objects.equal(_list, _list_1);
        };
        _xblockexpression = IterableExtensions.findFirst(this.getDeclaredConstructors(), _function);
        return _xblockexpression;
    }

    public FieldDeclaration findDeclaredField(String name) {
        Functions.Function1<FieldDeclaration, Boolean> _function = field -> {
            String _simpleName = field.getSimpleName();
            return Objects.equal(_simpleName, name);
        };
        return IterableExtensions.findFirst(this.getDeclaredFields(), _function);
    }

    public TypeDeclaration findDeclaredType(String name) {
        Functions.Function1<TypeDeclaration, Boolean> _function = type -> {
            String _simpleName = type.getSimpleName();
            return Objects.equal(_simpleName, name);
        };
        return IterableExtensions.findFirst(this.getDeclaredTypes(), _function);
    }

    public MethodDeclaration findDeclaredMethod(String name, TypeReference ... parameterTypes) {
        MethodDeclaration _xblockexpression = null;
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray(parameterTypes), "parameterTypes");
        Functions.Function1<MethodDeclaration, Boolean> _function = method -> Objects.equal(method.getSimpleName(), name) && Objects.equal(IterableExtensions.toList(IterableExtensions.map(method.getParameters(), it -> it.getType())), IterableExtensions.toList((Iterable)Conversions.doWrapArray(parameterTypes)));
        _xblockexpression = IterableExtensions.findFirst(this.getDeclaredMethods(), _function);
        return _xblockexpression;
    }

    public Iterable<? extends MethodDeclaration> getDeclaredMethods() {
        return Iterables.filter(this.getDeclaredMembers(), MethodDeclaration.class);
    }

    public Iterable<? extends FieldDeclaration> getDeclaredFields() {
        return Iterables.filter(this.getDeclaredMembers(), FieldDeclaration.class);
    }

    public Iterable<? extends ClassDeclaration> getDeclaredClasses() {
        return Iterables.filter(this.getDeclaredMembers(), ClassDeclaration.class);
    }

    public Iterable<? extends ConstructorDeclaration> getDeclaredConstructors() {
        return Iterables.filter(this.getDeclaredMembers(), ConstructorDeclaration.class);
    }

    public Iterable<? extends InterfaceDeclaration> getDeclaredInterfaces() {
        return Iterables.filter(this.getDeclaredMembers(), InterfaceDeclaration.class);
    }

    public Iterable<? extends TypeDeclaration> getDeclaredTypes() {
        return Iterables.filter(this.getDeclaredMembers(), TypeDeclaration.class);
    }

    public Iterable<? extends AnnotationTypeDeclaration> getDeclaredAnnotationTypes() {
        return Iterables.filter(this.getDeclaredMembers(), AnnotationTypeDeclaration.class);
    }

    public Iterable<? extends EnumerationTypeDeclaration> getDeclaredEnumerationTypes() {
        return Iterables.filter(this.getDeclaredMembers(), EnumerationTypeDeclaration.class);
    }

    @Override
    public void setSimpleName(String name) {
        throw new UnsupportedOperationException("The type cannot be renamed.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The type cannot be removed.");
    }
}

