/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.ExpressionImpl;
import org.eclipse.xtend.core.macro.declaration.JvmMemberDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public abstract class JvmExecutableDeclarationImpl<T extends JvmExecutable>
extends JvmMemberDeclarationImpl<T> {
    public Iterable<? extends TypeParameterDeclaration> getTypeParameters() {
        Functions.Function1<JvmTypeParameter, TypeParameterDeclaration> _function = it -> ((CompilationUnitImpl)this.getCompilationUnit()).toTypeParameterDeclaration((JvmTypeParameter)it);
        return ListExtensions.map(((JvmExecutable)this.getDelegate()).getTypeParameters(), _function);
    }

    public boolean isVarArgs() {
        return ((JvmExecutable)this.getDelegate()).isVarArgs();
    }

    public Iterable<? extends ParameterDeclaration> getParameters() {
        Functions.Function1<JvmFormalParameter, ParameterDeclaration> _function = it -> ((CompilationUnitImpl)this.getCompilationUnit()).toParameterDeclaration((JvmFormalParameter)it);
        return ListExtensions.map(((JvmExecutable)this.getDelegate()).getParameters(), _function);
    }

    public List<TypeReference> getExceptions() {
        Functions.Function1<JvmTypeReference, TypeReference> _function = it -> ((CompilationUnitImpl)this.getCompilationUnit()).toTypeReference((JvmTypeReference)it);
        return ListExtensions.map(((JvmExecutable)this.getDelegate()).getExceptions(), _function);
    }

    public Expression getBody() {
        Expression _xblockexpression = null;
        XExpression expression = ((CompilationUnitImpl)this.getCompilationUnit()).getJvmTypesBuilder().getExpression((JvmMember)this.getDelegate());
        _xblockexpression = ((CompilationUnitImpl)this.getCompilationUnit()).toExpression(expression);
        return _xblockexpression;
    }

    public void setBody(Expression body) {
        this.checkMutable();
        if (body == null) {
            ((CompilationUnitImpl)this.getCompilationUnit()).getJvmTypesBuilder().removeExistingBody((JvmMember)this.getDelegate());
        } else {
            ((CompilationUnitImpl)this.getCompilationUnit()).getJvmTypesBuilder().setBody((JvmExecutable)this.getDelegate(), (XExpression)((ExpressionImpl)body).getDelegate());
        }
    }

    public void setExceptions(TypeReference ... exceptions) {
        this.checkMutable();
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray(exceptions), "exceptions");
        ConditionUtils.checkInferredTypeReferences("exception type", exceptions);
        ((JvmExecutable)this.getDelegate()).getExceptions().clear();
        for (TypeReference exceptionType : exceptions) {
            if (exceptionType == null) continue;
            ((JvmExecutable)this.getDelegate()).getExceptions().add(((CompilationUnitImpl)this.getCompilationUnit()).toJvmTypeReference(exceptionType));
        }
    }

    public void setVarArgs(boolean isVarArgs) {
        this.checkMutable();
        ((JvmExecutable)this.getDelegate()).setVarArgs(isVarArgs);
    }

    public MutableTypeParameterDeclaration addTypeParameter(String name, TypeReference ... upperBounds) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray(upperBounds), "upperBounds");
        ConditionUtils.checkInferredTypeReferences("parameter type", upperBounds);
        JvmTypeParameter param = TypesFactory.eINSTANCE.createJvmTypeParameter();
        param.setName(name);
        ((JvmExecutable)this.getDelegate()).getTypeParameters().add(param);
        for (TypeReference upper : upperBounds) {
            JvmTypeReference typeRef = ((CompilationUnitImpl)this.getCompilationUnit()).toJvmTypeReference(upper);
            JvmUpperBound jvmUpperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
            jvmUpperBound.setTypeReference(typeRef);
            param.getConstraints().add(jvmUpperBound);
        }
        TypeParameterDeclaration _typeParameterDeclaration = ((CompilationUnitImpl)this.getCompilationUnit()).toTypeParameterDeclaration(param);
        return (MutableTypeParameterDeclaration)_typeParameterDeclaration;
    }

    public void setBody(CompilationStrategy compilationStrategy) {
        this.checkMutable();
        Preconditions.checkArgument(compilationStrategy != null, "compilationStrategy cannot be null");
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationStrategy((JvmExecutable)this.getDelegate(), compilationStrategy);
    }

    public void setBody(StringConcatenationClient compilationTemplate) {
        this.checkMutable();
        Preconditions.checkArgument(compilationTemplate != null, "compilationTemplate cannot be null");
        ((CompilationUnitImpl)this.getCompilationUnit()).setCompilationTemplate((JvmExecutable)this.getDelegate(), compilationTemplate);
    }

    public MutableParameterDeclaration addParameter(String name, TypeReference type) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        Preconditions.checkArgument(type != null, "type cannot be null");
        boolean _isInferred = type.isInferred();
        if (_isInferred) {
            throw new IllegalArgumentException("Cannot use inferred type as parameter type.");
        }
        JvmFormalParameter param = TypesFactory.eINSTANCE.createJvmFormalParameter();
        param.setName(name);
        param.setParameterType(((CompilationUnitImpl)this.getCompilationUnit()).toJvmTypeReference(type));
        ((JvmExecutable)this.getDelegate()).getParameters().add(param);
        ParameterDeclaration _parameterDeclaration = ((CompilationUnitImpl)this.getCompilationUnit()).toParameterDeclaration(param);
        return (MutableParameterDeclaration)_parameterDeclaration;
    }

    @Override
    public void remove() {
        ((CompilationUnitImpl)this.getCompilationUnit()).getJvmModelAssociator().removeLogicalChildAssociation((JvmIdentifiableElement)this.getDelegate());
        super.remove();
    }
}

