/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.declaration.JvmAnnotationReferenceImpl;
import org.eclipse.xtend.core.macro.declaration.JvmNamedElementImpl;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public abstract class JvmAnnotationTargetImpl<T extends JvmAnnotationTarget>
extends JvmNamedElementImpl<T> {
    public Iterable<? extends AnnotationReference> getAnnotations() {
        Functions.Function1<JvmAnnotationReference, AnnotationReference> _function = it -> this.getCompilationUnit().toAnnotationReference((JvmAnnotationReference)it);
        return ImmutableList.copyOf(ListExtensions.map(((JvmAnnotationTarget)this.getDelegate()).getAnnotations(), _function));
    }

    public AnnotationReference addAnnotation(AnnotationReference annotationReference) {
        AnnotationReference _xblockexpression = null;
        this.checkMutable();
        Preconditions.checkArgument(annotationReference != null, "annotationReference cannot be null");
        AnnotationReference _xifexpression = null;
        if (!(annotationReference instanceof JvmAnnotationReferenceImpl)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(annotationReference);
            _builder.append(" is not annotation reference");
            throw new IllegalArgumentException(_builder.toString());
        }
        AnnotationReference _xblockexpression_1 = null;
        JvmAnnotationReference jvmAnnotationReference = (JvmAnnotationReference)EcoreUtil2.cloneWithProxies((EObject)((JvmAnnotationReferenceImpl)annotationReference).getDelegate());
        EList<JvmAnnotationReference> _annotations = ((JvmAnnotationTarget)this.getDelegate()).getAnnotations();
        _annotations.add(jvmAnnotationReference);
        _xifexpression = _xblockexpression_1 = this.getCompilationUnit().toAnnotationReference(jvmAnnotationReference);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean removeAnnotation(AnnotationReference annotationReference) {
        this.checkMutable();
        if (annotationReference instanceof JvmAnnotationReferenceImpl) {
            return ((JvmAnnotationTarget)this.getDelegate()).getAnnotations().remove(((JvmAnnotationReferenceImpl)annotationReference).getDelegate());
        }
        return false;
    }

    public AnnotationReference findAnnotation(Type annotationType) {
        Functions.Function1<AnnotationReference, Boolean> _function = it -> {
            AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
            return Objects.equal(_annotationTypeDeclaration, annotationType);
        };
        return IterableExtensions.findFirst(this.getAnnotations(), _function);
    }
}

