/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.core.macro.declaration.IResourceChangeRegistry;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.file.MutableFileSystemSupport;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class ChangeListenerAddingFileSystemSupport
implements MutableFileSystemSupport {
    private final URI resourceURI;
    private final MutableFileSystemSupport delegate;
    private final IResourceChangeRegistry resourceChangeRegistry;

    @Override
    public void delete(Path path) {
        this.resourceChangeRegistry.registerCreateOrModify(path.toString(), this.getURI());
        this.delegate.delete(path);
    }

    @Override
    public void mkdir(Path path) {
        this.resourceChangeRegistry.registerCreateOrModify(path.toString(), this.getURI());
        this.delegate.mkdir(path);
    }

    @Override
    public void setContents(Path path, CharSequence contents) {
        this.resourceChangeRegistry.registerCreateOrModify(path.toString(), this.getURI());
        this.delegate.setContents(path, contents);
    }

    @Override
    public void setContentsAsStream(Path path, InputStream source) {
        this.resourceChangeRegistry.registerCreateOrModify(path.toString(), this.getURI());
        this.delegate.setContentsAsStream(path, source);
    }

    @Override
    public boolean exists(Path path) {
        this.resourceChangeRegistry.registerExists(path.toString(), this.getURI());
        return this.delegate.exists(path);
    }

    private URI getURI() {
        return this.resourceURI;
    }

    @Override
    public String getCharset(Path path) {
        this.resourceChangeRegistry.registerGetCharset(path.toString(), this.getURI());
        return this.delegate.getCharset(path);
    }

    @Override
    public Iterable<? extends Path> getChildren(Path path) {
        this.resourceChangeRegistry.registerGetChildren(path.toString(), this.getURI());
        return this.delegate.getChildren(path);
    }

    @Override
    public CharSequence getContents(Path path) {
        this.resourceChangeRegistry.registerGetContents(path.toString(), this.getURI());
        return this.delegate.getContents(path);
    }

    @Override
    public InputStream getContentsAsStream(Path path) {
        this.resourceChangeRegistry.registerGetContents(path.toString(), this.getURI());
        return this.delegate.getContentsAsStream(path);
    }

    @Override
    public long getLastModification(Path path) {
        this.resourceChangeRegistry.registerGetContents(path.toString(), this.getURI());
        return this.delegate.getLastModification(path);
    }

    @Override
    public boolean isFile(Path path) {
        this.resourceChangeRegistry.registerExists(path.toString(), this.getURI());
        return this.delegate.isFile(path);
    }

    @Override
    public boolean isFolder(Path path) {
        this.resourceChangeRegistry.registerExists(path.toString(), this.getURI());
        return this.delegate.isFolder(path);
    }

    @Override
    public java.net.URI toURI(Path path) {
        return this.delegate.toURI(path);
    }

    public ChangeListenerAddingFileSystemSupport(URI resourceURI, MutableFileSystemSupport delegate, IResourceChangeRegistry resourceChangeRegistry) {
        this.resourceURI = resourceURI;
        this.delegate = delegate;
        this.resourceChangeRegistry = resourceChangeRegistry;
    }

    @Pure
    public URI getResourceURI() {
        return this.resourceURI;
    }

    @Pure
    public MutableFileSystemSupport getDelegate() {
        return this.delegate;
    }

    @Pure
    public IResourceChangeRegistry getResourceChangeRegistry() {
        return this.resourceChangeRegistry;
    }
}

