/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.AnnotationReferenceBuildContextImpl;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.JvmAnnotationReferenceImpl;
import org.eclipse.xtend.core.macro.declaration.JvmAnnotationTypeDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.XtendAnnotationTypeDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.services.AnnotationReferenceBuildContext;
import org.eclipse.xtend.lib.macro.services.AnnotationReferenceProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class AnnotationReferenceProviderImpl
implements AnnotationReferenceProvider {
    @Extension
    private CompilationUnitImpl compilationUnit;

    public AnnotationReferenceProviderImpl(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    @Override
    public AnnotationReference newAnnotationReference(String annotationTypeName) {
        Procedures.Procedure1<AnnotationReferenceBuildContext> _function = it -> {};
        return this.newAnnotationReference(annotationTypeName, _function);
    }

    @Override
    public AnnotationReference newAnnotationReference(Type annotationTypeDelcaration) {
        Procedures.Procedure1<AnnotationReferenceBuildContext> _function = it -> {};
        return this.newAnnotationReference(annotationTypeDelcaration, _function);
    }

    @Override
    public AnnotationReference newAnnotationReference(Class<?> annotationClass) {
        Procedures.Procedure1<AnnotationReferenceBuildContext> _function = it -> {};
        return this.newAnnotationReference(annotationClass, _function);
    }

    @Override
    public AnnotationReference newAnnotationReference(AnnotationReference annotationReference) {
        Procedures.Procedure1<AnnotationReferenceBuildContext> _function = it -> {};
        return this.newAnnotationReference(annotationReference, _function);
    }

    @Override
    public AnnotationReference newAnnotationReference(String annotationTypeName, Procedures.Procedure1<AnnotationReferenceBuildContext> initializer) {
        AnnotationReference _xblockexpression = null;
        this.compilationUnit.checkCanceled();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("annotationTypeName cannot be null");
        Preconditions.checkArgument(annotationTypeName != null, _builder);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("initializer cannot be null");
        Preconditions.checkArgument(initializer != null, _builder_1);
        JvmAnnotationReference jvmAnnotationReference = this.createJvmAnnotationReference(this.compilationUnit.getTypeReferences().findDeclaredType(annotationTypeName, (Notifier)this.compilationUnit.getXtendFile()));
        if (jvmAnnotationReference == null) {
            return null;
        }
        AnnotationReferenceBuildContextImpl _annotationReferenceBuildContextImpl = new AnnotationReferenceBuildContextImpl();
        Procedures.Procedure1<AnnotationReferenceBuildContextImpl> _function = it -> {
            it.setDelegate(jvmAnnotationReference);
            it.setCompilationUnit(this.compilationUnit);
        };
        AnnotationReferenceBuildContextImpl buildContext = ObjectExtensions.operator_doubleArrow(_annotationReferenceBuildContextImpl, _function);
        initializer.apply(buildContext);
        _xblockexpression = this.compilationUnit.toAnnotationReference(jvmAnnotationReference);
        return _xblockexpression;
    }

    @Override
    public AnnotationReference newAnnotationReference(Type annotationTypeDelcaration, Procedures.Procedure1<AnnotationReferenceBuildContext> initializer) {
        Object _xblockexpression = null;
        this.compilationUnit.checkCanceled();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("annotationTypeDelcaration cannot be null");
        Preconditions.checkArgument(annotationTypeDelcaration != null, _builder);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("initializer cannot be null");
        Preconditions.checkArgument(initializer != null, _builder_1);
        JvmDeclaredType _switchResult = null;
        boolean _matched = false;
        if (annotationTypeDelcaration instanceof JvmAnnotationTypeDeclarationImpl) {
            _matched = true;
            _switchResult = (JvmDeclaredType)((JvmAnnotationTypeDeclarationImpl)annotationTypeDelcaration).getDelegate();
        }
        if (!_matched && annotationTypeDelcaration instanceof XtendAnnotationTypeDeclarationImpl) {
            _matched = true;
            _switchResult = this.compilationUnit.getJvmModelAssociations().getInferredType((XtendTypeDeclaration)((XtendAnnotationTypeDeclarationImpl)annotationTypeDelcaration).getDelegate());
        }
        if (!_matched) {
            throw new IllegalArgumentException("couldn't construct type reference for type " + annotationTypeDelcaration);
        }
        JvmDeclaredType type = _switchResult;
        if (type instanceof JvmAnnotationType) {
            JvmAnnotationReference newJvmAnnotationReference = this.createJvmAnnotationReference(type);
            AnnotationReferenceBuildContextImpl _annotationReferenceBuildContextImpl = new AnnotationReferenceBuildContextImpl();
            Procedures.Procedure1<AnnotationReferenceBuildContextImpl> _function = it -> {
                it.setDelegate(newJvmAnnotationReference);
                it.setCompilationUnit(this.compilationUnit);
            };
            AnnotationReferenceBuildContextImpl buildContext = ObjectExtensions.operator_doubleArrow(_annotationReferenceBuildContextImpl, _function);
            initializer.apply(buildContext);
            return this.compilationUnit.toAnnotationReference(newJvmAnnotationReference);
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    @Override
    public AnnotationReference newAnnotationReference(Class<?> annotationClass, Procedures.Procedure1<AnnotationReferenceBuildContext> initializer) {
        AnnotationReference _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("annotationClass cannot be null");
        Preconditions.checkArgument(annotationClass != null, _builder);
        _xblockexpression = this.newAnnotationReference(annotationClass.getName(), initializer);
        return _xblockexpression;
    }

    @Override
    public AnnotationReference newAnnotationReference(AnnotationReference annotationReference, Procedures.Procedure1<AnnotationReferenceBuildContext> initializer) {
        Object _xblockexpression = null;
        this.compilationUnit.checkCanceled();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("annotationReference cannot be null");
        Preconditions.checkArgument(annotationReference != null, _builder);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("initializer cannot be null");
        Preconditions.checkArgument(initializer != null, _builder_1);
        if (annotationReference instanceof JvmAnnotationReferenceImpl) {
            JvmAnnotationReference baseJvmAnnotationReference = (JvmAnnotationReference)((JvmAnnotationReferenceImpl)annotationReference).getDelegate();
            ConditionUtils.notRemoved(baseJvmAnnotationReference, "annotationReference");
            JvmAnnotationReference newJvmAnnotationReference = this.createJvmAnnotationReference(baseJvmAnnotationReference.getAnnotation());
            AnnotationReferenceBuildContextImpl _annotationReferenceBuildContextImpl = new AnnotationReferenceBuildContextImpl();
            Procedures.Procedure1<AnnotationReferenceBuildContextImpl> _function = it -> {
                it.setDelegate(newJvmAnnotationReference);
                it.setCompilationUnit(this.compilationUnit);
            };
            AnnotationReferenceBuildContextImpl buildContext = ObjectExtensions.operator_doubleArrow(_annotationReferenceBuildContextImpl, _function);
            Functions.Function1<JvmAnnotationValue, String> _function_1 = it -> {
                String _elvis = null;
                String _valueName = it.getValueName();
                _elvis = _valueName != null ? _valueName : "value";
                return _elvis;
            };
            List<String> _map = ListExtensions.map(baseJvmAnnotationReference.getExplicitValues(), _function_1);
            for (String valueName : _map) {
                Object value = ((JvmAnnotationReferenceImpl)annotationReference).getValue(valueName);
                buildContext.set(valueName, value);
            }
            initializer.apply(buildContext);
            return this.compilationUnit.toAnnotationReference(newJvmAnnotationReference);
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected boolean isArrayOfAnnotations(JvmAnnotationValue annotationValue) {
        JvmTypeReference returnType = annotationValue.getOperation().getReturnType();
        if (returnType instanceof JvmGenericArrayTypeReference) {
            JvmType _type = ((JvmGenericArrayTypeReference)returnType).getComponentType().getType();
            return _type instanceof JvmAnnotationType;
        }
        return false;
    }

    protected JvmAnnotationReference createJvmAnnotationReference(JvmType type) {
        JvmAnnotationReference _switchResult = null;
        boolean _matched = false;
        if (type instanceof JvmAnnotationType) {
            _matched = true;
            JvmAnnotationReference _createJvmAnnotationReference = TypesFactory.eINSTANCE.createJvmAnnotationReference();
            Procedures.Procedure1<JvmAnnotationReference> _function = it -> it.setAnnotation((JvmAnnotationType)type);
            _switchResult = ObjectExtensions.operator_doubleArrow(_createJvmAnnotationReference, _function);
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }
}

