/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.file.FileLocations;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class FileLocationsImpl
implements FileLocations {
    @Inject
    @Accessors
    private IProjectConfigProvider projectInformationProvider;
    @Inject
    @Accessors
    private IContextualOutputConfigurationProvider outputConfigurationProvider;
    @Accessors
    private Resource context;

    protected IProjectConfig getProjectConfig(Path path) {
        String firstSegment = path.getSegments().get(0);
        IProjectConfig projectConfig = this.projectInformationProvider.getProjectConfig(this.context.getResourceSet());
        if (projectConfig == null || !Objects.equal(projectConfig.getName(), firstSegment)) {
            throw new IllegalArgumentException("The project '" + firstSegment + "' has not been configured.");
        }
        return projectConfig;
    }

    @Override
    public Path getSourceFolder(Path path) {
        Functions.Function1<Path, Boolean> _function = sourceFolder -> path.startsWith((Path)sourceFolder);
        return IterableExtensions.findFirst(this.getProjectSourceFolders(path), _function);
    }

    @Override
    public Path getTargetFolder(Path path) {
        Path _xblockexpression = null;
        Path projectFolder = this.getProjectFolder(path);
        if (projectFolder == null) {
            return null;
        }
        OutputConfiguration outputConfiguration = IterableExtensions.head(this.outputConfigurationProvider.getOutputConfigurations(this.context));
        Path sourceFolder = this.getSourceFolder(path);
        String _xifexpression = null;
        if (sourceFolder == null) {
            _xifexpression = outputConfiguration.getOutputDirectory();
        } else {
            String _xblockexpression_1 = null;
            String projectRelativeSourceFolder = IterableExtensions.join(IterableExtensions.tail(sourceFolder.getSegments()), "/");
            _xifexpression = _xblockexpression_1 = outputConfiguration.getOutputDirectory(projectRelativeSourceFolder);
        }
        String outputFolder = _xifexpression;
        _xblockexpression = projectFolder.append(outputFolder);
        return _xblockexpression;
    }

    @Override
    public Path getProjectFolder(Path path) {
        IProjectConfig config = this.getProjectConfig(path);
        return Path.ROOT.append(config.getName());
    }

    @Override
    public Set<Path> getProjectSourceFolders(Path path) {
        Functions.Function1<ISourceFolder, Path> _function = it -> this.getProjectFolder(path).append(it.getName());
        return IterableExtensions.toSet(IterableExtensions.map(this.getProjectConfig(path).getSourceFolders(), _function));
    }

    @Pure
    public IProjectConfigProvider getProjectInformationProvider() {
        return this.projectInformationProvider;
    }

    public void setProjectInformationProvider(IProjectConfigProvider projectInformationProvider) {
        this.projectInformationProvider = projectInformationProvider;
    }

    @Pure
    public IContextualOutputConfigurationProvider getOutputConfigurationProvider() {
        return this.outputConfigurationProvider;
    }

    public void setOutputConfigurationProvider(IContextualOutputConfigurationProvider outputConfigurationProvider) {
        this.outputConfigurationProvider = outputConfigurationProvider;
    }

    @Pure
    public Resource getContext() {
        return this.context;
    }

    public void setContext(Resource context) {
        this.context = context;
    }
}

