/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.collect.Iterables;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.ActiveAnnotationContext;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class ActiveAnnotationContexts
extends AdapterImpl {
    @Accessors
    private final Map<JvmAnnotationType, ActiveAnnotationContext> contexts = CollectionLiterals.newLinkedHashMap();
    protected CompilationUnitImpl compilationUnit;
    private boolean running;

    public void before(AnnotationCallback phase) {
        this.compilationUnit.before(phase);
        this.running = true;
    }

    public void after(AnnotationCallback phase) {
        this.running = false;
        this.compilationUnit.after(phase);
    }

    public static ActiveAnnotationContexts installNew(Resource resource) {
        ActiveAnnotationContexts result = IterableExtensions.head(Iterables.filter(resource.eAdapters(), ActiveAnnotationContexts.class));
        if (result != null) {
            result.contexts.clear();
        } else {
            ActiveAnnotationContexts _activeAnnotationContexts;
            result = _activeAnnotationContexts = new ActiveAnnotationContexts();
            EList<Adapter> _eAdapters = resource.eAdapters();
            _eAdapters.add(result);
        }
        return result;
    }

    @Override
    public void notifyChanged(Notification msg) {
        if (!this.running && !msg.isTouch() && 2 == msg.getFeatureID(Resource.class)) {
            Object _notifier = msg.getNotifier();
            Resource resource = (Resource)_notifier;
            resource.eAdapters().remove(this);
            this.contexts.clear();
            this.compilationUnit = null;
        }
    }

    public static ActiveAnnotationContexts find(Resource resource) {
        return IterableExtensions.head(Iterables.filter(resource.eAdapters(), ActiveAnnotationContexts.class));
    }

    @Pure
    public Map<JvmAnnotationType, ActiveAnnotationContext> getContexts() {
        return this.contexts;
    }

    public static enum AnnotationCallback {
        INDEXING,
        INFERENCE,
        VALIDATION,
        GENERATION;

    }
}

