/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.jvmmodel.SyntheticNameClashResolver;
import org.eclipse.xtend.core.jvmmodel.XtendCompileStrategies;
import org.eclipse.xtend.core.macro.ActiveAnnotationContext;
import org.eclipse.xtend.core.macro.ActiveAnnotationContextProvider;
import org.eclipse.xtend.core.macro.ActiveAnnotationContexts;
import org.eclipse.xtend.core.macro.AnnotationProcessor;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.CreateExtensionInfo;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendEnumLiteral;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.documentation.IFileHeaderProvider;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.compiler.DisableCodeGenerationAdapter;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.jvmmodel.AbstractModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.resource.BatchLinkableResource;

public class XtendJvmModelInferrer
extends AbstractModelInferrer {
    public static final String CREATE_INITIALIZER_PREFIX = "_init_";
    public static final String CREATE_CHACHE_VARIABLE_PREFIX = "_createCache_";
    private static final Logger logger = Logger.getLogger(XtendJvmModelInferrer.class);
    @Inject
    private TypesFactory typesFactory;
    @Inject
    private IJvmModelAssociator associator;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private DispatchHelper dispatchHelper;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private XtendCompileStrategies compileStrategies;
    @Inject
    private JvmTypesBuilder jvmTypesBuilder;
    @Inject
    private SyntheticNameClashResolver nameClashResolver;
    @Inject
    private JvmTypeExtensions typeExtensions;
    @Inject
    private IFileHeaderProvider fileHeaderProvider;
    @Inject
    private AnnotationProcessor annotationProcessor;
    @Inject
    private ActiveAnnotationContextProvider contextProvider;
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private GeneratorConfig generatorConfig;
    private Predicate<XAnnotation> annotationTranslationFilter = new Predicate<XAnnotation>(){

        @Override
        public boolean apply(XAnnotation annotation) {
            if (annotation == null || annotation.getAnnotationType() == null) {
                return false;
            }
            JvmType annotationType = annotation.getAnnotationType();
            return !(annotationType instanceof JvmAnnotationType) || !DisableCodeGenerationAdapter.isDisabled((JvmDeclaredType)annotationType);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void infer(EObject object, final IJvmDeclaredTypeAcceptor acceptor, boolean preIndexingPhase) {
        if (!(object instanceof XtendFile)) {
            return;
        }
        final LinkedHashSet types = new LinkedHashSet();
        IJvmDeclaredTypeAcceptor wrapper = new IJvmDeclaredTypeAcceptor(){

            @Override
            public <T extends JvmDeclaredType> IJvmDeclaredTypeAcceptor.IPostIndexingInitializing<T> accept(T type) {
                types.add(type);
                return acceptor.accept(type);
            }

            @Override
            public <T extends JvmDeclaredType> void accept(T type, Procedures.Procedure1<? super T> lateInitialization) {
                types.add(type);
                acceptor.accept(type, lateInitialization);
            }
        };
        final XtendFile xtendFile = (XtendFile)object;
        this.generatorConfig = this.generatorConfigProvider.get(xtendFile);
        final ArrayList<Runnable> doLater = Lists.newArrayList();
        for (XtendTypeDeclaration declaration : xtendFile.getXtendTypes()) {
            this.inferTypeSceleton(declaration, wrapper, preIndexingPhase, xtendFile, doLater, null);
        }
        ActiveAnnotationContexts contexts = null;
        BatchLinkableResource resource = (BatchLinkableResource)xtendFile.eResource();
        try {
            this.compilerPhases.setIndexing(xtendFile, true);
            try {
                contexts = this.contextProvider.computeContext(xtendFile);
            }
            catch (Throwable t) {
                this.operationCanceledManager.propagateAsErrorIfCancelException(t);
                logger.error("Couldn't create annotation contexts", t);
                this.compilerPhases.setIndexing(xtendFile, false);
                resource.getCache().clear(resource);
                return;
            }
            try {
                contexts.before(ActiveAnnotationContexts.AnnotationCallback.INDEXING);
                for (ActiveAnnotationContext ctx : contexts.getContexts().values()) {
                    try {
                        this.annotationProcessor.indexingPhase(ctx, wrapper, CancelIndicator.NullImpl);
                    }
                    catch (Throwable t) {
                        this.operationCanceledManager.propagateAsErrorIfCancelException(t);
                        ctx.handleProcessingError(xtendFile.eResource(), t);
                    }
                }
            }
            finally {
                contexts.after(ActiveAnnotationContexts.AnnotationCallback.INDEXING);
            }
        }
        finally {
            this.compilerPhases.setIndexing(xtendFile, false);
            resource.getCache().clear(resource);
        }
        if (!preIndexingPhase) {
            final ActiveAnnotationContexts finalContexts = contexts;
            Runnable lateInit = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (Runnable runnable : doLater) {
                        runnable.run();
                    }
                    try {
                        finalContexts.before(ActiveAnnotationContexts.AnnotationCallback.INFERENCE);
                        for (ActiveAnnotationContext ctx : finalContexts.getContexts().values()) {
                            try {
                                XtendJvmModelInferrer.this.annotationProcessor.inferencePhase(ctx, CancelIndicator.NullImpl);
                            }
                            catch (Throwable t) {
                                XtendJvmModelInferrer.this.operationCanceledManager.propagateAsErrorIfCancelException(t);
                                ctx.handleProcessingError(xtendFile.eResource(), t);
                            }
                        }
                    }
                    finally {
                        finalContexts.after(ActiveAnnotationContexts.AnnotationCallback.INFERENCE);
                    }
                }
            };
            resource.addJvmMemberInitializer(lateInit);
        }
    }

    protected void inferTypeSceleton(XtendTypeDeclaration declaration, IJvmDeclaredTypeAcceptor acceptor, boolean preIndexingPhase, XtendFile xtendFile, List<Runnable> doLater, JvmDeclaredType containerSceleton) {
        JvmDeclaredType inferredSceleton = this.doInferTypeSceleton(declaration, acceptor, preIndexingPhase, xtendFile, doLater);
        if (inferredSceleton != null) {
            this.setNameAndAssociate(xtendFile, declaration, inferredSceleton);
            if (containerSceleton != null) {
                containerSceleton.getMembers().add(inferredSceleton);
            }
            acceptor.accept(inferredSceleton);
            for (XtendMember member : declaration.getMembers()) {
                if (!(member instanceof XtendTypeDeclaration)) continue;
                this.inferTypeSceleton((XtendTypeDeclaration)member, acceptor, preIndexingPhase, xtendFile, doLater, inferredSceleton);
            }
        }
    }

    protected JvmDeclaredType doInferTypeSceleton(final XtendTypeDeclaration declaration, IJvmDeclaredTypeAcceptor acceptor, boolean preIndexingPhase, XtendFile xtendFile, List<Runnable> doLater) {
        if (Strings.isEmpty(declaration.getName())) {
            return null;
        }
        if (declaration instanceof XtendAnnotationType) {
            final JvmAnnotationType annotation = this.typesFactory.createJvmAnnotationType();
            if (!preIndexingPhase) {
                doLater.add(new Runnable(){

                    @Override
                    public void run() {
                        XtendJvmModelInferrer.this.initialize((XtendAnnotationType)declaration, annotation);
                    }
                });
            }
            return annotation;
        }
        if (declaration instanceof XtendClass) {
            XtendClass xtendClass = (XtendClass)declaration;
            final JvmGenericType javaType = this.typesFactory.createJvmGenericType();
            this.copyTypeParameters(xtendClass.getTypeParameters(), javaType);
            if (!preIndexingPhase) {
                doLater.add(new Runnable(){

                    @Override
                    public void run() {
                        XtendJvmModelInferrer.this.initialize((XtendClass)declaration, javaType);
                    }
                });
            }
            return javaType;
        }
        if (declaration instanceof XtendInterface) {
            XtendInterface xtendInterface = (XtendInterface)declaration;
            final JvmGenericType javaType = this.typesFactory.createJvmGenericType();
            javaType.setInterface(true);
            this.copyTypeParameters(xtendInterface.getTypeParameters(), javaType);
            if (!preIndexingPhase) {
                doLater.add(new Runnable(){

                    @Override
                    public void run() {
                        XtendJvmModelInferrer.this.initialize((XtendInterface)declaration, javaType);
                    }
                });
            }
            return javaType;
        }
        if (declaration instanceof XtendEnum) {
            final JvmEnumerationType javaType = this.typesFactory.createJvmEnumerationType();
            if (!preIndexingPhase) {
                doLater.add(new Runnable(){

                    @Override
                    public void run() {
                        XtendJvmModelInferrer.this.initialize((XtendEnum)declaration, javaType);
                    }
                });
            }
            return javaType;
        }
        return null;
    }

    protected void setNameAndAssociate(XtendFile file, XtendTypeDeclaration xtendType, JvmDeclaredType javaType) {
        javaType.setPackageName(file.getPackage());
        javaType.setSimpleName(xtendType.getName());
        javaType.setVisibility(JvmVisibility.PUBLIC);
        this.setFileHeader(file, javaType);
        this.associator.associatePrimary(xtendType, javaType);
    }

    protected void setFileHeader(XtendFile xtendFile, JvmDeclaredType jvmDeclaredType) {
        String headerText = this.fileHeaderProvider.getFileHeader(xtendFile.eResource());
        this.jvmTypesBuilder.setFileHeader(jvmDeclaredType, headerText);
    }

    protected void initialize(XtendAnnotationType source, JvmAnnotationType inferredJvmType) {
        inferredJvmType.setVisibility(source.getVisibility());
        inferredJvmType.setStatic(source.isStatic() && !this.isTopLevel(source));
        inferredJvmType.setAbstract(true);
        this.translateAnnotationsTo(source.getAnnotations(), inferredJvmType);
        this.jvmTypesBuilder.copyDocumentationTo(source, inferredJvmType);
        for (XtendMember member : source.getMembers()) {
            XtendField field;
            if (!(member instanceof XtendField) || Strings.isEmpty((field = (XtendField)member).getName())) continue;
            JvmOperation operation = this.typesFactory.createJvmOperation();
            this.associator.associatePrimary(member, operation);
            operation.setSimpleName(field.getName());
            JvmTypeReference returnType = null;
            XExpression initialValue = field.getInitialValue();
            if (field.getType() != null) {
                returnType = this.jvmTypesBuilder.cloneWithProxies(field.getType());
            } else if (initialValue != null) {
                returnType = this.jvmTypesBuilder.inferredType(initialValue);
            }
            operation.setReturnType(returnType);
            if (initialValue != null) {
                JvmAnnotationValue jvmAnnotationValue = this.jvmTypesBuilder.toJvmAnnotationValue(initialValue);
                if (jvmAnnotationValue != null) {
                    operation.setDefaultValue(jvmAnnotationValue);
                    jvmAnnotationValue.setOperation(operation);
                }
                this.jvmTypesBuilder.setBody((JvmExecutable)operation, initialValue);
            }
            operation.setVisibility(JvmVisibility.PUBLIC);
            this.translateAnnotationsTo(member.getAnnotations(), operation);
            this.jvmTypesBuilder.copyDocumentationTo(member, operation);
            inferredJvmType.getMembers().add(operation);
        }
    }

    protected void translateAnnotationsTo(List<XAnnotation> annotations, JvmAnnotationTarget target) {
        this.jvmTypesBuilder.addAnnotations(target, Iterables.filter(annotations, this.annotationTranslationFilter));
    }

    protected void initialize(XtendClass source, JvmGenericType inferredJvmType) {
        boolean isStatic;
        inferredJvmType.setVisibility(source.getVisibility());
        boolean bl = isStatic = source.isStatic() && !this.isTopLevel(source);
        if (!isStatic) {
            JvmDeclaredType declaringType = inferredJvmType.getDeclaringType();
            if (declaringType instanceof JvmGenericType) {
                if (((JvmGenericType)declaringType).isInterface()) {
                    isStatic = true;
                }
            } else if (declaringType instanceof JvmAnnotationType) {
                isStatic = true;
            }
        }
        inferredJvmType.setStatic(isStatic);
        inferredJvmType.setAbstract(source.isAbstract());
        inferredJvmType.setStrictFloatingPoint(source.isStrictFloatingPoint());
        if (!inferredJvmType.isAbstract()) {
            inferredJvmType.setFinal(source.isFinal());
        }
        this.translateAnnotationsTo(source.getAnnotations(), inferredJvmType);
        JvmTypeReference extendsClause = source.getExtends();
        if (extendsClause == null || extendsClause.getType() == null) {
            JvmTypeReference typeRefToObject = this.typeReferences.getTypeForName(Object.class, (Notifier)source, new JvmTypeReference[0]);
            if (typeRefToObject != null) {
                inferredJvmType.getSuperTypes().add(typeRefToObject);
            }
        } else {
            inferredJvmType.getSuperTypes().add(this.jvmTypesBuilder.cloneWithProxies(extendsClause));
        }
        for (JvmTypeReference intf : source.getImplements()) {
            inferredJvmType.getSuperTypes().add(this.jvmTypesBuilder.cloneWithProxies(intf));
        }
        this.fixTypeParameters(inferredJvmType);
        this.addDefaultConstructor(source, inferredJvmType);
        for (XtendMember member : source.getMembers()) {
            if (!(member instanceof XtendField) && (!(member instanceof XtendFunction) || ((XtendFunction)member).getName() == null) && !(member instanceof XtendConstructor)) continue;
            this.transform(member, inferredJvmType, true);
        }
        this.appendSyntheticDispatchMethods(source, inferredJvmType);
        this.jvmTypesBuilder.copyDocumentationTo(source, inferredJvmType);
        this.nameClashResolver.resolveNameClashes(inferredJvmType);
    }

    protected void initialize(XtendInterface source, JvmGenericType inferredJvmType) {
        inferredJvmType.setVisibility(source.getVisibility());
        inferredJvmType.setStatic(source.isStatic() && !this.isTopLevel(source));
        inferredJvmType.setAbstract(true);
        inferredJvmType.setStrictFloatingPoint(source.isStrictFloatingPoint());
        this.translateAnnotationsTo(source.getAnnotations(), inferredJvmType);
        for (JvmTypeReference intf : source.getExtends()) {
            inferredJvmType.getSuperTypes().add(this.jvmTypesBuilder.cloneWithProxies(intf));
        }
        this.fixTypeParameters(inferredJvmType);
        for (XtendMember member : source.getMembers()) {
            if (!(member instanceof XtendField) && (!(member instanceof XtendFunction) || ((XtendFunction)member).getName() == null)) continue;
            this.transform(member, inferredJvmType, false);
        }
        this.jvmTypesBuilder.copyDocumentationTo(source, inferredJvmType);
        this.nameClashResolver.resolveNameClashes(inferredJvmType);
    }

    protected void initialize(XtendEnum source, JvmEnumerationType inferredJvmType) {
        inferredJvmType.setVisibility(source.getVisibility());
        inferredJvmType.setStatic(source.isStatic() && !this.isTopLevel(source));
        this.translateAnnotationsTo(source.getAnnotations(), inferredJvmType);
        for (XtendMember member : source.getMembers()) {
            if (!(member instanceof XtendEnumLiteral)) continue;
            this.transform((XtendEnumLiteral)member, inferredJvmType);
        }
        this.jvmTypesBuilder.copyDocumentationTo(source, inferredJvmType);
    }

    protected boolean isTopLevel(XtendTypeDeclaration declaration) {
        return declaration.eContainingFeature() == XtendPackage.Literals.XTEND_FILE__XTEND_TYPES;
    }

    protected void copyAndFixTypeParameters(List<JvmTypeParameter> typeParameters, JvmTypeParameterDeclarator target) {
        this.copyTypeParameters(typeParameters, target);
        this.fixTypeParameters(target);
    }

    protected void copyTypeParameters(List<JvmTypeParameter> typeParameters, JvmTypeParameterDeclarator target) {
        for (JvmTypeParameter typeParameter : typeParameters) {
            JvmTypeParameter clonedTypeParameter;
            if (Strings.isEmpty(typeParameter.getName()) || (clonedTypeParameter = this.jvmTypesBuilder.cloneWithProxies(typeParameter)) == null) continue;
            target.getTypeParameters().add(clonedTypeParameter);
            this.associator.associate(typeParameter, clonedTypeParameter);
        }
    }

    protected void fixTypeParameters(JvmTypeParameterDeclarator target) {
        for (JvmTypeParameter typeParameter : target.getTypeParameters()) {
            boolean upperBoundSeen = false;
            for (JvmTypeConstraint constraint : typeParameter.getConstraints()) {
                if (!(constraint instanceof JvmUpperBound)) continue;
                upperBoundSeen = true;
                break;
            }
            if (upperBoundSeen) continue;
            JvmUpperBound upperBound = this.typesFactory.createJvmUpperBound();
            upperBound.setTypeReference(this.typeReferences.getTypeForName(Object.class, (Notifier)target, new JvmTypeReference[0]));
            typeParameter.getConstraints().add(upperBound);
        }
    }

    protected void appendSyntheticDispatchMethods(XtendTypeDeclaration source, final JvmGenericType target) {
        ListMultimap<DispatchHelper.DispatchSignature, JvmOperation> methods = this.dispatchHelper.getDeclaredOrEnhancedDispatchMethods(target);
        for (DispatchHelper.DispatchSignature signature : methods.keySet()) {
            Collection operations = methods.get((Object)signature);
            Iterable<JvmOperation> localOperations = Iterables.filter(operations, new Predicate<JvmOperation>(){

                @Override
                public boolean apply(JvmOperation input) {
                    return target == input.eContainer();
                }
            });
            JvmOperation operation = this.deriveGenericDispatchOperationSignature(localOperations, target);
            if (operation == null) continue;
            this.dispatchHelper.markAsDispatcherFunction(operation);
            operation.setSimpleName(signature.getSimpleName());
            operation.setReturnType(this.jvmTypesBuilder.inferredType());
        }
    }

    protected JvmOperation deriveGenericDispatchOperationSignature(Iterable<JvmOperation> localOperations, JvmGenericType target) {
        Iterator<JvmOperation> iterator = localOperations.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        JvmOperation first = iterator.next();
        JvmOperation result = this.typesFactory.createJvmOperation();
        target.getMembers().add(result);
        for (int i = 0; i < first.getParameters().size(); ++i) {
            JvmFormalParameter parameter = this.typesFactory.createJvmFormalParameter();
            result.getParameters().add(parameter);
            parameter.setParameterType(this.jvmTypesBuilder.inferredType());
            JvmFormalParameter parameter2 = (JvmFormalParameter)first.getParameters().get(i);
            parameter.setName(parameter2.getName());
        }
        this.jvmTypesBuilder.setBody((JvmExecutable)result, this.compileStrategies.forDispatcher(result));
        JvmVisibility commonVisibility = null;
        boolean isFirst = true;
        boolean allStatic = true;
        boolean override = false;
        for (JvmOperation jvmOperation : localOperations) {
            Iterable<XtendFunction> xtendFunctions = Iterables.filter(this.associations.getSourceElements(jvmOperation), XtendFunction.class);
            for (XtendFunction func : xtendFunctions) {
                JvmVisibility xtendVisibility = func.getDeclaredVisibility();
                if (isFirst) {
                    commonVisibility = xtendVisibility;
                    isFirst = false;
                } else if (commonVisibility != xtendVisibility) {
                    commonVisibility = null;
                }
                this.associator.associate(func, result);
                if (!func.isStatic()) {
                    allStatic = false;
                }
                if (!func.isOverride()) continue;
                override = true;
            }
            for (JvmTypeReference declaredException : jvmOperation.getExceptions()) {
                result.getExceptions().add(this.jvmTypesBuilder.cloneWithProxies(declaredException));
            }
        }
        if (commonVisibility == null) {
            result.setVisibility(JvmVisibility.PUBLIC);
        } else {
            result.setVisibility(commonVisibility);
        }
        result.setStatic(allStatic);
        if (override) {
            this.setOverride(result);
        }
        return result;
    }

    protected void addDefaultConstructor(XtendClass source, JvmGenericType target) {
        for (XtendMember member : source.getMembers()) {
            if (!(member instanceof XtendConstructor)) continue;
            return;
        }
        JvmConstructor constructor = this.typesFactory.createJvmConstructor();
        target.getMembers().add(constructor);
        this.associator.associate(source, constructor);
        constructor.setSimpleName(source.getName());
        constructor.setVisibility(JvmVisibility.PUBLIC);
        this.typeExtensions.setSynthetic(constructor, true);
    }

    protected void transform(XtendMember sourceMember, JvmGenericType container, boolean allowDispatch) {
        if (sourceMember instanceof XtendFunction) {
            this.transform((XtendFunction)sourceMember, container, allowDispatch);
        } else if (sourceMember instanceof XtendField) {
            this.transform((XtendField)sourceMember, container);
        } else if (sourceMember instanceof XtendConstructor) {
            this.transform((XtendConstructor)sourceMember, container);
        } else if (sourceMember instanceof XtendEnumLiteral && container instanceof JvmEnumerationType) {
            this.transform((XtendEnumLiteral)sourceMember, (JvmEnumerationType)((Object)container));
        } else {
            throw new IllegalArgumentException("Cannot transform " + String.valueOf(sourceMember) + " to a JvmMember");
        }
    }

    protected void transform(XtendFunction source, JvmGenericType container, boolean allowDispatch) {
        JvmOperation operation = this.typesFactory.createJvmOperation();
        operation.setAbstract(source.isAbstract());
        operation.setNative(source.isNative());
        operation.setSynchronized(source.isSynchonized());
        operation.setStrictFloatingPoint(source.isStrictFloatingPoint());
        if (!source.isAbstract()) {
            operation.setFinal(source.isFinal());
        }
        container.getMembers().add(operation);
        this.associator.associatePrimary(source, operation);
        String sourceName = source.getName();
        JvmVisibility visibility = source.getVisibility();
        if (allowDispatch && source.isDispatch()) {
            if (source.getDeclaredVisibility() == null) {
                visibility = JvmVisibility.PROTECTED;
            }
            sourceName = "_" + sourceName;
        }
        operation.setSimpleName(sourceName);
        operation.setVisibility(visibility);
        operation.setStatic(source.isStatic());
        if (!operation.isAbstract() && !operation.isStatic() && container.isInterface()) {
            operation.setDefault(true);
        }
        for (XtendParameter parameter : source.getParameters()) {
            this.translateParameter(operation, parameter);
        }
        XExpression expression = source.getExpression();
        CreateExtensionInfo createExtensionInfo = source.getCreateExtensionInfo();
        JvmTypeReference returnType = null;
        returnType = source.getReturnType() != null ? this.jvmTypesBuilder.cloneWithProxies(source.getReturnType()) : (createExtensionInfo != null ? this.jvmTypesBuilder.inferredType(createExtensionInfo.getCreateExpression()) : (expression != null ? this.jvmTypesBuilder.inferredType(expression) : this.jvmTypesBuilder.inferredType()));
        operation.setReturnType(returnType);
        this.copyAndFixTypeParameters(source.getTypeParameters(), operation);
        for (JvmTypeReference exception : source.getExceptions()) {
            operation.getExceptions().add(this.jvmTypesBuilder.cloneWithProxies(exception));
        }
        this.translateAnnotationsTo(source.getAnnotations(), operation);
        if (source.isOverride() && this.typeReferences.findDeclaredType(Override.class, (Notifier)source) != null) {
            this.setOverride(operation);
        }
        if (createExtensionInfo != null) {
            this.transformCreateExtension(source, createExtensionInfo, container, operation, returnType);
        } else {
            this.setBody(operation, expression);
        }
        this.jvmTypesBuilder.copyDocumentationTo(source, operation);
    }

    protected void setOverride(JvmOperation operation) {
        if (this.generatorConfig.getJavaSourceVersion().isAtLeast(JavaVersion.JAVA6) && !this.containsAnnotation(operation, Override.class)) {
            operation.getAnnotations().add(this._annotationTypesBuilder.annotationRef(Override.class, new String[0]));
        }
    }

    private boolean containsAnnotation(JvmAnnotationTarget annotationTarget, Class<? extends Annotation> annotationClass) {
        for (JvmAnnotationReference annotationRef : annotationTarget.getAnnotations()) {
            if (!annotationClass.getName().equals(annotationRef.getAnnotation().getIdentifier())) continue;
            return true;
        }
        return false;
    }

    protected void setBody(JvmExecutable executable, XExpression expression) {
        this.associator.associateLogicalContainer(expression, executable);
        this.initializeLocalTypes(executable, expression);
    }

    protected void transformCreateExtension(XtendFunction source, CreateExtensionInfo createExtensionInfo, JvmGenericType container, JvmOperation operation, JvmTypeReference returnType) {
        JvmField cacheVar = this.jvmTypesBuilder.toField(source, CREATE_CHACHE_VARIABLE_PREFIX + source.getName(), this.jvmTypesBuilder.inferredType());
        if (cacheVar != null) {
            cacheVar.setFinal(true);
            this.jvmTypesBuilder.setInitializer(cacheVar, this.compileStrategies.forCacheVariable(source));
            container.getMembers().add(cacheVar);
            JvmOperation initializer = this.typesFactory.createJvmOperation();
            container.getMembers().add(initializer);
            initializer.setSimpleName(CREATE_INITIALIZER_PREFIX + source.getName());
            initializer.setVisibility(JvmVisibility.PRIVATE);
            initializer.setReturnType(this.typeReferences.getTypeForName(Void.TYPE, (Notifier)source, new JvmTypeReference[0]));
            for (JvmTypeReference exception : source.getExceptions()) {
                initializer.getExceptions().add(this.jvmTypesBuilder.cloneWithProxies(exception));
            }
            this.jvmTypesBuilder.setBody((JvmExecutable)operation, this.compileStrategies.forCacheMethod(createExtensionInfo, cacheVar, initializer));
            JvmFormalParameter jvmParam = this.typesFactory.createJvmFormalParameter();
            jvmParam.setName(createExtensionInfo.getName());
            jvmParam.setParameterType(this.jvmTypesBuilder.inferredType());
            initializer.getParameters().add(jvmParam);
            this.associator.associate(createExtensionInfo, jvmParam);
            for (XtendParameter parameter : source.getParameters()) {
                jvmParam = this.typesFactory.createJvmFormalParameter();
                jvmParam.setName(parameter.getName());
                jvmParam.setParameterType(this.jvmTypesBuilder.cloneWithProxies(parameter.getParameterType()));
                initializer.getParameters().add(jvmParam);
                this.associator.associate(parameter, jvmParam);
            }
            this.associator.associate(source, initializer);
            this.setBody(operation, createExtensionInfo.getCreateExpression());
            this.setBody(initializer, source.getExpression());
        }
    }

    protected void translateParameter(JvmExecutable executable, XtendParameter parameter) {
        JvmFormalParameter jvmParam = this.typesFactory.createJvmFormalParameter();
        jvmParam.setName(parameter.getName());
        if (parameter.isVarArg()) {
            executable.setVarArgs(true);
            JvmGenericArrayTypeReference arrayType = this.typeReferences.createArrayType(this.jvmTypesBuilder.cloneWithProxies(parameter.getParameterType()));
            jvmParam.setParameterType(arrayType);
        } else {
            jvmParam.setParameterType(this.jvmTypesBuilder.cloneWithProxies(parameter.getParameterType()));
        }
        this.associator.associate(parameter, jvmParam);
        this.translateAnnotationsTo(parameter.getAnnotations(), jvmParam);
        if (parameter.isExtension() && this.typeReferences.findDeclaredType(Extension.class, (Notifier)parameter) != null) {
            jvmParam.getAnnotations().add(this._annotationTypesBuilder.annotationRef(Extension.class, new String[0]));
        }
        executable.getParameters().add(jvmParam);
    }

    protected void transform(XtendConstructor source, JvmGenericType container) {
        JvmConstructor constructor = this.typesFactory.createJvmConstructor();
        container.getMembers().add(constructor);
        this.associator.associatePrimary(source, constructor);
        JvmVisibility visibility = source.getVisibility();
        constructor.setSimpleName(container.getSimpleName());
        constructor.setVisibility(visibility);
        for (XtendParameter parameter : source.getParameters()) {
            this.translateParameter(constructor, parameter);
        }
        this.copyAndFixTypeParameters(source.getTypeParameters(), constructor);
        for (JvmTypeReference exception : source.getExceptions()) {
            constructor.getExceptions().add(this.jvmTypesBuilder.cloneWithProxies(exception));
        }
        this.translateAnnotationsTo(source.getAnnotations(), constructor);
        this.setBody(constructor, source.getExpression());
        this.jvmTypesBuilder.copyDocumentationTo(source, constructor);
    }

    protected void transform(XtendField source, JvmGenericType container) {
        if (source.isExtension() && source.getType() != null || source.getName() != null) {
            JvmField field = this.typesFactory.createJvmField();
            String computeFieldName = this.computeFieldName(source);
            field.setSimpleName(computeFieldName);
            container.getMembers().add(field);
            this.associator.associatePrimary(source, field);
            field.setVisibility(source.getVisibility());
            field.setStatic(source.isStatic());
            field.setTransient(source.isTransient());
            field.setVolatile(source.isVolatile());
            field.setFinal(source.isFinal());
            if (source.getType() != null) {
                field.setType(this.jvmTypesBuilder.cloneWithProxies(source.getType()));
            } else if (source.getInitialValue() != null) {
                field.setType(this.jvmTypesBuilder.inferredType(source.getInitialValue()));
            }
            for (XAnnotation anno : source.getAnnotations()) {
                JvmAnnotationReference annotationReference;
                if (!this.annotationTranslationFilter.apply(anno) || (annotationReference = this.jvmTypesBuilder.getJvmAnnotationReference(anno)) == null) continue;
                field.getAnnotations().add(annotationReference);
            }
            if (source.isExtension() && this.typeReferences.findDeclaredType(Extension.class, (Notifier)source) != null) {
                field.getAnnotations().add(this._annotationTypesBuilder.annotationRef(Extension.class, new String[0]));
            }
            this.jvmTypesBuilder.copyDocumentationTo(source, field);
            this.jvmTypesBuilder.setInitializer(field, source.getInitialValue());
            this.initializeLocalTypes(field, source.getInitialValue());
        }
    }

    protected void transform(XtendEnumLiteral literal, JvmEnumerationType container) {
        if (literal.getName() == null) {
            return;
        }
        JvmEnumerationLiteral jvmLiteral = this.typesFactory.createJvmEnumerationLiteral();
        this.associator.associatePrimary(literal, jvmLiteral);
        jvmLiteral.setSimpleName(literal.getName());
        jvmLiteral.setVisibility(JvmVisibility.PUBLIC);
        jvmLiteral.setStatic(true);
        jvmLiteral.setFinal(true);
        this.jvmTypesBuilder.copyDocumentationTo(literal, jvmLiteral);
        for (XAnnotation anno : literal.getAnnotations()) {
            JvmAnnotationReference annotationReference;
            if (!this.annotationTranslationFilter.apply(anno) || (annotationReference = this.jvmTypesBuilder.getJvmAnnotationReference(anno)) == null) continue;
            jvmLiteral.getAnnotations().add(annotationReference);
        }
        container.getMembers().add(jvmLiteral);
    }

    protected String computeFieldName(XtendField field) {
        if (field.getName() != null) {
            return field.getName();
        }
        JvmTypeReference type = field.getType();
        String name = null;
        if (type != null) {
            List<INode> nodes;
            while (type instanceof JvmGenericArrayTypeReference) {
                type = ((JvmGenericArrayTypeReference)type).getComponentType();
            }
            if (type instanceof JvmParameterizedTypeReference && !(nodes = NodeModelUtils.findNodesForFeature(type, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE)).isEmpty()) {
                String typeName = nodes.get(0).getText().trim();
                int lastDot = typeName.lastIndexOf(46);
                if (lastDot != -1) {
                    typeName = typeName.substring(lastDot + 1);
                }
                name = "_" + Strings.toFirstLower(typeName);
            }
        }
        return name;
    }

    private void initializeLocalTypes(JvmFeature feature, XExpression expression) {
        if (expression != null) {
            TreeIterator<EObject> iterator = EcoreUtil2.getAllNonDerivedContents(expression, true);
            String nameStub = "__" + feature.getDeclaringType().getSimpleName();
            while (iterator.hasNext()) {
                EObject next = (EObject)iterator.next();
                if (next.eClass() != XtendPackage.Literals.ANONYMOUS_CLASS) continue;
                this.inferLocalClass((AnonymousClass)next, nameStub, feature);
                iterator.prune();
            }
        }
    }

    public void inferLocalClass(AnonymousClass anonymousClass, String localClassName, JvmFeature container) {
        JvmGenericType inferredType = this.typesFactory.createJvmGenericType();
        inferredType.setSimpleName(localClassName);
        inferredType.setAnonymous(!this.hasAdditionalMembers(anonymousClass));
        inferredType.setFinal(true);
        inferredType.setVisibility(JvmVisibility.DEFAULT);
        inferredType.getSuperTypes().add(this.jvmTypesBuilder.inferredType(anonymousClass));
        container.getLocalClasses().add(inferredType);
        this.associator.associatePrimary(anonymousClass, inferredType);
        for (XtendMember member : anonymousClass.getMembers()) {
            if (!(member instanceof XtendField) && (!(member instanceof XtendFunction) || ((XtendFunction)member).getName() == null) && !(member instanceof XtendConstructor)) continue;
            this.transform(member, inferredType, true);
        }
        this.appendSyntheticDispatchMethods(anonymousClass, inferredType);
        this.nameClashResolver.resolveNameClashes(inferredType);
        XConstructorCall constructorCall = anonymousClass.getConstructorCall();
        for (XExpression actualParameter : constructorCall.getArguments()) {
            this.associator.associateLogicalContainer(actualParameter, container);
        }
    }

    protected boolean hasAdditionalMembers(AnonymousClass anonymousClass) {
        for (XtendMember member : anonymousClass.getMembers()) {
            if (!(member instanceof XtendField) && (!(member instanceof XtendFunction) || ((XtendFunction)member).isOverride())) continue;
            return true;
        }
        return false;
    }
}

