/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.util.Strings;

public class SyntheticNameClashResolver {
    @Inject
    private IXtendJvmAssociations associations;

    public void resolveNameClashes(JvmGenericType type) {
        String simpleName;
        HashMultimap<String, JvmIdentifiableElement> classScope = HashMultimap.create();
        ArrayList<JvmMember> renameableMembers = Lists.newArrayList();
        int i = 1;
        for (JvmMember member : type.getMembers()) {
            simpleName = member.getSimpleName();
            if (simpleName != null) {
                if (!this.isRenameable(member)) {
                    classScope.put(simpleName, member);
                } else {
                    renameableMembers.add(member);
                }
            }
            if (!(member instanceof JvmFeature)) continue;
            for (JvmGenericType localType : ((JvmFeature)member).getLocalClasses()) {
                localType.setSimpleName(localType.getSimpleName() + '_' + i++);
            }
        }
        for (JvmMember renameable : renameableMembers) {
            if (this.collides(renameable, simpleName = renameable.getSimpleName(), classScope)) {
                String currentName;
                int count = 0;
                do {
                    if (count != Integer.MAX_VALUE) continue;
                    throw new IllegalStateException("Cannot find a collision-free name for " + renameable.getIdentifier());
                } while (this.collides(renameable, currentName = simpleName + "_" + ++count, classScope));
                renameable.setSimpleName(currentName);
                classScope.put(currentName, renameable);
                continue;
            }
            classScope.put(simpleName, renameable);
        }
    }

    protected boolean collides(JvmIdentifiableElement element, String currentName, Multimap<String, JvmIdentifiableElement> scope) {
        if (scope.containsKey(currentName)) {
            if (element instanceof JvmOperation) {
                for (JvmIdentifiableElement other : scope.get(currentName)) {
                    if (other instanceof JvmOperation && ((JvmOperation)element).getParameters().size() != ((JvmOperation)other).getParameters().size()) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isRenameable(JvmIdentifiableElement element) {
        String simpleName = element.getSimpleName();
        if (!simpleName.startsWith("_")) {
            return false;
        }
        EObject source = this.associations.getPrimarySourceElement(element);
        return this.isCreateExtension(source) && (simpleName.startsWith("_createCache_") || simpleName.startsWith("_init_")) || this.isAnonymousExtensionField(source);
    }

    protected boolean isAnonymousExtensionField(EObject source) {
        return source instanceof XtendField && ((XtendField)source).isExtension() && Strings.isEmpty(((XtendField)source).getName());
    }

    protected boolean isCreateExtension(EObject source) {
        return source instanceof XtendFunction && ((XtendFunction)source).getCreateExtensionInfo() != null;
    }
}

