/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.TreeAppendableUtil;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class DispatchMethodCompileStrategy
implements Procedures.Procedure1<ITreeAppendable> {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TreeAppendableUtil treeAppendableUtil;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private DispatchHelper sorter;
    private JvmOperation dispatchOperation;

    protected void initialize(JvmOperation dispatchOperation) {
        this.dispatchOperation = dispatchOperation;
    }

    @Override
    public void apply(ITreeAppendable a) {
        if (a == null) {
            throw new IllegalArgumentException("a is never null");
        }
        boolean needsElse = true;
        int parameterCount = this.dispatchOperation.getParameters().size();
        List<JvmOperation> sortedDispatchOperations = this.sorter.getAllDispatchCases(this.dispatchOperation);
        boolean[] allCasesSameType = new boolean[parameterCount];
        block0: for (int i = 0; i < parameterCount; ++i) {
            allCasesSameType[i] = true;
            JvmTypeReference dispatchParameterType = ((JvmFormalParameter)this.dispatchOperation.getParameters().get(i)).getParameterType();
            for (JvmOperation operation : sortedDispatchOperations) {
                JvmFormalParameter parameter = (JvmFormalParameter)operation.getParameters().get(i);
                JvmTypeReference caseParameterType = parameter.getParameterType();
                if (Strings.equal(dispatchParameterType.getIdentifier(), caseParameterType.getIdentifier())) continue;
                allCasesSameType[i] = false;
                continue block0;
            }
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, this.dispatchOperation);
        for (JvmOperation operation : sortedDispatchOperations) {
            ITreeAppendable operationAppendable = this.treeAppendableUtil.traceSignificant(a, operation, true);
            ArrayList<Later> laters = Lists.newArrayList();
            for (int i = 0; i < parameterCount; ++i) {
                JvmFormalParameter dispatchParam = (JvmFormalParameter)this.dispatchOperation.getParameters().get(i);
                final LightweightTypeReference dispatchParamType = owner.toLightweightTypeReference(dispatchParam.getParameterType());
                JvmFormalParameter caseParam = (JvmFormalParameter)operation.getParameters().get(i);
                final LightweightTypeReference caseParamType = owner.toLightweightTypeReference(caseParam.getParameterType());
                final String name = this.getVarName(dispatchParam, operationAppendable);
                if (caseParamType.isType(Void.class)) {
                    laters.add(new Later(){

                        @Override
                        public void exec(ITreeAppendable appendable) {
                            appendable.append(name).append(" == null");
                        }
                    });
                    continue;
                }
                if (allCasesSameType[i]) continue;
                laters.add(new Later(){

                    @Override
                    public void exec(ITreeAppendable appendable) {
                        TypeConformanceComputationArgument rawNoSynonyms = new TypeConformanceComputationArgument(true, false, true, true, false, false);
                        if (caseParamType.isAssignableFrom(dispatchParamType, rawNoSynonyms) && !dispatchParamType.isPrimitive()) {
                            appendable.append(name).append(" != null");
                        } else {
                            appendable.append(name).append(" instanceof ");
                            JvmType type = caseParamType.getWrapperTypeIfPrimitive().getType();
                            if (type == null) {
                                throw new IllegalStateException(String.valueOf(caseParamType));
                            }
                            appendable.append(type);
                        }
                    }
                });
            }
            if (sortedDispatchOperations.get(0) != operation) {
                operationAppendable.append(" else ");
            }
            if (laters.isEmpty()) {
                needsElse = false;
                if (sortedDispatchOperations.size() != 1) {
                    operationAppendable.append("{").increaseIndentation();
                    operationAppendable.newLine();
                }
            } else {
                operationAppendable.append("if (");
                operationAppendable.increaseIndentation().increaseIndentation();
                Iterator iterator = laters.iterator();
                while (iterator.hasNext()) {
                    ((Later)iterator.next()).exec(operationAppendable);
                    if (!iterator.hasNext()) continue;
                    operationAppendable.newLine().append(" && ");
                }
                operationAppendable.decreaseIndentation().decreaseIndentation();
                operationAppendable.append(") {").increaseIndentation();
                operationAppendable.newLine();
            }
            boolean isCurrentVoid = this.typeReferences.is(operation.getReturnType(), Void.TYPE);
            boolean isDispatchVoid = this.typeReferences.is(this.dispatchOperation.getReturnType(), Void.TYPE);
            if (isDispatchVoid) {
                this.generateActualDispatchCall(this.dispatchOperation, operation, operationAppendable, owner);
                operationAppendable.append(";").newLine().append("return;");
            } else {
                if (isCurrentVoid) {
                    this.generateActualDispatchCall(this.dispatchOperation, operation, operationAppendable, owner);
                    operationAppendable.append(";").newLine().append("return null");
                } else {
                    operationAppendable.append("return ");
                    this.generateActualDispatchCall(this.dispatchOperation, operation, operationAppendable, owner);
                }
                operationAppendable.append(";");
            }
            if (sortedDispatchOperations.size() == 1) continue;
            operationAppendable.decreaseIndentation();
            a.newLine().append("}");
        }
        if (needsElse) {
            a.append(" else {").increaseIndentation();
            a.newLine();
            a.increaseIndentation();
            a.append("throw new IllegalArgumentException(\"Unhandled parameter types: \" +").newLine();
            JvmType jvmType = this.typeReferences.findDeclaredType("java.util.Arrays", (Notifier)this.dispatchOperation);
            if (jvmType != null) {
                a.append(jvmType);
            } else {
                a.append(Arrays.class.getSimpleName());
            }
            a.append(".<Object>asList(");
            Iterator iterator = this.dispatchOperation.getParameters().iterator();
            while (iterator.hasNext()) {
                JvmFormalParameter parameter = (JvmFormalParameter)iterator.next();
                String name = this.getVarName(parameter, a);
                a.append(name);
                if (!iterator.hasNext()) continue;
                a.append(", ");
            }
            a.append(").toString());");
            a.decreaseIndentation();
            a.decreaseIndentation().newLine().append("}");
        }
    }

    protected void generateActualDispatchCall(JvmOperation dispatchOperation, JvmOperation actualOperationToCall, ITreeAppendable a, ITypeReferenceOwner owner) {
        a.append(actualOperationToCall.getSimpleName()).append("(");
        Iterator iter1 = dispatchOperation.getParameters().iterator();
        Iterator iter2 = actualOperationToCall.getParameters().iterator();
        while (iter2.hasNext()) {
            JvmFormalParameter p1 = (JvmFormalParameter)iter1.next();
            JvmFormalParameter p2 = (JvmFormalParameter)iter2.next();
            LightweightTypeReference type1 = owner.toLightweightTypeReference(p1.getParameterType());
            LightweightTypeReference type2 = owner.toLightweightTypeReference(p2.getParameterType());
            if (!type2.isAssignableFrom(type1, new TypeConformanceComputationArgument(true, false, true, true, false, false))) {
                a.append("(").append(type2.getWrapperTypeIfPrimitive()).append(")");
            }
            if (this.typeReferences.is(p2.getParameterType(), Void.class)) {
                a.append("null");
            } else {
                a.append(this.getVarName(p1, a));
            }
            if (!iter2.hasNext()) continue;
            a.append(", ");
        }
        a.append(")");
    }

    protected String getVarName(JvmIdentifiableElement ex, IAppendable appendable) {
        return appendable.getName(ex);
    }
}

