/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend.core.xtend.CreateExtensionInfo;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceInitializer;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class CacheMethodCompileStrategy
implements Procedures.Procedure1<ITreeAppendable> {
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;
    @Inject
    private XbaseCompiler compiler;
    @Inject
    private CommonTypeComputationServices services;
    private CreateExtensionInfo createExtensionInfo;
    private JvmOperation initializerMethod;
    private JvmField cacheField;

    protected void init(CreateExtensionInfo createExtensionInfo, JvmField cacheField, JvmOperation initializerMethod) {
        this.createExtensionInfo = createExtensionInfo;
        this.initializerMethod = initializerMethod;
        this.cacheField = cacheField;
    }

    @Override
    public void apply(ITreeAppendable appendable) {
        JvmOperation cacheMethod = (JvmOperation)this.logicalContainerProvider.getLogicalContainer(this.createExtensionInfo.getCreateExpression());
        JvmDeclaredType containerType = cacheMethod.getDeclaringType();
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes(containerType);
        final StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, containerType);
        LightweightTypeReference listType = owner.newReferenceTo(ArrayList.class, (TypeReferenceInitializer<? super ParameterizedTypeReference>)new TypeReferenceInitializer<ParameterizedTypeReference>(){

            @Override
            public LightweightTypeReference enhance(ParameterizedTypeReference reference) {
                reference.addTypeArgument(owner.newWildcardTypeReference());
                return reference;
            }
        });
        String cacheVarName = this.cacheField.getSimpleName();
        String cacheKeyVarName = appendable.declareSyntheticVariable("CacheKey", "_cacheKey");
        appendable.append("final ").append(listType).append(" ").append(cacheKeyVarName).append(" = ").append(CollectionLiterals.class).append(".newArrayList(");
        EList<JvmFormalParameter> list = cacheMethod.getParameters();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JvmFormalParameter jvmFormalParameter = (JvmFormalParameter)iterator.next();
            appendable.append(this.getVarName(jvmFormalParameter));
            if (!iterator.hasNext()) continue;
            appendable.append(", ");
        }
        appendable.append(");");
        LightweightTypeReference returnType = resolvedTypes.getActualType((JvmIdentifiableElement)this.initializerMethod.getParameters().get(0));
        if (returnType != null) {
            appendable.newLine().append("final ").append(returnType);
        } else {
            appendable.newLine().append("final Object");
        }
        String resultVarName = "_result";
        appendable.append(" ").append(resultVarName).append(";");
        appendable.newLine().append("synchronized (").append(cacheVarName).append(") {");
        appendable.increaseIndentation();
        appendable.newLine().append("if (").append(cacheVarName).append(".containsKey(").append(cacheKeyVarName).append(")) {");
        appendable.increaseIndentation();
        appendable.newLine().append("return ").append(cacheVarName).append(".get(").append(cacheKeyVarName).append(");");
        appendable.decreaseIndentation().newLine().append("}");
        this.compiler.toJavaStatement(this.createExtensionInfo.getCreateExpression(), appendable, true);
        appendable.newLine();
        appendable.append(resultVarName).append(" = ");
        this.compiler.toJavaExpression(this.createExtensionInfo.getCreateExpression(), appendable);
        appendable.append(";");
        appendable.newLine().append(cacheVarName).append(".put(").append(cacheKeyVarName).append(", ");
        LightweightTypeReference fieldType = resolvedTypes.getActualType(this.cacheField);
        LightweightTypeReference declaredResultType = fieldType.getTypeArguments().get(1);
        boolean castRequired = false;
        if (!declaredResultType.isAssignableFrom(returnType)) {
            castRequired = true;
            appendable.append("(").append(declaredResultType).append(")");
        }
        appendable.append(resultVarName).append(");");
        appendable.decreaseIndentation();
        appendable.newLine().append("}");
        appendable.newLine().append(this.initializerMethod.getSimpleName()).append("(").append(resultVarName);
        for (JvmFormalParameter parameter : cacheMethod.getParameters()) {
            appendable.append(", ").append(parameter.getName());
        }
        appendable.append(");");
        appendable.newLine().append("return ");
        if (castRequired) {
            appendable.append("(").append(declaredResultType).append(")");
        }
        appendable.append(resultVarName).append(";");
    }

    protected String getVarName(JvmIdentifiableElement ex) {
        return ex.getSimpleName();
    }
}

