/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.javaconverter;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ASTFlattenerUtils {
    public boolean isDummyType(AbstractTypeDeclaration it) {
        if (it instanceof TypeDeclaration) {
            return "MISSING".equals(((TypeDeclaration)it).getName().getIdentifier()) && !((TypeDeclaration)it).isInterface() && ((TypeDeclaration)it).getModifiers() == 0;
        }
        return false;
    }

    public boolean isOverrideMethod(MethodDeclaration declaration) {
        Functions.Function1<Annotation, Boolean> _function = it -> {
            String _string = it.getTypeName().toString();
            return Objects.equal("Override", _string);
        };
        boolean _exists = IterableExtensions.exists(Iterables.filter(declaration.modifiers(), Annotation.class), _function);
        if (_exists) {
            return true;
        }
        IMethodBinding iMethodBinding = declaration.resolveBinding();
        if (iMethodBinding != null) {
            IMethodBinding _findOverride = this.findOverride(iMethodBinding, iMethodBinding.getDeclaringClass());
            return _findOverride != null;
        }
        return false;
    }

    public IMethodBinding findOverride(IMethodBinding method, ITypeBinding type) {
        return this.findOverride(method, type, false);
    }

    public IMethodBinding findOverride(IMethodBinding method, ITypeBinding type, boolean onlyPrimarylevel) {
        ITypeBinding superclass = type.getSuperclass();
        IMethodBinding overridden = null;
        if (superclass != null) {
            overridden = this.internalFindOverride(method, superclass, onlyPrimarylevel);
        }
        if (overridden == null) {
            ITypeBinding[] _interfaces;
            for (ITypeBinding interfaze : _interfaces = type.getInterfaces()) {
                overridden = this.internalFindOverride(method, interfaze, onlyPrimarylevel);
                if (overridden == null) continue;
                return overridden;
            }
        }
        return overridden;
    }

    private IMethodBinding internalFindOverride(IMethodBinding method, ITypeBinding superType, boolean onlyPrimarylevel) {
        boolean _equals;
        Functions.Function1<IMethodBinding, Boolean> _function = it -> method.overrides((IMethodBinding)it);
        Iterable<IMethodBinding> superClassOverride = IterableExtensions.filter((Iterable)Conversions.doWrapArray(superType.getDeclaredMethods()), _function);
        int _size = IterableExtensions.size(superClassOverride);
        boolean bl = _equals = _size == 1;
        if (_equals) {
            return ((IMethodBinding[])Conversions.unwrapArray(superClassOverride, IMethodBinding.class))[0];
        }
        if (!onlyPrimarylevel) {
            return this.findOverride(method, superType);
        }
        return null;
    }

    public String handleVariableDeclaration(Iterable<? extends ASTNode> modifier) {
        boolean _isFinal = this.isFinal(Iterables.filter(modifier, Modifier.class));
        if (_isFinal) {
            return "val";
        }
        return "var";
    }

    public boolean isNotSupportedInnerType(TypeDeclaration it) {
        return !it.isInterface() && (it.getParent() instanceof TypeDeclaration || it.getParent() instanceof Block) && !IterableExtensions.exists(Iterables.filter(it.modifiers(), Modifier.class), it_1 -> it_1.isStatic());
    }

    public boolean isNotSupportedInnerType(TypeDeclarationStatement it) {
        ASTNode _parent = it.getParent();
        return _parent instanceof Block;
    }

    public boolean isFinal(Iterable<Modifier> modifiers) {
        Functions.Function1<Modifier, Boolean> _function = it -> it.isFinal();
        return IterableExtensions.exists(Iterables.filter(modifiers, Modifier.class), _function);
    }

    public boolean isStatic(Iterable<IExtendedModifier> modifiers) {
        Functions.Function1<Modifier, Boolean> _function = it -> it.isStatic();
        return IterableExtensions.exists(Iterables.filter(modifiers, Modifier.class), _function);
    }

    public boolean isStaticMemberCall(MethodInvocation methInv) {
        return this.isStaticBinding(methInv.resolveMethodBinding());
    }

    public boolean isStaticMemberCall(QualifiedName expr) {
        return this.isStaticBinding(expr.resolveBinding());
    }

    public boolean isStaticMemberCall(FieldAccess expr) {
        return this.isStaticBinding(expr.resolveFieldBinding());
    }

    private boolean isStaticBinding(IBinding binding) {
        if (binding != null) {
            return Modifier.isStatic(binding.getModifiers());
        }
        return false;
    }

    public boolean isPackageVisibility(Iterable<Modifier> modifier) {
        Functions.Function1<Modifier, Boolean> _function = it -> it.isPublic() || it.isPrivate() || it.isProtected();
        return IterableExtensions.isEmpty(IterableExtensions.filter(modifier, _function));
    }

    public boolean canHandleAnnotation(ASTNode node) {
        return !(node instanceof VariableDeclarationStatement);
    }

    public boolean shouldConvertName(SimpleName it) {
        return it.getParent() instanceof FieldAccess || it.getParent() instanceof VariableDeclarationFragment && it.getParent().getParent() instanceof FieldDeclaration;
    }

    public boolean isLambdaCase(ClassInstanceCreation creation) {
        IMethodBinding methodBinding;
        Object declaredMethod;
        AnonymousClassDeclaration anonymousClazz = creation.getAnonymousClassDeclaration();
        if (anonymousClazz != null && anonymousClazz.bodyDeclarations().size() == 1 && (declaredMethod = anonymousClazz.bodyDeclarations().get(0)) instanceof MethodDeclaration && creation.getType().resolveBinding() != null && (methodBinding = ((MethodDeclaration)declaredMethod).resolveBinding()) != null) {
            IMethodBinding overrides = this.findOverride(methodBinding, methodBinding.getDeclaringClass(), true);
            return overrides != null && Modifier.isAbstract(overrides.getModifiers());
        }
        return false;
    }

    public boolean needsReturnValue(ASTNode node) {
        return node.getParent() != null && (!(node.getParent() instanceof Statement) || node.getParent() instanceof ReturnStatement);
    }

    public boolean isConstantArrayIndex(Expression node) {
        return node instanceof NumberLiteral;
    }

    public boolean canConvertToRichText(InfixExpression node) {
        TypeDeclaration typeDeclr;
        FieldDeclaration parentFieldDecl = this.findParentOfType(node, FieldDeclaration.class);
        if (parentFieldDecl != null && ((typeDeclr = this.findParentOfType(parentFieldDecl, TypeDeclaration.class)).isInterface() || this.isFinal(parentFieldDecl.modifiers()) && this.isStatic(parentFieldDecl.modifiers()))) {
            return false;
        }
        SingleMemberAnnotation parentSingleMemberAnnotation = this.findParentOfType(node, SingleMemberAnnotation.class);
        if (parentSingleMemberAnnotation != null) {
            return false;
        }
        Iterable<StringLiteral> nodes = this.collectCompatibleNodes(node);
        return !IterableExtensions.isEmpty(nodes) && IterableExtensions.forall(nodes, it -> this.canTranslate((StringLiteral)it));
    }

    public <T extends ASTNode> T findParentOfType(ASTNode someNode, Class<T> parentType) {
        boolean _tripleEquals;
        ASTNode _parent = someNode.getParent();
        boolean bl = _tripleEquals = _parent == null;
        if (_tripleEquals) {
            return null;
        }
        boolean _isInstance = parentType.isInstance(someNode.getParent());
        if (_isInstance) {
            return (T)((ASTNode)parentType.cast(someNode.getParent()));
        }
        return this.findParentOfType(someNode.getParent(), parentType);
    }

    private Iterable<StringLiteral> collectCompatibleNodes(InfixExpression node) {
        boolean _notEquals;
        ArrayList<StringLiteral> strings = CollectionLiterals.newArrayList();
        InfixExpression.Operator _operator = node.getOperator();
        boolean bl = _notEquals = !Objects.equal(_operator, InfixExpression.Operator.PLUS);
        if (_notEquals) {
            return strings;
        }
        Expression left = node.getLeftOperand();
        if (left instanceof StringLiteral) {
            strings.add((StringLiteral)left);
        } else if (left instanceof InfixExpression) {
            Iterables.addAll(strings, this.collectCompatibleNodes((InfixExpression)left));
        }
        Expression right = node.getRightOperand();
        if (right instanceof StringLiteral) {
            strings.add((StringLiteral)right);
        } else if (right instanceof InfixExpression) {
            Iterables.addAll(strings, this.collectCompatibleNodes((InfixExpression)right));
        }
        Iterables.addAll(strings, Iterables.filter(node.extendedOperands(), StringLiteral.class));
        return strings;
    }

    private boolean canTranslate(StringLiteral literal) {
        String value = literal.getEscapedValue();
        return !value.contains("\u00ab") && !value.contains("\u00bb") && !value.contains("'''");
    }

    public Type findDeclaredType(SimpleName simpleName) {
        ASTNode scope = this.findDeclarationBlocks(simpleName);
        while (scope != null) {
            Type type = this.findDeclaredType(scope, simpleName);
            if (type != null) {
                return type;
            }
            scope = this.findDeclarationBlocks(scope);
        }
        return null;
    }

    private ASTNode findDeclarationBlocks(ASTNode simpleName) {
        ASTNode block = this.findParentOfType(simpleName, Block.class);
        if (block == null) {
            block = this.findParentOfType(simpleName, MethodDeclaration.class);
        }
        if (block == null) {
            block = this.findParentOfType(simpleName, TypeDeclaration.class);
        }
        return block;
    }

    private Type findDeclaredType(ASTNode scope, final SimpleName simpleName) {
        final ArrayList matchesFound = CollectionLiterals.newArrayList();
        scope.accept(new ASTVisitor(){

            @Override
            public boolean visit(VariableDeclarationFragment node) {
                boolean _equals = node.getName().getIdentifier().equals(simpleName.getIdentifier());
                if (_equals) {
                    ASTNode parentNode = node.getParent();
                    boolean _matched = false;
                    if (parentNode instanceof VariableDeclarationStatement) {
                        _matched = true;
                        matchesFound.add(((VariableDeclarationStatement)parentNode).getType());
                    }
                    if (!_matched && parentNode instanceof FieldDeclaration) {
                        _matched = true;
                        matchesFound.add(((FieldDeclaration)parentNode).getType());
                    }
                    if (!_matched && parentNode instanceof VariableDeclarationExpression) {
                        _matched = true;
                        matchesFound.add(((VariableDeclarationExpression)parentNode).getType());
                    }
                }
                return false;
            }

            @Override
            public boolean preVisit2(ASTNode node) {
                return matchesFound.isEmpty();
            }

            @Override
            public boolean visit(SingleVariableDeclaration node) {
                boolean _equals = node.getName().getIdentifier().equals(simpleName.getIdentifier());
                if (_equals) {
                    matchesFound.add(node.getType());
                }
                return false;
            }
        });
        return (Type)IterableExtensions.head(matchesFound);
    }

    public Iterable<Expression> findAssignmentsInBlock(Block scope, final Functions.Function1<? super Expression, ? extends Boolean> constraint) {
        final HashSet<Expression> assigments = CollectionLiterals.newHashSet();
        if (scope != null) {
            scope.accept(new ASTVisitor(){

                @Override
                public boolean visit(Assignment node) {
                    Boolean _apply = (Boolean)constraint.apply(node);
                    if (_apply.booleanValue()) {
                        assigments.add(node);
                    }
                    return true;
                }

                @Override
                public boolean visit(PrefixExpression node) {
                    Boolean _apply = (Boolean)constraint.apply(node);
                    if (_apply.booleanValue()) {
                        assigments.add(node);
                    }
                    return true;
                }

                @Override
                public boolean visit(PostfixExpression node) {
                    Boolean _apply = (Boolean)constraint.apply(node);
                    if (_apply.booleanValue()) {
                        assigments.add(node);
                    }
                    return true;
                }
            });
        }
        return assigments;
    }

    public Boolean isAssignedInBody(Block scope, VariableDeclarationFragment fieldDeclFragment) {
        boolean _isEmpty = IterableExtensions.isEmpty(this.findAssignmentsInBlock(scope, fieldDeclFragment));
        return !_isEmpty;
    }

    public Iterable<Expression> findAssignmentsInBlock(Block scope, VariableDeclaration varDecl) {
        Functions.Function1<Expression, Boolean> _function = it -> {
            IBinding binding;
            Expression name = null;
            boolean _matched = false;
            if (it instanceof Assignment) {
                _matched = true;
                name = ((Assignment)it).getLeftHandSide();
            }
            if (!_matched && it instanceof PrefixExpression) {
                _matched = true;
                name = ((PrefixExpression)it).getOperand();
            }
            if (!_matched && it instanceof PostfixExpression) {
                _matched = true;
                name = ((PostfixExpression)it).getOperand();
            }
            if (name instanceof Name && (binding = ((Name)name).resolveBinding()) instanceof IVariableBinding) {
                IVariableBinding declBinding = varDecl.resolveBinding();
                return varDecl.getName().getIdentifier().equals(this.toSimpleName((Name)name)) && ((IVariableBinding)binding).equals(declBinding);
            }
            return false;
        };
        return this.findAssignmentsInBlock(scope, _function);
    }

    public Boolean isAssignedInBody(Block scope, SimpleName nameToLookFor) {
        Functions.Function1<Expression, Boolean> _function = it -> {
            Expression simpleName = null;
            boolean _matched = false;
            if (it instanceof Assignment) {
                _matched = true;
                simpleName = ((Assignment)it).getLeftHandSide();
            }
            if (!_matched && it instanceof PrefixExpression) {
                _matched = true;
                simpleName = ((PrefixExpression)it).getOperand();
            }
            if (!_matched && it instanceof PostfixExpression) {
                _matched = true;
                simpleName = ((PostfixExpression)it).getOperand();
            }
            if (simpleName instanceof SimpleName) {
                return simpleName != null && nameToLookFor.getIdentifier().equals(((SimpleName)simpleName).getIdentifier());
            }
            return false;
        };
        boolean _isEmpty = IterableExtensions.isEmpty(this.findAssignmentsInBlock(scope, _function));
        return !_isEmpty;
    }

    protected String _toSimpleName(SimpleName name) {
        return name.getIdentifier();
    }

    protected String _toSimpleName(QualifiedName name) {
        return name.getName().getIdentifier();
    }

    public List<ASTNode> genericChildListProperty(ASTNode node, String propertyName) {
        Functions.Function1<ChildListPropertyDescriptor, Boolean> _function = it -> {
            String _id = it.getId();
            return Objects.equal(propertyName, _id);
        };
        ChildListPropertyDescriptor property = IterableExtensions.head(IterableExtensions.filter(Iterables.filter(node.structuralPropertiesForType(), ChildListPropertyDescriptor.class), _function));
        if (property != null) {
            Object _structuralProperty = node.getStructuralProperty(property);
            return (List)_structuralProperty;
        }
        return null;
    }

    public boolean needPrimitiveCast(Type type) {
        if (type instanceof PrimitiveType) {
            return Objects.equal(((PrimitiveType)type).getPrimitiveTypeCode(), PrimitiveType.CHAR) || Objects.equal(((PrimitiveType)type).getPrimitiveTypeCode(), PrimitiveType.BYTE) || Objects.equal(((PrimitiveType)type).getPrimitiveTypeCode(), PrimitiveType.SHORT);
        }
        return false;
    }

    public ASTNode genericChildProperty(ASTNode node, String propertyName) {
        Functions.Function1<ChildPropertyDescriptor, Boolean> _function = it -> {
            String _id = it.getId();
            return Objects.equal(propertyName, _id);
        };
        ChildPropertyDescriptor property = IterableExtensions.head(IterableExtensions.filter(Iterables.filter(node.structuralPropertiesForType(), ChildPropertyDescriptor.class), _function));
        if (property != null) {
            Object _structuralProperty = node.getStructuralProperty(property);
            return (ASTNode)_structuralProperty;
        }
        return null;
    }

    public String toSimpleName(Name name) {
        if (name instanceof QualifiedName) {
            return this._toSimpleName((QualifiedName)name);
        }
        if (name instanceof SimpleName) {
            return this._toSimpleName((SimpleName)name);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(name).toString());
    }
}

