/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.formatting2;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.formatting2.RichStringFormatter;
import org.eclipse.xtend.core.formatting2.XtendFormatterPreferenceKeys;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionFinder;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XPostfixOperation;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.annotations.formatting2.XbaseWithAnnotationsFormatter;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.formatting2.XbaseFormatterPreferenceKeys;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XtendFormatter
extends XbaseWithAnnotationsFormatter {
    @Inject
    @Extension
    private XtendGrammarAccess _xtendGrammarAccess;
    @Inject
    private RichStringFormatter.Factory richStringFormatterFactory;

    protected void _format(XtendFile xtendFile, @Extension IFormattableDocument format) {
        XImportSection _importSection;
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.noSpace();
        format.prepend(xtendFile, _function);
        ISemanticRegion pkg = this.textRegionExtensions.regionFor(xtendFile).feature(XtendPackage.Literals.XTEND_FILE__PACKAGE);
        if (pkg != null) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.oneSpace();
            format.prepend(pkg, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1);
            ISemanticRegion pkgSemicolon = pkg.immediatelyFollowing().keyword(";");
            if (pkgSemicolon != null) {
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.noSpace();
                format.append(pkg, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2);
                format.append(pkgSemicolon, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XtendFormatterPreferenceKeys.blankLinesAfterPackageDecl);
            } else {
                format.append(pkg, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XtendFormatterPreferenceKeys.blankLinesAfterPackageDecl);
            }
        }
        if ((_importSection = xtendFile.getImportSection()) != null) {
            format.format(_importSection);
        }
        EList<XtendTypeDeclaration> _xtendTypes = xtendFile.getXtendTypes();
        for (XtendTypeDeclaration clazz : _xtendTypes) {
            format.format(clazz);
            XtendTypeDeclaration _last = IterableExtensions.last(xtendFile.getXtendTypes());
            boolean _notEquals = !Objects.equal(clazz, _last);
            if (!_notEquals) continue;
            format.append(clazz, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XtendFormatterPreferenceKeys.blankLinesBetweenClasses);
        }
        Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = it -> it.newLine();
        format.append(xtendFile, _function_3);
    }

    protected void formatAnnotations(XtendAnnotationTarget target, @Extension IFormattableDocument document, Procedures.Procedure1<? super IHiddenRegionFormatter> configKey) {
        boolean _isEmpty = target.getAnnotations().isEmpty();
        if (_isEmpty) {
            return;
        }
        EList<XAnnotation> _annotations = target.getAnnotations();
        for (XAnnotation a : _annotations) {
            document.format(a);
            document.append(a, configKey);
        }
    }

    protected void _format(XtendClass clazz, @Extension IFormattableDocument format) {
        this.formatAnnotations(clazz, format, XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers(clazz, format);
        this.formatTypeParameters(clazz, clazz.getTypeParameters(), format);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.oneSpace();
        format.append(this.textRegionExtensions.regionFor(clazz).keyword("class"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.oneSpace();
        format.surround(this.textRegionExtensions.regionFor(clazz).keyword("extends"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1);
        format.format(clazz.getExtends());
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.oneSpace();
        format.surround(this.textRegionExtensions.regionFor(clazz).keyword("implements"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2);
        EList<JvmTypeReference> _implements = clazz.getImplements();
        for (JvmTypeReference imp : _implements) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = it -> it.noSpace();
            Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = it -> it.oneSpace();
            format.append(format.prepend(this.textRegionExtensions.immediatelyFollowing(imp).keyword(","), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_3), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_4);
            format.format(imp);
        }
        this.formatBody(clazz, format);
    }

    protected ISemanticRegion formatTypeParameters(XtendMember member, List<? extends JvmTypeParameter> typeParameters, @Extension IFormattableDocument format) {
        boolean _not;
        ISemanticRegion _xifexpression = null;
        boolean _isEmpty = typeParameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ISemanticRegion _xblockexpression = null;
            Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.noSpace();
            format.surround(this.textRegionExtensions.regionFor(member).keyword("<"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
            for (JvmTypeParameter jvmTypeParameter : typeParameters) {
                format.format(jvmTypeParameter);
                Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.noSpace();
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.oneSpace();
                format.append(format.prepend(this.textRegionExtensions.immediatelyFollowing(jvmTypeParameter).keyword(","), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2);
            }
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.noSpace();
            _xifexpression = _xblockexpression = format.prepend(this.textRegionExtensions.regionFor(member).keyword(">"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1);
        }
        return _xifexpression;
    }

    protected ISemanticRegion formatBody(XtendTypeDeclaration type, @Extension IFormattableDocument format) {
        boolean _not;
        ISemanticRegion _xblockexpression = null;
        ISemanticRegion open = this.textRegionExtensions.regionFor(type).keyword("{");
        ISemanticRegion close = this.textRegionExtensions.regionFor(type).keyword("}");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.indent();
        format.interior(open, close, _function);
        format.prepend(open, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.bracesInNewLine);
        ISemanticRegion _xifexpression = null;
        boolean _isEmpty = type.getMembers().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            format.append(open, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XtendFormatterPreferenceKeys.blankLinesBeforeFirstMember);
            int _size = type.getMembers().size();
            int _minus = _size - 1;
            IntegerRange _upTo = new IntegerRange(0, _minus);
            for (Integer i : _upTo) {
                boolean _lessThan;
                XtendMember current = (XtendMember)type.getMembers().get(i);
                format.format(current);
                int _size_1 = type.getMembers().size();
                int _minus_1 = _size_1 - 1;
                boolean bl2 = _lessThan = i < _minus_1;
                if (_lessThan) {
                    XtendMember next = (XtendMember)type.getMembers().get(i + 1);
                    if (current instanceof XtendField && next instanceof XtendField) {
                        format.append(current, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XtendFormatterPreferenceKeys.blankLinesBetweenFields);
                        continue;
                    }
                    if (current instanceof XtendFunction && next instanceof XtendFunction) {
                        format.append(current, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XtendFormatterPreferenceKeys.blankLinesBetweenMethods);
                        continue;
                    }
                    format.append(current, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XtendFormatterPreferenceKeys.blankLinesBetweenFieldsAndMethods);
                    continue;
                }
                XtendMember member = (XtendMember)type.getMembers().get(i);
                format.append(member, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XtendFormatterPreferenceKeys.blankLinesAfterLastMember);
            }
        } else {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.newLine();
            _xifexpression = format.append(open, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected void _format(XtendInterface interfaze, @Extension IFormattableDocument format) {
        this.formatAnnotations(interfaze, format, XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers(interfaze, format);
        this.formatTypeParameters(interfaze, interfaze.getTypeParameters(), format);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.oneSpace();
        format.append(this.textRegionExtensions.regionFor(interfaze).keyword("interface"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.oneSpace();
        format.surround(this.textRegionExtensions.regionFor(interfaze).keyword("extends"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1);
        EList<JvmTypeReference> _extends = interfaze.getExtends();
        for (JvmTypeReference imp : _extends) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.noSpace();
            Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = it -> it.oneSpace();
            format.append(format.prepend(this.textRegionExtensions.immediatelyFollowing(imp).keyword(","), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_3);
            format.format(imp);
        }
        this.formatBody(interfaze, format);
    }

    protected void _format(XtendAnnotationType annotationType, @Extension IFormattableDocument format) {
        this.formatAnnotations(annotationType, format, XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers(annotationType, format);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.oneSpace();
        format.append(this.textRegionExtensions.regionFor(annotationType).keyword("annotation"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        this.formatBody(annotationType, format);
    }

    protected void _format(XtendEnum enumeration, @Extension IFormattableDocument format) {
        boolean _not;
        this.formatAnnotations(enumeration, format, XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers(enumeration, format);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.oneSpace();
        format.append(this.textRegionExtensions.regionFor(enumeration).keyword("enum"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        ISemanticRegion open = this.textRegionExtensions.regionFor(enumeration).keyword("{");
        ISemanticRegion close = this.textRegionExtensions.regionFor(enumeration).keyword("}");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.indent();
        format.interior(open, close, _function_1);
        format.prepend(open, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.bracesInNewLine);
        boolean _isEmpty = enumeration.getMembers().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            format.append(open, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XtendFormatterPreferenceKeys.blankLinesBeforeFirstMember);
            int _size = enumeration.getMembers().size();
            int _minus = _size - 1;
            IntegerRange _upTo = new IntegerRange(0, _minus);
            for (Integer i : _upTo) {
                boolean _lessThan;
                XtendMember current = (XtendMember)enumeration.getMembers().get(i);
                format.format(current);
                int _size_1 = enumeration.getMembers().size();
                int _minus_1 = _size_1 - 1;
                boolean bl2 = _lessThan = i < _minus_1;
                if (_lessThan) {
                    Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.noSpace();
                    format.append(format.prepend(this.textRegionExtensions.immediatelyFollowing(current).keyword(","), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2), (Procedures.Procedure1<? super IHiddenRegionFormatter>)XtendFormatterPreferenceKeys.blankLinesBetweenEnumLiterals);
                    continue;
                }
                format.append(current, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XtendFormatterPreferenceKeys.blankLinesAfterLastMember);
            }
        } else {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.newLine();
            format.append(open, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2);
        }
    }

    protected void _format(XtendConstructor func, @Extension IFormattableDocument format) {
        boolean _not;
        this.formatAnnotations(func, format, XbaseFormatterPreferenceKeys.newLineAfterConstructorAnnotations);
        this.formatModifiers(func, format);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.noSpace();
        format.append(this.textRegionExtensions.regionFor(func).keyword("new"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        boolean _isEmpty = func.getTypeParameters().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.noSpace();
            format.append(this.textRegionExtensions.regionFor(func).keyword("<"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1);
            EList<JvmTypeParameter> _typeParameters = func.getTypeParameters();
            for (JvmTypeParameter arg : _typeParameters) {
                format.format(arg);
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.noSpace();
                Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = it -> it.oneSpace();
                format.append(format.prepend(this.textRegionExtensions.immediatelyFollowing(arg).keyword(","), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_3);
            }
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.noSpace();
            format.surround(this.textRegionExtensions.regionFor(func).keyword(">"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2);
        }
        ISemanticRegion open = this.textRegionExtensions.regionFor(func).keyword("(");
        ISemanticRegion close = this.textRegionExtensions.regionFor(func).keyword(")");
        format.append(close, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.bracesInNewLine);
        this.formatCommaSeparatedList(func.getParameters(), open, close, format);
        format.format(func.getExpression());
    }

    protected void _format(XtendFunction func, @Extension IFormattableDocument format) {
        boolean _tripleNotEquals;
        boolean _not;
        this.formatAnnotations(func, format, XbaseFormatterPreferenceKeys.newLineAfterMethodAnnotations);
        this.formatModifiers(func, format);
        boolean _isEmpty = func.getTypeParameters().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.noSpace();
            format.append(this.textRegionExtensions.regionFor(func).keyword("<"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
            EList<JvmTypeParameter> _typeParameters = func.getTypeParameters();
            for (JvmTypeParameter arg : _typeParameters) {
                format.format(arg);
                Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.noSpace();
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.oneSpace();
                format.append(format.prepend(this.textRegionExtensions.immediatelyFollowing(arg).keyword(","), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2);
            }
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.noSpace();
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.oneSpace();
            format.append(format.prepend(this.textRegionExtensions.regionFor(func).keyword(">"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2);
        }
        ISemanticRegion nameNode = this.textRegionExtensions.regionFor(func).feature(XtendPackage.Literals.XTEND_FUNCTION__NAME);
        ISemanticRegionFinder _immediatelyFollowing = null;
        if (nameNode != null) {
            _immediatelyFollowing = nameNode.immediatelyFollowing();
        }
        ISemanticRegion _keyword = null;
        if (_immediatelyFollowing != null) {
            _keyword = _immediatelyFollowing.keyword("(");
        }
        ISemanticRegion open = _keyword;
        ISemanticRegion close = this.textRegionExtensions.regionFor(func).keyword(")");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = it -> it.oneSpace();
        format.append(func.getReturnType(), _function_3);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = it -> it.noSpace();
        format.prepend(open, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_4);
        XExpression _expression = func.getExpression();
        boolean bl2 = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            format.append(close, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.bracesInNewLine);
        }
        this.formatCommaSeparatedList(func.getParameters(), open, close, format);
        format.format(func.getReturnType());
        format.format(func.getExpression());
    }

    protected void _format(XtendField field, @Extension IFormattableDocument document) {
        boolean _tripleNotEquals;
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.oneSpace();
        document.append(this.textRegionExtensions.regionFor(field).keyword("extension"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        this.formatAnnotations(field, document, XbaseFormatterPreferenceKeys.newLineAfterFieldAnnotations);
        this.formatModifiers(field, document);
        String _name = field.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.oneSpace();
            document.append(field.getType(), _function_1);
        }
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.oneSpace();
        Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = it -> it.oneSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor(field).keyword("="), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_3);
        document.format(field.getType());
        document.format(field.getInitialValue());
    }

    protected void _format(XtendParameter param, @Extension IFormattableDocument format) {
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.oneSpace();
        format.append(this.textRegionExtensions.regionFor(param).keyword("extension"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        this.formatAnnotations(param, format, XbaseFormatterPreferenceKeys.newLineAfterParameterAnnotations);
        format.format(param.getParameterType());
        ISemanticRegion nameNode = this.textRegionExtensions.regionFor(param).feature(XtendPackage.Literals.XTEND_PARAMETER__NAME);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.oneSpace();
        format.prepend(nameNode, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1);
    }

    @Override
    protected void _format(XVariableDeclaration expr, @Extension IFormattableDocument format) {
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.oneSpace();
        format.append(this.textRegionExtensions.regionFor(expr).keyword("extension"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        super._format(expr, format);
    }

    @Override
    protected void _format(XIfExpression expr, @Extension IFormattableDocument format) {
        boolean _not;
        boolean _isConditionalExpression = expr.isConditionalExpression();
        boolean bl = _not = !_isConditionalExpression;
        if (_not) {
            super._format(expr, format);
        } else {
            boolean _tripleEquals;
            boolean multiline;
            EObject _eContainer = expr.eContainer();
            if (_eContainer instanceof XVariableDeclaration) {
                Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.indent();
                format.surround(expr, _function);
            }
            boolean bl2 = multiline = this.isMultilineOrInNewLine(expr.getThen()) || this.isMultilineOrInNewLine(expr.getElse());
            if (expr.getThen() instanceof XBlockExpression || multiline) {
                Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.newLine();
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.indent();
                Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = it -> it.oneSpace();
                format.append(format.surround(format.prepend(this.textRegionExtensions.regionFor(expr).keyword("?"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_2), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_3);
            } else {
                Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = it -> it.oneSpace();
                format.surround(this.textRegionExtensions.regionFor(expr).keyword("?"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_4);
            }
            format.format(expr.getIf());
            XExpression _else = expr.getElse();
            boolean bl3 = _tripleEquals = _else == null;
            if (_tripleEquals) {
                this.formatBody(expr.getThen(), multiline, format);
            } else {
                this.formatBodyInline(expr.getThen(), multiline, format);
                if (expr.getElse() instanceof XIfExpression || !multiline) {
                    Procedures.Procedure1<IHiddenRegionFormatter> _function_5 = it -> it.oneSpace();
                    format.prepend(expr.getElse(), _function_5);
                    format.format(expr.getElse());
                } else {
                    Procedures.Procedure1<IHiddenRegionFormatter> _function_6 = it -> it.newLine();
                    Procedures.Procedure1<IHiddenRegionFormatter> _function_7 = it -> it.indent();
                    Procedures.Procedure1<IHiddenRegionFormatter> _function_8 = it -> it.oneSpace();
                    format.append(format.surround(format.prepend(this.textRegionExtensions.regionFor(expr).keyword(":"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_6), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_7), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_8);
                    this.formatBody(expr.getElse(), multiline, format);
                }
            }
        }
    }

    @Override
    protected void _format(JvmFormalParameter expr, @Extension IFormattableDocument format) {
        Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.oneSpace();
        format.append(this.textRegionExtensions.regionFor(expr).keyword("extension"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function);
        super._format(expr, format);
    }

    protected void _format(RichString rs, @Extension IFormattableDocument format) {
        RichStringFormatter richStringFormatter = this.richStringFormatterFactory.create(this.getRequest().getTextRegionAccess());
        richStringFormatter.format(rs, format);
    }

    protected void _format(AnonymousClass anonymousClass, @Extension IFormattableDocument format) {
        this.format(anonymousClass.getConstructorCall(), format);
        this.formatBody(anonymousClass, format);
    }

    protected void formatModifiers(XtendMember member, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it -> {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it_1 -> it_1.oneSpace();
            document.append(it, (Procedures.Procedure1<? super IHiddenRegionFormatter>)_function_1);
        };
        this.textRegionExtensions.regionFor(member).ruleCallsTo(this._xtendGrammarAccess.getCommonModifierRule(), this._xtendGrammarAccess.getMethodModifierRule(), this._xtendGrammarAccess.getFieldModifierRule()).forEach(_function);
    }

    @Override
    protected boolean isSingleLineBlock(XBlockExpression expr) {
        return expr.getExpressions().size() <= 1 && this.getPreferences().getPreference(XtendFormatterPreferenceKeys.keepOneLineMethods) != false && expr.eContainer() instanceof XtendFunction && !this.textRegionExtensions.nextHiddenRegion(expr).immediatelyPreceding().keyword("}").getPreviousHiddenRegion().isMultiline();
    }

    @Override
    protected void formatBodyInline(XExpression expr, boolean forceMultiline, @Extension IFormattableDocument doc) {
        if (expr == null) {
            return;
        }
        if (!(!(expr instanceof XBlockExpression) || expr instanceof RichString && forceMultiline)) {
            doc.append(doc.prepend(expr, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.bracesInNewLine), (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.bracesInNewLine);
        } else if (forceMultiline || this.textRegionExtensions.previousHiddenRegion(expr).isMultiline()) {
            boolean _not;
            boolean bl = _not = !(expr.eContainer() instanceof XIfExpression) || !((XIfExpression)expr.eContainer()).isConditionalExpression();
            if (_not) {
                Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.newLine();
                Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.indent();
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.newLine();
                doc.append(doc.surround(doc.prepend(expr, _function), _function_1), _function_2);
            }
        } else {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = it -> it.oneSpace();
            doc.surround(expr, _function_3);
        }
        doc.format(expr);
    }

    @Override
    protected void formatBody(XExpression expr, boolean forceMultiline, @Extension IFormattableDocument doc) {
        if (expr == null) {
            return;
        }
        if (!(!(expr instanceof XBlockExpression) || expr instanceof RichString && forceMultiline)) {
            doc.prepend(expr, (Procedures.Procedure1<? super IHiddenRegionFormatter>)XbaseFormatterPreferenceKeys.bracesInNewLine);
        } else if (forceMultiline || this.textRegionExtensions.previousHiddenRegion(expr).isMultiline()) {
            boolean _not;
            boolean bl = _not = !(expr.eContainer() instanceof XIfExpression) || !((XIfExpression)expr.eContainer()).isConditionalExpression();
            if (_not) {
                Procedures.Procedure1<IHiddenRegionFormatter> _function = it -> it.newLine();
                Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = it -> it.indent();
                doc.surround(doc.prepend(expr, _function), _function_1);
            }
        } else {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = it -> it.oneSpace();
            doc.prepend(expr, _function_2);
        }
        doc.format(expr);
    }

    @Override
    protected XClosure builder(List<XExpression> params) {
        boolean _tripleNotEquals;
        XClosure _xifexpression = null;
        XExpression _last = IterableExtensions.last(params);
        boolean bl = _tripleNotEquals = _last != null;
        if (_tripleNotEquals) {
            XClosure _xblockexpression = null;
            EObject grammarElement = this.textRegionExtensions.grammarElement(IterableExtensions.last(params));
            XClosure _xifexpression_1 = null;
            if (Objects.equal(grammarElement, this._xtendGrammarAccess.getXMemberFeatureCallAccess().getMemberCallArgumentsXClosureParserRuleCall_1_1_4_0()) || Objects.equal(grammarElement, this._xtendGrammarAccess.getXFeatureCallAccess().getFeatureCallArgumentsXClosureParserRuleCall_4_0()) || Objects.equal(grammarElement, this._xtendGrammarAccess.getXbaseConstructorCallAccess().getArgumentsXClosureParserRuleCall_5_0())) {
                XExpression _last_1 = IterableExtensions.last(params);
                _xifexpression_1 = (XClosure)_last_1;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    @Override
    public void format(Object anonymousClass, IFormattableDocument format) {
        if (anonymousClass instanceof AnonymousClass) {
            this._format((AnonymousClass)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendAnnotationType) {
            this._format((XtendAnnotationType)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendClass) {
            this._format((XtendClass)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendConstructor) {
            this._format((XtendConstructor)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendEnum) {
            this._format((XtendEnum)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendFunction) {
            this._format((XtendFunction)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendInterface) {
            this._format((XtendInterface)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof JvmTypeParameter) {
            this._format((JvmTypeParameter)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof RichString) {
            this._format((RichString)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendField) {
            this._format((XtendField)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof JvmFormalParameter) {
            this._format((JvmFormalParameter)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtextResource) {
            this._format((XtextResource)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XAssignment) {
            this._format((XAssignment)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XBinaryOperation) {
            this._format((XBinaryOperation)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XDoWhileExpression) {
            this._format((XDoWhileExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XFeatureCall) {
            this._format((XFeatureCall)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XMemberFeatureCall) {
            this._format((XMemberFeatureCall)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XPostfixOperation) {
            this._format((XPostfixOperation)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XWhileExpression) {
            this._format((XWhileExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XFunctionTypeRef) {
            this._format((XFunctionTypeRef)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendParameter) {
            this._format((XtendParameter)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof JvmGenericArrayTypeReference) {
            this._format((JvmGenericArrayTypeReference)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof JvmParameterizedTypeReference) {
            this._format((JvmParameterizedTypeReference)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof JvmWildcardTypeReference) {
            this._format((JvmWildcardTypeReference)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XBasicForLoopExpression) {
            this._format((XBasicForLoopExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XBlockExpression) {
            this._format((XBlockExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XCastedExpression) {
            this._format((XCastedExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XClosure) {
            this._format((XClosure)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XCollectionLiteral) {
            this._format((XCollectionLiteral)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XConstructorCall) {
            this._format((XConstructorCall)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XForLoopExpression) {
            this._format((XForLoopExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XIfExpression) {
            this._format((XIfExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XInstanceOfExpression) {
            this._format((XInstanceOfExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XReturnExpression) {
            this._format((XReturnExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XSwitchExpression) {
            this._format((XSwitchExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XSynchronizedExpression) {
            this._format((XSynchronizedExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XThrowExpression) {
            this._format((XThrowExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XTryCatchFinallyExpression) {
            this._format((XTryCatchFinallyExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XTypeLiteral) {
            this._format((XTypeLiteral)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XVariableDeclaration) {
            this._format((XVariableDeclaration)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XAnnotation) {
            this._format((XAnnotation)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XtendFile) {
            this._format((XtendFile)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof JvmTypeConstraint) {
            this._format((JvmTypeConstraint)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XExpression) {
            this._format((XExpression)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XImportDeclaration) {
            this._format((XImportDeclaration)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof XImportSection) {
            this._format((XImportSection)anonymousClass, format);
            return;
        }
        if (anonymousClass instanceof EObject) {
            this._format((EObject)anonymousClass, format);
            return;
        }
        if (anonymousClass == null) {
            this._format((Void)null, format);
            return;
        }
        if (anonymousClass != null) {
            this._format(anonymousClass, format);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(anonymousClass, format).toString());
    }
}

