/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.documentation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.documentation.impl.MultiLineFileHeaderProvider;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class XtendFileHeaderProvider
extends MultiLineFileHeaderProvider {
    @Inject
    private IEObjectDocumentationProvider documentationProvider;

    @Override
    public List<INode> getFileHeaderNodes(Resource resource) {
        IParseResult parseResult;
        if (resource instanceof XtextResource && (parseResult = ((XtextResource)resource).getParseResult()) != null) {
            Iterable<ILeafNode> _leafNodes = parseResult.getRootNode().getLeafNodes();
            for (ILeafNode leafNode : _leafNodes) {
                boolean break_ = true;
                EObject grammarElement = leafNode.getGrammarElement();
                if (grammarElement instanceof TerminalRule) {
                    String terminalRuleName = ((TerminalRule)grammarElement).getName();
                    boolean _equalsIgnoreCase = this.ruleName.equalsIgnoreCase(terminalRuleName);
                    if (_equalsIgnoreCase) {
                        boolean _not;
                        boolean _isTypeComment = this.isTypeComment(leafNode, resource);
                        boolean bl = _not = !_isTypeComment;
                        if (_not) {
                            return Collections.singletonList(leafNode);
                        }
                    } else {
                        boolean _equals = this.wsRuleName.equals(terminalRuleName);
                        if (_equals) {
                            break_ = false;
                        }
                    }
                }
                if (!break_) continue;
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private boolean isTypeComment(ILeafNode leafNode, Resource resource) {
        XtendTypeDeclaration type;
        EObject content = IterableExtensions.head(resource.getContents());
        if (content instanceof XtendFile && (type = IterableExtensions.head(((XtendFile)content).getXtendTypes())) != null && this.documentationProvider instanceof IEObjectDocumentationProviderExtension) {
            INode _head = IterableExtensions.head(((IEObjectDocumentationProviderExtension)((Object)this.documentationProvider)).getDocumentationNodes(type));
            return Objects.equal(leafNode, _head);
        }
        return false;
    }
}

