/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.conversion;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.xtend.core.conversion.XtendValueConverterService;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

@Singleton
public class FunctionIDValueConverter
extends AbstractValueConverter<String> {
    @Inject
    private OperatorMapping operatorMapping;
    private IValueConverter<Object> delegate;
    private XtendGrammarAccess grammarAccess;
    private XtendValueConverterService service;

    @Inject
    protected void setDelegate(XtendValueConverterService service, XtendGrammarAccess grammarAccess) {
        this.service = service;
        this.grammarAccess = grammarAccess;
    }

    @Override
    public String toValue(String string, INode node) throws ValueConverterException {
        QualifiedName operatorMethodName = this.operatorMapping.getMethodName(QualifiedName.create(string));
        if (operatorMethodName != null) {
            return operatorMethodName.getFirstSegment();
        }
        return (String)this.getDelegate().toValue(string, node);
    }

    private IValueConverter<Object> getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = this.service.getConverter(this.grammarAccess.getValidIDRule().getName());
        return this.delegate;
    }

    @Override
    public String toString(String value) throws ValueConverterException {
        QualifiedName operatorName = this.operatorMapping.getOperator(QualifiedName.create(value));
        if (operatorName != null) {
            return operatorName.getFirstSegment();
        }
        return this.getDelegate().toString(value);
    }
}

