/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.framework.util.ThreadInfoReport;
import org.eclipse.osgi.internal.container.LockSet;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.hookregistry.StorageHookFactory;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.storage.ManifestLocalization;
import org.eclipse.osgi.storage.NativeCodeFinder;
import org.eclipse.osgi.storage.Storage;
import org.eclipse.osgi.storage.StorageUtil;
import org.eclipse.osgi.storage.SystemBundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.url.bundleentry.Handler;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public final class BundleInfo {
    public static final String OSGI_BUNDLE_MANIFEST = "META-INF/MANIFEST.MF";
    public static final String MULTI_RELEASE_HEADER = "Multi-Release";
    public static final String MULTI_RELEASE_VERSIONS = "META-INF/versions/";
    public static final Collection<String> MULTI_RELEASE_FILTER_PREFIXES = Collections.singleton("META-INF/");
    private final Storage storage;
    private final long bundleId;
    private final String location;
    private long nextGenerationId;
    private final Object infoMonitor = new Object();
    private LockSet<Long> generationLocks;

    public BundleInfo(Storage storage, long bundleId, String location, long nextGenerationId) {
        this.storage = storage;
        this.bundleId = bundleId;
        this.location = location;
        this.nextGenerationId = nextGenerationId;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String getLocation() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Generation createGeneration() throws BundleException {
        Object object = this.infoMonitor;
        synchronized (object) {
            boolean lockedID;
            if (this.generationLocks == null) {
                this.generationLocks = new LockSet();
            }
            try {
                lockedID = this.generationLocks.tryLock(this.nextGenerationId, 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new BundleException("Failed to obtain id locks for generation.", 7, e);
            }
            if (!lockedID) {
                throw new BundleException("Failed to obtain id locks for generation.", 7, new ThreadInfoReport(this.generationLocks.getLockInfo(this.nextGenerationId)));
            }
            Generation newGeneration = new Generation(this.nextGenerationId++);
            return newGeneration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockGeneration(Generation generation) {
        Object object = this.infoMonitor;
        synchronized (object) {
            if (this.generationLocks == null) {
                throw new IllegalStateException("The generation id was not locked.");
            }
            this.generationLocks.unlock(generation.getGenerationId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Generation restoreGeneration(long generationId, File content, boolean isDirectory, boolean isReference, boolean hasPackageInfo, Map<String, String> cached, long lastModified, boolean isMRJar) {
        Object object = this.infoMonitor;
        synchronized (object) {
            Generation restoredGeneration = new Generation(generationId, content, isDirectory, isReference, hasPackageInfo, cached, lastModified, isMRJar);
            return restoredGeneration;
        }
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void delete() {
        try {
            this.getStorage().delete(this.getStorage().getFile(Long.toString(this.getBundleId()), false));
        }
        catch (IOException e) {
            this.storage.getLogServices().log("org.eclipse.osgi", 2, "Error deleting bunlde info.", e);
        }
    }

    void delete(Generation generation) {
        try {
            this.getStorage().delete(this.getStorage().getFile(String.valueOf(this.getBundleId()) + "/" + generation.getGenerationId(), false));
        }
        catch (IOException e) {
            this.storage.getLogServices().log("org.eclipse.osgi", 2, "Error deleting generation.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextGenerationId() {
        Object object = this.infoMonitor;
        synchronized (object) {
            return this.nextGenerationId;
        }
    }

    public File getDataFile(String path) {
        File dataRoot = this.getStorage().getFile(String.valueOf(this.getBundleId()) + "/" + "data", false);
        if (!Storage.secureAction.isDirectory(dataRoot) && (this.storage.isReadOnly() || !Storage.secureAction.mkdirs(dataRoot) && !Storage.secureAction.isDirectory(dataRoot))) {
            if (this.getStorage().getConfiguration().getDebug().DEBUG_STORAGE) {
                Debug.println("Unable to create bundle data directory: " + dataRoot.getAbsolutePath());
            }
            return null;
        }
        return path == null ? dataRoot : new File(dataRoot, path);
    }

    /*
     * Exception decompiling
     */
    static boolean hasPackageInfo(BundleFile bundleFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class CachedManifest
    extends Dictionary<String, String>
    implements Map<String, String> {
        private final Map<String, String> cached;
        private final Generation generation;

        CachedManifest(Generation generation, Map<String, String> cached) {
            this.generation = generation;
            this.cached = cached;
        }

        @Override
        public Enumeration<String> elements() {
            return Collections.enumeration(this.generation.getRawHeaders().values());
        }

        @Override
        public String get(Object key) {
            if (this.cached.containsKey(key)) {
                return this.cached.get(key);
            }
            if (!this.cached.isEmpty() && this.generation.getBundleInfo().getStorage().getConfiguration().getDebug().DEBUG_CACHED_MANIFEST) {
                Debug.println("Header key is not cached: " + key + "; for bundle: " + this.generation.getBundleInfo().getBundleId());
            }
            return this.generation.getRawHeaders().get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.generation.getRawHeaders().isEmpty();
        }

        @Override
        public Enumeration<String> keys() {
            return Collections.enumeration(this.generation.getRawHeaders().keySet());
        }

        @Override
        public String put(String key, String value) {
            return this.generation.getRawHeaders().put(key, value);
        }

        @Override
        public String remove(Object key) {
            return this.generation.getRawHeaders().remove(key);
        }

        @Override
        public int size() {
            return this.generation.getRawHeaders().size();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.cached.containsKey(key) || this.generation.getRawHeaders().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.cached.containsValue(value) || this.generation.getRawHeaders().containsValue(value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m3) {
            this.generation.getRawHeaders().putAll(m3);
        }

        @Override
        public void clear() {
            this.generation.getRawHeaders().clear();
        }

        @Override
        public Set<String> keySet() {
            return this.generation.getRawHeaders().keySet();
        }

        @Override
        public Collection<String> values() {
            return this.generation.getRawHeaders().values();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.generation.getRawHeaders().entrySet();
        }
    }

    public final class Generation {
        private final long generationId;
        private final Object genMonitor = new Object();
        private final Dictionary<String, String> cachedHeaders;
        private File content;
        private boolean isDirectory;
        private boolean isReference;
        private boolean hasPackageInfo;
        private BundleFile bundleFile;
        private Map<String, String> rawHeaders;
        private ModuleRevision revision;
        private ManifestLocalization headerLocalization;
        private ProtectionDomain domain;
        private NativeCodeFinder nativeCodeFinder;
        private List<StorageHookFactory.StorageHook<?, ?>> storageHooks;
        private long lastModified;
        private boolean isMRJar;

        Generation(long generationId) {
            this.generationId = generationId;
            this.cachedHeaders = new CachedManifest(this, Collections.emptyMap());
        }

        Generation(long generationId, File content, boolean isDirectory, boolean isReference, boolean hasPackageInfo, Map<String, String> cached, long lastModified, boolean isMRJar) {
            this.generationId = generationId;
            this.content = content;
            this.isDirectory = isDirectory;
            this.isReference = isReference;
            this.hasPackageInfo = hasPackageInfo;
            this.cachedHeaders = new CachedManifest(this, cached);
            this.lastModified = lastModified;
            this.isMRJar = isMRJar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BundleFile getBundleFile() {
            Object object = this.genMonitor;
            synchronized (object) {
                if (this.bundleFile == null) {
                    this.bundleFile = BundleInfo.this.getBundleId() == 0L && this.content == null ? new SystemBundleFile() : BundleInfo.this.getStorage().createBundleFile(this.content, this, this.isDirectory, true);
                }
                return this.bundleFile;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.genMonitor;
            synchronized (object) {
                if (this.bundleFile != null) {
                    try {
                        this.bundleFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        public Dictionary<String, String> getHeaders() {
            return this.cachedHeaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<String, String> getRawHeaders() {
            Object object = this.genMonitor;
            synchronized (object) {
                if (this.rawHeaders == null) {
                    BundleEntry manifest = this.getBundleFile().getEntry(BundleInfo.OSGI_BUNDLE_MANIFEST);
                    if (manifest == null) {
                        this.rawHeaders = Collections.emptyMap();
                    } else {
                        try {
                            Map<String, String> merged = ManifestElement.parseBundleManifest(manifest.getInputStream(), new CaseInsensitiveDictionaryMap<String, String>());
                            if (Boolean.parseBoolean(merged.get(BundleInfo.MULTI_RELEASE_HEADER))) {
                                int i = BundleInfo.this.getStorage().getRuntimeVersion().getMajor();
                                while (i > 8) {
                                    String versionManifest = BundleInfo.MULTI_RELEASE_VERSIONS + i + "/OSGI-INF/MANIFEST.MF";
                                    BundleEntry versionEntry = this.getBundleFile().getEntry(versionManifest);
                                    if (versionEntry != null) {
                                        Map<String, String> versioned = ManifestElement.parseBundleManifest(versionEntry.getInputStream(), new CaseInsensitiveDictionaryMap<String, String>());
                                        String versionedImport = versioned.get("Import-Package");
                                        String versionedRequireCap = versioned.get("Require-Capability");
                                        if (versionedImport != null) {
                                            merged.put("Import-Package", versionedImport);
                                        }
                                        if (versionedRequireCap == null) break;
                                        merged.put("Require-Capability", versionedRequireCap);
                                        break;
                                    }
                                    --i;
                                }
                            }
                            this.rawHeaders = Collections.unmodifiableMap(merged);
                        }
                        catch (Exception e) {
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new RuntimeException("Error occurred getting the bundle manifest.", e);
                        }
                    }
                }
                return this.rawHeaders;
            }
        }

        public Dictionary<String, String> getHeaders(String locale) {
            ManifestLocalization current = this.getManifestLocalization();
            return current.getHeaders(locale);
        }

        public ResourceBundle getResourceBundle(String locale) {
            ManifestLocalization current = this.getManifestLocalization();
            String defaultLocale = Locale.getDefault().toString();
            if (locale == null) {
                locale = defaultLocale;
            }
            return current.getResourceBundle(locale, defaultLocale.equals(locale));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ManifestLocalization getManifestLocalization() {
            Object object = this.genMonitor;
            synchronized (object) {
                if (this.headerLocalization == null) {
                    this.headerLocalization = new ManifestLocalization(this, this.getHeaders(), BundleInfo.this.getStorage().getConfiguration().getConfiguration("equinox.root.locale", "en"));
                }
                return this.headerLocalization;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearManifestCache() {
            Object object = this.genMonitor;
            synchronized (object) {
                if (this.headerLocalization != null) {
                    this.headerLocalization.clearCache();
                }
            }
        }

        public long getGenerationId() {
            return this.generationId;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDirectory() {
            Object object = this.genMonitor;
            synchronized (object) {
                return this.isDirectory;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isReference() {
            Object object = this.genMonitor;
            synchronized (object) {
                return this.isReference;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasPackageInfo() {
            Object object = this.genMonitor;
            synchronized (object) {
                return this.hasPackageInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isMRJar() {
            Object object = this.genMonitor;
            synchronized (object) {
                return this.isMRJar;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public File getContent() {
            Object object = this.genMonitor;
            synchronized (object) {
                return this.content;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setContent(File content, boolean isReference) {
            Object object = this.genMonitor;
            synchronized (object) {
                this.content = content;
                this.isDirectory = content == null ? false : Storage.secureAction.isDirectory(content);
                this.isReference = isReference;
                this.setLastModified(content);
            }
        }

        private void setLastModified(File content) {
            if (content == null) {
                this.lastModified = 0L;
                return;
            }
            if (this.isDirectory) {
                content = new File(content, BundleInfo.OSGI_BUNDLE_MANIFEST);
            }
            this.lastModified = Storage.secureAction.lastModified(content);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setStorageHooks(List<StorageHookFactory.StorageHook<?, ?>> storageHooks, boolean install) {
            Object object = this.genMonitor;
            synchronized (object) {
                this.storageHooks = storageHooks;
                if (install) {
                    this.hasPackageInfo = BundleInfo.hasPackageInfo(this.getBundleFile());
                    this.isMRJar = Boolean.parseBoolean(this.getRawHeaders().get(BundleInfo.MULTI_RELEASE_HEADER));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <S, L, H extends StorageHookFactory.StorageHook<S, L>> H getStorageHook(Class<? extends StorageHookFactory<S, L, H>> factoryClass) {
            Object object = this.genMonitor;
            synchronized (object) {
                block5: {
                    if (this.storageHooks != null) break block5;
                    return null;
                }
                for (StorageHookFactory.StorageHook<?, ?> hook : this.storageHooks) {
                    if (!hook.getFactoryClass().equals(factoryClass)) continue;
                    return (H)hook;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ModuleRevision getRevision() {
            Object object = this.genMonitor;
            synchronized (object) {
                return this.revision;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRevision(ModuleRevision revision) {
            Object object = this.genMonitor;
            synchronized (object) {
                this.revision = revision;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProtectionDomain getDomain() {
            if (BundleInfo.this.getBundleId() == 0L || System.getSecurityManager() == null) {
                return null;
            }
            Object object = this.genMonitor;
            synchronized (object) {
                if (this.domain == null) {
                    if (this.revision == null) {
                        throw new IllegalStateException("The revision is not yet set for this generation.");
                    }
                    this.domain = BundleInfo.this.getStorage().getSecurityAdmin().createProtectionDomain(this.revision.getBundle());
                }
                return this.domain;
            }
        }

        public File getExtractFile(String path) {
            return this.getExtractFile(null, path);
        }

        public File getExtractFile(String base, String path) {
            StringBuilder baseBuilder = new StringBuilder();
            baseBuilder.append(BundleInfo.this.getBundleId()).append('/').append(this.getGenerationId());
            if (base != null) {
                baseBuilder.append('/').append(base);
            }
            return BundleInfo.this.getStorage().getFile(baseBuilder.toString(), path, true);
        }

        public void storeContent(File destination, InputStream in, boolean nativeCode) throws IOException {
            File dir;
            if (BundleInfo.this.getStorage().getConfiguration().getDebug().DEBUG_STORAGE) {
                Debug.println("Creating file: " + destination.getPath());
            }
            if (!(dir = new File(destination.getParent())).mkdirs() && !dir.isDirectory()) {
                if (BundleInfo.this.getStorage().getConfiguration().getDebug().DEBUG_STORAGE) {
                    Debug.println("Unable to create directory: " + dir.getPath());
                }
                throw new IOException(NLS.bind(Msg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, dir.getAbsolutePath()));
            }
            File tempDest = File.createTempFile("staged", ".tmp", dir);
            StorageUtil.readFile(in, tempDest);
            if (destination.exists() || !StorageUtil.move(tempDest, destination, BundleInfo.this.getStorage().getConfiguration().getDebug().DEBUG_STORAGE)) {
                if (destination.exists()) {
                    tempDest.delete();
                } else {
                    throw new IOException("Failed to store the extracted content: " + destination);
                }
            }
            if (nativeCode) {
                this.getBundleInfo().getStorage().setPermissions(destination);
            }
        }

        public BundleInfo getBundleInfo() {
            return BundleInfo.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            List<StorageHookFactory.StorageHook<?, ?>> hooks = this.getStorageHooks();
            if (hooks != null) {
                for (StorageHookFactory.StorageHook<?, ?> hook : hooks) {
                    hook.deletingGeneration();
                }
            }
            Object object = this.genMonitor;
            synchronized (object) {
                if (this.bundleFile != null) {
                    try {
                        this.bundleFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.getBundleInfo().delete(this);
        }

        public URL getEntry(String path) {
            BundleEntry entry = this.getBundleFile().getEntry(path);
            if (entry == null) {
                return null;
            }
            path = BundleFile.fixTrailingSlash(path, entry);
            try {
                return Storage.secureAction.getURL("bundleentry", String.valueOf(Long.toString(BundleInfo.this.getBundleId())) + ".fwk" + Integer.toString(BundleInfo.this.getStorage().getModuleContainer().hashCode()), 0, path, new Handler(BundleInfo.this.getStorage().getModuleContainer(), entry));
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String findLibrary(String libname) {
            NativeCodeFinder currentFinder;
            Object object = this.genMonitor;
            synchronized (object) {
                if (this.nativeCodeFinder == null) {
                    this.nativeCodeFinder = new NativeCodeFinder(this);
                }
                currentFinder = this.nativeCodeFinder;
            }
            return currentFinder.findLibrary(libname);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<StorageHookFactory.StorageHook<?, ?>> getStorageHooks() {
            Object object = this.genMonitor;
            synchronized (object) {
                return this.storageHooks;
            }
        }

        public ModuleRevisionBuilder adaptModuleRevisionBuilder(ModuleContainerAdaptor.ModuleEvent operation, Module origin, ModuleRevisionBuilder builder) {
            List<StorageHookFactory.StorageHook<?, ?>> hooks = this.getStorageHooks();
            if (hooks != null) {
                for (StorageHookFactory.StorageHook<?, ?> hook : hooks) {
                    ModuleRevisionBuilder hookResult = hook.adaptModuleRevisionBuilder(operation, origin, builder);
                    if (hookResult == null) continue;
                    builder = hookResult;
                }
            }
            return builder;
        }
    }
}

