/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.osgi.util.NLS;

public class FileState
extends PlatformObject
implements IFileState {
    private static final IWorkspace workspace = ResourcesPlugin.getWorkspace();
    protected long lastModified;
    protected UniversalUniqueIdentifier uuid;
    protected IHistoryStore store;
    protected IPath fullPath;

    public FileState(IHistoryStore store, IPath fullPath, long lastModified, UniversalUniqueIdentifier uuid) {
        this.store = store;
        this.lastModified = lastModified;
        this.uuid = uuid;
        this.fullPath = fullPath;
    }

    @Override
    public boolean exists() {
        return this.store.exists(this);
    }

    @Override
    public String getCharset() throws CoreException {
        IResource file = workspace.getRoot().findMember(this.fullPath);
        if (file != null && file.getType() == 1) {
            return ((IFile)file).getCharset();
        }
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream contents = new BufferedInputStream(this.getContents());){
                IContentDescription description = contentTypeManager.getDescriptionFor(contents, this.getName(), new QualifiedName[]{IContentDescription.CHARSET});
                String string = description == null ? null : description.getCharset();
                return string;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String message = NLS.bind(Messages.history_errorContentDescription, this.getFullPath());
            throw new ResourceException(381, this.getFullPath(), message, e);
        }
    }

    @Override
    public InputStream getContents() throws CoreException {
        return this.store.getContents(this);
    }

    @Override
    public IPath getFullPath() {
        return this.fullPath;
    }

    @Override
    public long getModificationTime() {
        return this.lastModified;
    }

    @Override
    public String getName() {
        return this.fullPath.lastSegment();
    }

    public UniversalUniqueIdentifier getUUID() {
        return this.uuid;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append("FileState(uuid: ");
        s2.append(this.uuid.toString());
        s2.append(", lastModified: ");
        s2.append(this.lastModified);
        s2.append(", path: ");
        s2.append(this.fullPath);
        s2.append(')');
        return s2.toString();
    }
}

