/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil.locale;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.arakhne.afc.vmutil.Caller;
import org.arakhne.afc.vmutil.ClassLoaderFinder;
import org.arakhne.afc.vmutil.locale.LocaleMessageFormat;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class Locale {
    private static final int BUFFER_SIZE = 2048;
    private static Charset[] decodingCharsets;

    static {
        Charset def = Charset.defaultCharset();
        ArrayList<Charset> list = new ArrayList<Charset>();
        Charset c = Charset.forName("IBM437");
        if (c != null && !def.equals(c)) {
            list.add(c);
        }
        if ((c = Charset.forName("ISO-8859-1")) != null && !def.equals(c)) {
            list.add(c);
        }
        if ((c = Charset.forName("UTF-8")) != null && !def.equals(c)) {
            list.add(c);
        }
        list.add(def);
        decodingCharsets = new Charset[list.size()];
        list.toArray(decodingCharsets);
    }

    private Locale() {
    }

    public static Charset[] getPriorizedDecodingCharsets() {
        return decodingCharsets;
    }

    public static void setPriorizedDecodingCharsets(Charset[] charsets) {
        decodingCharsets = charsets;
    }

    private static Class<?> detectResourceClass(Class<?> resource) {
        if (resource == null) {
            return Caller.getCallerClass(2);
        }
        return resource;
    }

    @Pure
    @Inline(value="Locale.getStringWithDefaultFrom(ClassLoaderFinder.findClassLoader(), ($1), ($2), ($3), ($4))", imported={Locale.class, ClassLoaderFinder.class})
    public static String getStringWithDefaultFrom(String resourcePath, String key, String defaultValue, Object ... params) {
        return Locale.getStringWithDefaultFrom(ClassLoaderFinder.findClassLoader(), resourcePath, key, defaultValue, params);
    }

    @Pure
    public static String getStringWithDefaultFrom(ClassLoader classLoader, String resourcePath, String key, String defaultValue, Object ... params) {
        String result;
        if (resourcePath == null) {
            return defaultValue;
        }
        ResourceBundle resource = null;
        try {
            resource = ResourceBundle.getBundle(resourcePath, java.util.Locale.getDefault(), classLoader);
        }
        catch (MissingResourceException exep) {
            return defaultValue;
        }
        try {
            result = resource.getString(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
        result = result.replaceAll("[\\n\\r]", "\n");
        result = result.replaceAll("\\t", "\t");
        assert (params != null);
        return LocaleMessageFormat.format(result, params);
    }

    @Pure
    @Inline(value="Locale.getStringWithDefaultFrom(($1), ($2), ($3), ($4))", imported={Locale.class})
    public static String getStringFrom(String resourcePath, String key, Object ... params) {
        return Locale.getStringWithDefaultFrom(resourcePath, key, key, params);
    }

    @Pure
    @Inline(value="Locale.getStringWithDefaultFrom(($1), ($2), ($3), ($3), ($4))", imported={Locale.class})
    public static String getStringFrom(ClassLoader classLoader, String resourcePath, String key, Object ... params) {
        return Locale.getStringWithDefaultFrom(classLoader, resourcePath, key, key, params);
    }

    @Pure
    public static String getString(Class<?> resource, String key, Object ... params) {
        return Locale.getString(ClassLoaderFinder.findClassLoader(), Locale.detectResourceClass(resource), key, params);
    }

    @Pure
    public static String getString(ClassLoader classLoader, Class<?> resource, String key, Object ... params) {
        Class<?> res = Locale.detectResourceClass(resource);
        if (res == null) {
            return key;
        }
        String val = Locale.getStringWithDefaultFrom(classLoader, res.getCanonicalName(), key, null, params);
        if (val == null && classLoader != resource.getClassLoader()) {
            val = Locale.getStringWithDefaultFrom(classLoader, res.getCanonicalName(), key, null, params);
        }
        while (res != null && val == null) {
            if ((res = res.getSuperclass()) == null) continue;
            val = Locale.getStringWithDefaultFrom(classLoader, res.getCanonicalName(), key, null, params);
        }
        if (val == null) {
            return key;
        }
        return val;
    }

    public static String getString(String key, Object ... params) {
        Class<?> resource = Locale.detectResourceClass(null);
        return Locale.getString(ClassLoaderFinder.findClassLoader(), resource, key, params);
    }

    @Pure
    public static String getString(ClassLoader classLoader, String key, Object ... params) {
        return Locale.getString(classLoader, Locale.detectResourceClass(null), key, params);
    }

    @Pure
    public static String getStringWithDefault(Class<?> resource, String key, String defaultValue, Object ... params) {
        return Locale.getStringWithDefault(ClassLoaderFinder.findClassLoader(), Locale.detectResourceClass(resource), key, defaultValue, params);
    }

    @Pure
    public static String getStringWithDefault(ClassLoader classLoader, Class<?> resource, String key, String defaultValue, Object ... params) {
        Class<?> res = Locale.detectResourceClass(resource);
        if (res == null) {
            return defaultValue;
        }
        String val = Locale.getStringWithDefaultFrom(classLoader, res.getCanonicalName(), key, null, params);
        if (val == null && classLoader != resource.getClassLoader()) {
            val = Locale.getStringWithDefaultFrom(classLoader, res.getCanonicalName(), key, null, params);
        }
        while (res != null && val == null) {
            if ((res = res.getSuperclass()) == null) continue;
            val = Locale.getStringWithDefaultFrom(classLoader, res.getCanonicalName(), key, null, params);
        }
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Pure
    public static String getStringWithDefault(String key, String defaultValue, Object ... params) {
        return Locale.getStringWithDefault(ClassLoaderFinder.findClassLoader(), Locale.detectResourceClass(null), key, defaultValue, params);
    }

    @Pure
    public static String getStringWithDefault(ClassLoader classLoader, String key, String defaultValue, Object ... params) {
        return Locale.getStringWithDefault(classLoader, Locale.detectResourceClass(null), key, defaultValue, params);
    }

    @Pure
    public static String decodeString(byte[] bytes) {
        Charset[] prior = Locale.getPriorizedDecodingCharsets();
        String refBuffer = new String(bytes);
        CharBuffer buffer = null;
        Charset[] charsetArray = prior;
        int n = prior.length;
        int n2 = 0;
        while (n2 < n) {
            Charset charset = charsetArray[n2];
            buffer = Locale.decodeString(bytes, charset, refBuffer.length());
            if (buffer != null) break;
            ++n2;
        }
        if (buffer == null) {
            for (Charset charset : Charset.availableCharsets().values()) {
                buffer = Locale.decodeString(bytes, charset, refBuffer.length());
                if (buffer != null) break;
            }
        }
        if (buffer == null) {
            return refBuffer.trim();
        }
        return buffer.toString().trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CharBuffer decodeString(byte[] bytes, Charset charset, int referenceLength) {
        try {
            Charset autodetectedCharset;
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer buffer = decoder.decode(ByteBuffer.wrap(bytes));
            if (decoder.isAutoDetecting() && decoder.isCharsetDetected() && charset.contains(autodetectedCharset = decoder.detectedCharset())) {
                buffer.position(0);
                if (referenceLength < 0) return null;
                if (buffer.remaining() != referenceLength) return null;
                return buffer;
            }
            buffer.position(0);
            while (true) {
                if (!buffer.hasRemaining()) {
                    buffer.position(0);
                    if (referenceLength < 0) return null;
                    if (buffer.remaining() != referenceLength) return null;
                    return buffer;
                }
                char c = buffer.get();
                int type = Character.getType(c);
                switch (type) {
                    case 0: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: {
                        return null;
                    }
                }
            }
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return null;
    }

    public static String decodeString(InputStream stream) throws IOException {
        int read;
        byte[] completeBuffer = new byte[]{};
        byte[] buffer = new byte[2048];
        while ((read = stream.read(buffer)) > 0) {
            byte[] tmp = new byte[completeBuffer.length + read];
            System.arraycopy(completeBuffer, 0, tmp, 0, completeBuffer.length);
            System.arraycopy(buffer, 0, tmp, completeBuffer.length, read);
            completeBuffer = tmp;
        }
        return Locale.decodeString(completeBuffer);
    }

    public static boolean decodeString(InputStream stream, List<String> lineArray) throws IOException {
        int read;
        byte[] completeBuffer = new byte[]{};
        byte[] buffer = new byte[2048];
        while ((read = stream.read(buffer)) > 0) {
            byte[] tmp = new byte[completeBuffer.length + read];
            System.arraycopy(completeBuffer, 0, tmp, 0, completeBuffer.length);
            System.arraycopy(buffer, 0, tmp, completeBuffer.length, read);
            completeBuffer = tmp;
        }
        Charset westEuropean = Charset.forName("ISO-8859-1");
        Charset defaultCharset = Charset.defaultCharset();
        boolean ok = Locale.decodeString(new ByteArrayInputStream(completeBuffer), lineArray, defaultCharset);
        if (!ok && !defaultCharset.equals(westEuropean)) {
            ok = Locale.decodeString(new ByteArrayInputStream(completeBuffer), lineArray, westEuropean);
        }
        if (!ok) {
            for (Map.Entry<String, Charset> charset : Charset.availableCharsets().entrySet()) {
                if (!Locale.decodeString(new ByteArrayInputStream(completeBuffer), lineArray, charset.getValue())) continue;
                return true;
            }
        }
        return ok;
    }

    private static boolean decodeString(InputStream stream, List<String> lineArray, Charset charset) throws IOException {
        try {
            String line;
            BufferedReader breader = new BufferedReader(new InputStreamReader(stream, charset.newDecoder()));
            lineArray.clear();
            while ((line = breader.readLine()) != null) {
                lineArray.add(line);
            }
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
    }
}

