/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil.json;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import org.arakhne.afc.vmutil.StringEscaper;
import org.arakhne.afc.vmutil.json.JsonableObject;

public class JsonBuffer {
    private static final String INDENT_STRING = "\t";
    private static final String NULL_CONSTANT = "null";
    private static final String TRUE_CONSTANT = "true";
    private static final String FALSE_CONSTANT = "false";
    private final Map<String, Object> content = new TreeMap<String, Object>();

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void add(String name, Object value) {
        if (value != null) {
            this.content.put(name, value);
        }
    }

    public void add(String name, Iterable<?> value) {
        if (value != null) {
            this.content.put(name, value);
        }
    }

    public void add(String name, Map<?, ?> value) {
        if (value != null) {
            this.content.put(name, value);
        }
    }

    public void add(String name, JsonBuffer value) {
        if (value != null && value != this && !value.isEmpty()) {
            this.content.put(name, value);
        }
    }

    public void retainAll(String ... keys) {
        if (keys != null && keys.length > 0) {
            TreeSet<String> kk = new TreeSet<String>(Arrays.asList(keys));
            Iterator<Map.Entry<String, Object>> iterator = this.content.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                if (kk.contains(entry.getKey())) continue;
                iterator.remove();
            }
        }
    }

    public void clear() {
        this.content.clear();
    }

    public static String toString(String name, Object value, Object ... otherPairs) {
        JsonBuffer buffer = new JsonBuffer();
        buffer.add(name, value);
        int i = 0;
        while (i < otherPairs.length) {
            buffer.add(Objects.toString(otherPairs[i]), otherPairs[i + 1]);
            i += 2;
        }
        return buffer.toString();
    }

    public static String toString(JsonableObject value) {
        JsonBuffer buffer = new JsonBuffer();
        value.toJson(buffer);
        return buffer.toString();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        JsonBuffer.toString(buffer, 0, this.content);
        return buffer.toString();
    }

    private static void toString(StringBuilder buffer, int indent, JsonBuffer jsonBuffer) {
        JsonBuffer.toString(buffer, indent, jsonBuffer.content);
    }

    private static void toString(StringBuilder buffer, int indent, JsonableObject jsonObject) {
        JsonBuffer jsonBuffer = new JsonBuffer();
        jsonObject.toJson(jsonBuffer);
        JsonBuffer.toString(buffer, indent, jsonBuffer);
    }

    private static void toString(StringBuilder buffer, int indent, Map<?, ?> map) {
        buffer.append("{\n");
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",\n");
            }
            JsonBuffer.doIndent(buffer, indent + 1);
            buffer.append("\"");
            buffer.append(entry.getKey());
            buffer.append("\": ");
            Object value = entry.getValue();
            JsonBuffer.valueToString(buffer, false, indent, value);
        }
        buffer.append("\n");
        JsonBuffer.doIndent(buffer, indent);
        buffer.append("}");
    }

    private static void toString(StringBuilder buffer, int indent, Iterable<?> iterable) {
        buffer.append("[\n");
        boolean first = true;
        for (Object value : iterable) {
            if (first) {
                first = false;
            } else {
                buffer.append(",\n");
            }
            JsonBuffer.valueToString(buffer, true, indent, value);
        }
        buffer.append("\n");
        JsonBuffer.doIndent(buffer, indent);
        buffer.append("]");
    }

    private static void valueToString(StringBuilder buffer, boolean doIndent, int indent, Object value) {
        if (doIndent) {
            JsonBuffer.doIndent(buffer, indent + 1);
        }
        if (value == null) {
            buffer.append(NULL_CONSTANT);
        } else if (value instanceof JsonBuffer) {
            JsonBuffer.toString(buffer, indent + 1, (JsonBuffer)value);
        } else if (value instanceof JsonableObject) {
            JsonBuffer.toString(buffer, indent + 1, (JsonableObject)value);
        } else if (value instanceof Map) {
            JsonBuffer.toString(buffer, indent + 1, (Map)value);
        } else if (value instanceof Iterable) {
            JsonBuffer.toString(buffer, indent + 1, (Iterable)value);
        } else if (value instanceof Number) {
            buffer.append(Objects.toString(value));
        } else if (value instanceof Boolean) {
            buffer.append((Boolean)value != false ? TRUE_CONSTANT : FALSE_CONSTANT);
        } else {
            String rawValue = Objects.toString(value);
            buffer.append("\"");
            StringEscaper escaper = new StringEscaper("\\", "\"", "\\", "/");
            buffer.append(escaper.escape(rawValue));
            buffer.append("\"");
        }
    }

    private static void doIndent(StringBuilder buffer, int level) {
        int i = 0;
        while (i < level) {
            buffer.append(INDENT_STRING);
            ++i;
        }
    }
}

