/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.arakhne.afc.vmutil.FileSystem;
import org.arakhne.afc.vmutil.asserts.AssertMessages;
import org.arakhne.afc.vmutil.locale.Locale;

class URLConnection
extends java.net.URLConnection {
    private static final String CONTENT_TYPE = "content-type";
    private static final String CONTENT_LENGTH = "content-length";
    private static final String LAST_MODIFIED = "last-modified";
    private File file;
    private String contentType;

    protected URLConnection(URL url) {
        super(url);
    }

    @Override
    public String getHeaderField(int index) {
        assert (index >= 0) : AssertMessages.positiveOrZeroParameter();
        try {
            this.connect();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        switch (index) {
            case 0: {
                return this.contentType;
            }
            case 1: {
                return Long.toString(this.file.length());
            }
            case 2: {
                return Long.toString(this.file.lastModified());
            }
        }
        return null;
    }

    @Override
    public String getHeaderField(String name) {
        try {
            this.connect();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (CONTENT_TYPE.equals(name)) {
            return this.contentType;
        }
        if (CONTENT_LENGTH.equals(name)) {
            return Long.toString(this.file.length());
        }
        if (LAST_MODIFIED.equals(name)) {
            return Long.toString(this.file.lastModified());
        }
        return null;
    }

    @Override
    public String getHeaderFieldKey(int index) {
        assert (index >= 0) : AssertMessages.positiveOrZeroParameter();
        switch (index) {
            case 0: {
                return CONTENT_TYPE;
            }
            case 1: {
                return CONTENT_LENGTH;
            }
            case 2: {
                return LAST_MODIFIED;
            }
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        try {
            this.connect();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        HashMap<String, List<String>> flds = new HashMap<String, List<String>>();
        flds.put(CONTENT_TYPE, URLConnection.singletonList(this.contentType));
        flds.put(CONTENT_LENGTH, URLConnection.singletonList(Long.toString(this.file.length())));
        flds.put(LAST_MODIFIED, URLConnection.singletonList(Long.toString(this.file.lastModified())));
        return flds;
    }

    private static List<String> singletonList(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(value);
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.file = FileSystem.convertURLToFile(this.url);
            if (this.file == null) {
                throw new FileNotFoundException(this.url.toExternalForm());
            }
            this.contentType = new MimetypesFileTypeMap().getContentType(this.file);
            this.connected = true;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.connect();
        if (this.getDoOutput()) {
            OutputStream os = new FileOutputStream(this.file);
            if (this.getUseCaches()) {
                os = new BufferedOutputStream(os);
            }
            return os;
        }
        throw new UnknownServiceException(Locale.getString("E1", new Object[0]));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this.getDoInput()) {
            InputStream is = new FileInputStream(this.file);
            if (this.getUseCaches()) {
                is = new BufferedInputStream(is);
            }
            return is;
        }
        throw new UnknownServiceException("E2");
    }
}

