/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil.caller;

import org.arakhne.afc.vmutil.ClassLoaderFinder;
import org.arakhne.afc.vmutil.caller.Caller;

public class StackTraceCaller
implements Caller {
    private static Class<?> loadClass(String name) {
        try {
            return ClassLoaderFinder.findClassLoader().loadClass(name);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected static StackTraceElement getTraceElementAt(int level) {
        if (level < 0) {
            return null;
        }
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int j = -1;
            boolean found = false;
            int i = 0;
            while (i < stackTrace.length) {
                if (found) {
                    if (i - j == level) {
                        return stackTrace[i];
                    }
                } else {
                    Class<?> type = StackTraceCaller.loadClass(stackTrace[i].getClassName());
                    if (type != null && Caller.class.isAssignableFrom(type)) {
                        j = i + 1;
                    } else if (j >= 0) {
                        found = true;
                        if (i - j == level) {
                            return stackTrace[i];
                        }
                    }
                }
                ++i;
            }
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Class<?> getCallerClass(int level) {
        StackTraceElement element = StackTraceCaller.getTraceElementAt(level);
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Class<?> type = StackTraceCaller.loadClass(element.getClassName());
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return type;
    }

    @Override
    public String getCallerMethod(int level) {
        StackTraceElement element = StackTraceCaller.getTraceElementAt(level);
        if (element == null) {
            throw new IllegalArgumentException();
        }
        return element.getMethodName();
    }

    @Override
    public long getCallerLine(int level) {
        StackTraceElement element = StackTraceCaller.getTraceElementAt(level);
        if (element == null) {
            throw new IllegalArgumentException();
        }
        return element.getLineNumber();
    }

    @Override
    public String getCallerFilename(int level) {
        StackTraceElement element = StackTraceCaller.getTraceElementAt(level);
        if (element == null) {
            throw new IllegalArgumentException();
        }
        return element.getFileName();
    }
}

