/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.eclipse.xtext.xbase.lib.Pure;

public final class URLHandlerUtil {
    private static final String HANDLER_PACKAGES = "java.protocol.handler.pkgs";

    private URLHandlerUtil() {
    }

    @Pure
    public static Iterator<Class<? extends URLStreamHandler>> getHandlersFor(String protocol) {
        return new HandlerIterator(protocol);
    }

    private static void install(String ... packageNames) {
        LinkedList<String> array = new LinkedList<String>();
        String str = System.getProperty(HANDLER_PACKAGES);
        if (str != null && !"".equals(str)) {
            array.addAll(Arrays.asList(str.split("\\|")));
        }
        String[] stringArray = packageNames;
        int n = packageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String packageName = stringArray[n2];
            if (!array.contains(packageName)) {
                array.add(0, packageName);
            }
            ++n2;
        }
        StringBuilder buffer = new StringBuilder();
        for (String s2 : array) {
            if (buffer.length() > 0) {
                buffer.append('|');
            }
            buffer.append(s2);
        }
        String nstr = buffer.toString();
        if (!nstr.equals(str)) {
            System.setProperty(HANDLER_PACKAGES, nstr);
        }
    }

    private static void uninstall(String ... packageNames) {
        LinkedList<String> array = new LinkedList<String>();
        String str = System.getProperty(HANDLER_PACKAGES);
        if (str != null && !"".equals(str)) {
            array.addAll(Arrays.asList(str.split("\\|")));
        }
        array.removeAll(Arrays.asList(packageNames));
        StringBuilder buffer = new StringBuilder();
        for (String s2 : array) {
            if (buffer.length() > 0) {
                buffer.append('|');
            }
            buffer.append(s2);
        }
        String nstr = buffer.toString();
        if (!nstr.equals(str)) {
            System.setProperty(HANDLER_PACKAGES, nstr);
        }
    }

    public static void installArakhneHandlers() {
        URLHandlerUtil.install(URLHandlerUtil.class.getPackage().getName());
    }

    public static void uninstallArakhneHandlers() {
        URLHandlerUtil.uninstall(URLHandlerUtil.class.getPackage().getName());
    }

    private static class HandlerIterator
    implements Iterator<Class<? extends URLStreamHandler>> {
        private final String protocol;
        private final String[] packages;
        private int position;
        private Class<? extends URLStreamHandler> next;

        HandlerIterator(String protocol) {
            this.protocol = protocol;
            String str = System.getProperty(URLHandlerUtil.HANDLER_PACKAGES);
            this.packages = str == null ? new String[0] : str.split("\\|");
            this.searchNext();
        }

        private void searchNext() {
            this.next = null;
            ClassLoader clsLoader = this.getClass().getClassLoader();
            while (this.next == null && this.position < this.packages.length) {
                String typename = this.packages[this.position++];
                try {
                    Class<?> type = clsLoader.loadClass(String.valueOf(typename) + "." + this.protocol + ".Handler");
                    if (type == null || !URLStreamHandler.class.isAssignableFrom(type)) continue;
                    this.next = type;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Class<? extends URLStreamHandler> next() {
            Class<? extends URLStreamHandler> n = this.next;
            if (n == null) {
                throw new NoSuchElementException();
            }
            this.searchNext();
            return n;
        }
    }
}

