/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.arakhne.afc.vmutil.asserts.AssertMessages;
import org.eclipse.xtext.xbase.lib.Pure;

public class StringEscaper {
    public static final String[][] JAVA_SPECIAL_CHARS = new String[][]{{"\b", "\\b"}, {"\n", "\\n"}, {"\t", "\\t"}, {"\f", "\\f"}, {"\r", "\\r"}};
    public static final String JAVA_ESCAPE_CHAR = "\\";
    public static final String JAVA_STRING_CHAR = "\"";
    public static final String JSON_SPECIAL_ESCAPED_CHAR = "/";
    public static final int JAVA_MIN_CHAR = 32;
    public static final int JAVA_MAX_CHAR = 127;
    private final Set<String> escapeCharacters = new TreeSet<String>();
    private final String toEscapeCharacter;
    private final Map<String, String> specialChars = new TreeMap<String, String>();
    private int minValidChar;
    private int maxValidChar;

    public StringEscaper() {
        this(JAVA_ESCAPE_CHAR, JAVA_STRING_CHAR, JAVA_ESCAPE_CHAR);
    }

    public StringEscaper(CharSequence toEscapeCharacter, CharSequence ... escapeCharacters) {
        assert (toEscapeCharacter != null) : AssertMessages.notNullParameter(0);
        assert (toEscapeCharacter.length() > 0) : AssertMessages.invalidValue(0);
        assert (escapeCharacters != null) : AssertMessages.notNullParameter(1);
        assert (escapeCharacters.length > 0) : AssertMessages.tooSmallArrayParameter(escapeCharacters.length, 1);
        CharSequence[] charSequenceArray = escapeCharacters;
        int n = escapeCharacters.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence c = charSequenceArray[n2];
            this.escapeCharacters.add(c.toString());
            ++n2;
        }
        this.toEscapeCharacter = toEscapeCharacter.toString();
        this.setSpecialChars(JAVA_SPECIAL_CHARS);
        this.setValidCharRange(32, 127);
    }

    public void setSpecialChars(String[][] chars) {
        assert (chars != null) : AssertMessages.notNullParameter();
        this.specialChars.clear();
        String[][] stringArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pair = stringArray[n2];
            assert (pair != null);
            assert (pair.length == 2);
            assert (pair[0].length() > 0);
            assert (pair[1].length() > 0);
            this.specialChars.put(pair[0], pair[1]);
            ++n2;
        }
    }

    public void setValidCharRange(int minValidChar, int maxValidChar) {
        if (minValidChar <= maxValidChar) {
            this.minValidChar = minValidChar;
            this.maxValidChar = maxValidChar;
        } else {
            this.maxValidChar = minValidChar;
            this.minValidChar = maxValidChar;
        }
    }

    public String escape(CharSequence text) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            String cs = Character.toString(c);
            if (this.escapeCharacters.contains(cs)) {
                result.append(this.toEscapeCharacter);
                result.append(cs);
            } else {
                String special = this.specialChars.get(cs);
                if (special != null) {
                    result.append(special);
                } else if (c < this.minValidChar || c > this.maxValidChar) {
                    if (this.maxValidChar > 0) {
                        result.append("\\u");
                        result.append(StringEscaper.formatHex(c, 4));
                    }
                } else {
                    result.append(cs);
                }
            }
            ++i;
        }
        return result.toString();
    }

    @Pure
    public static String formatHex(int amount, int digits) {
        StringBuffer hex = new StringBuffer(Integer.toHexString(amount));
        while (hex.length() < digits) {
            hex.insert(0, "0");
        }
        return hex.toString();
    }
}

