/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arakhne.afc.vmutil.AndroidResourceWrapper;
import org.arakhne.afc.vmutil.OperatingSystem;
import org.arakhne.afc.vmutil.ResourceWrapper;
import org.arakhne.afc.vmutil.StandardJREResourceWrapper;
import org.arakhne.afc.vmutil.URLHandlerUtil;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class Resources {
    public static final String NAME_SEPARATOR = "/";
    private static ResourceWrapper currentResourceInstance;

    static {
        URLHandlerUtil.installArakhneHandlers();
        AndroidResourceWrapper wrapper = null;
        switch (OperatingSystem.getCurrentOS()) {
            case ANDROID: {
                wrapper = new AndroidResourceWrapper();
            }
        }
        currentResourceInstance = wrapper == null ? new StandardJREResourceWrapper() : wrapper;
    }

    private Resources() {
    }

    @Pure
    public static URL getResource(String path) {
        return Resources.getResource(null, path);
    }

    @Pure
    public static URL getResource(ClassLoader classLoader, Package packagename, String path) {
        if (packagename == null || path == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(packagename.getName().replaceAll(Pattern.quote("."), Matcher.quoteReplacement(NAME_SEPARATOR)));
        if (!path.startsWith(NAME_SEPARATOR)) {
            b.append(NAME_SEPARATOR);
        }
        b.append(path);
        ClassLoader cl = classLoader;
        if (cl == null) {
            cl = packagename.getClass().getClassLoader();
        }
        return Resources.getResource(cl, b.toString());
    }

    @Pure
    public static URL getResource(Class<?> classname, String path) {
        if (classname == null) {
            return null;
        }
        URL u = Resources.getResource(classname.getClassLoader(), classname.getPackage(), path);
        if (u == null) {
            u = Resources.getResource(classname.getClassLoader(), path);
        }
        return u;
    }

    @Pure
    public static URL getResource(ClassLoader classLoader, String path) {
        return currentResourceInstance.getResource(classLoader, path);
    }

    @Pure
    public static InputStream getResourceAsStream(String path) {
        return Resources.getResourceAsStream(null, path);
    }

    @Pure
    public static InputStream getResourceAsStream(ClassLoader classLoader, Package packagename, String path) {
        if (packagename == null || path == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(packagename.getName().replaceAll(Pattern.quote("."), Matcher.quoteReplacement(NAME_SEPARATOR)));
        if (!path.startsWith(NAME_SEPARATOR)) {
            b.append(NAME_SEPARATOR);
        }
        b.append(path);
        ClassLoader cl = classLoader;
        if (cl == null) {
            cl = packagename.getClass().getClassLoader();
        }
        return Resources.getResourceAsStream(cl, b.toString());
    }

    @Pure
    public static InputStream getResourceAsStream(Class<?> classname, String path) {
        if (classname == null) {
            return null;
        }
        InputStream is = Resources.getResourceAsStream(classname.getClassLoader(), classname.getPackage(), path);
        if (is == null) {
            is = Resources.getResourceAsStream(classname.getClassLoader(), path);
        }
        return is;
    }

    @Pure
    public static InputStream getResourceAsStream(ClassLoader classLoader, String path) {
        return currentResourceInstance.getResourceAsStream(classLoader, path);
    }

    @Pure
    @Inline(value="Resources.getPropertyFile(($1).getClassLoader(), ($1), ($2))", imported={Resources.class})
    public static URL getPropertyFile(Class<?> classname, Locale locale) {
        return Resources.getPropertyFile(classname.getClassLoader(), classname, locale);
    }

    @Pure
    public static URL getPropertyFile(ClassLoader classLoader, Class<?> classname, Locale locale) {
        String country;
        StringBuilder name = new StringBuilder();
        if (locale != null && (country = locale.getCountry()) != null && !country.isEmpty()) {
            name.append(classname.getSimpleName());
            name.append("_");
            name.append(country);
            name.append(".properties");
            URL url = Resources.getResource(classLoader, classname.getPackage(), name.toString());
            if (url != null) {
                return url;
            }
        }
        name.setLength(0);
        name.append(classname.getSimpleName());
        name.append(".properties");
        return Resources.getResource(classLoader, classname.getPackage(), name.toString());
    }

    @Pure
    public static String translateResourceName(String resourceName) {
        return currentResourceInstance.translateResourceName(resourceName);
    }
}

