/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.io.FileNotFoundException;
import org.arakhne.afc.vmutil.FileSystem;
import org.arakhne.afc.vmutil.OperatingSystem;

public final class OperatingSystemInfo {
    private OperatingSystemInfo() {
    }

    private static void showTitle(String title) {
        System.out.print("#######################################\n# ");
        System.out.println(title);
        System.out.println("#######################################");
    }

    private static void showPropertyValue(String name) {
        OperatingSystemInfo.showValue(name, System.getProperty(name));
    }

    private static void showValue(String name, Object value) {
        System.out.print(name);
        System.out.print(" = ");
        System.out.println(value == null ? null : value.toString());
    }

    public static void main(String[] args) {
        OperatingSystemInfo.showTitle("JRE Properties");
        OperatingSystemInfo.showPropertyValue("java.class.path");
        OperatingSystemInfo.showPropertyValue("java.library.path");
        OperatingSystemInfo.showPropertyValue("java.home");
        OperatingSystemInfo.showPropertyValue("os.name");
        OperatingSystemInfo.showPropertyValue("os.version");
        OperatingSystemInfo.showPropertyValue("file.separator");
        OperatingSystemInfo.showPropertyValue("path.separator");
        OperatingSystemInfo.showPropertyValue("sun.arch.data.model");
        OperatingSystemInfo.showPropertyValue("user.dir");
        OperatingSystemInfo.showPropertyValue("user.name");
        OperatingSystemInfo.showPropertyValue("user.home");
        OperatingSystemInfo.showTitle("FileSystem");
        OperatingSystemInfo.showValue("getUserHomeDirectoryName()", FileSystem.getUserHomeDirectoryName());
        try {
            OperatingSystemInfo.showValue("getUserHomeDirectory()", FileSystem.getUserHomeDirectory());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        OperatingSystemInfo.showTitle("OperatingSystem");
        OperatingSystemInfo.showValue("getCurrentOSName()", OperatingSystem.getCurrentOSName());
        OperatingSystemInfo.showValue("getCurrentOSVersion()", OperatingSystem.getCurrentOSVersion());
        OperatingSystemInfo.showValue("getOSSerialNumber()", OperatingSystem.getOSSerialNumber());
        OperatingSystemInfo.showValue("getOSUUID()", OperatingSystem.getOSUUID());
        OperatingSystemInfo.showValue("getIdentificationType()", OperatingSystem.getIdentificationType().name());
        OperatingSystemInfo.showValue("getOperatingSystemArchitectureDataModel()", Integer.toString(OperatingSystem.getOperatingSystemArchitectureDataModel()));
        OperatingSystemInfo.showValue("getCurrentOS()", OperatingSystem.getCurrentOS().name());
        OperatingSystemInfo.showValue("is32BitOperatingSystem()", Boolean.toString(OperatingSystem.is32BitOperatingSystem()));
        OperatingSystemInfo.showValue("is64BitOperatingSystem()", Boolean.toString(OperatingSystem.is64BitOperatingSystem()));
    }
}

