/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.arakhne.afc.vmutil.locale.Locale;
import org.eclipse.xtext.xbase.lib.Pure;

public final class MACNumber {
    public static final char MACNUMBER_SEPARATOR = '/';
    public static final MACNumber NULL = new MACNumber();
    private final byte[] bytes;

    public MACNumber() {
        this.bytes = new byte[6];
    }

    public MACNumber(byte[] bytes) {
        if (bytes == null || bytes.length != 6) {
            throw new IllegalArgumentException(Locale.getString("E1", new Object[0]));
        }
        this.bytes = new byte[6];
        System.arraycopy(bytes, 0, this.bytes, 0, 6);
    }

    public MACNumber(String address) {
        if (address == null) {
            throw new IllegalArgumentException(Locale.getString("E1", new Object[0]));
        }
        String[] parts = address.split(Pattern.quote(":"));
        if (parts.length != 6) {
            throw new IllegalArgumentException(Locale.getString("E1", new Object[0]));
        }
        this.bytes = new byte[6];
        try {
            int i = 0;
            while (i < 6) {
                int val = Integer.parseInt(parts[i], 16);
                this.bytes[i] = (byte)val;
                ++i;
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(Locale.getString("E1", new Object[0]), exception);
        }
    }

    @Pure
    public static MACNumber[] parse(String addresses) {
        if (addresses == null || "".equals(addresses)) {
            return new MACNumber[0];
        }
        String[] adrs = addresses.split(Pattern.quote(Character.toString('/')));
        ArrayList<MACNumber> list = new ArrayList<MACNumber>();
        String[] stringArray = adrs;
        int n = adrs.length;
        int n2 = 0;
        while (n2 < n) {
            String adr = stringArray[n2];
            list.add(new MACNumber(adr));
            ++n2;
        }
        MACNumber[] tab = new MACNumber[list.size()];
        list.toArray(tab);
        list.clear();
        return tab;
    }

    @Pure
    public static String[] parseAsString(String addresses) {
        if (addresses == null || "".equals(addresses)) {
            return new String[0];
        }
        String[] adrs = addresses.split(Pattern.quote(Character.toString('/')));
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = adrs;
        int n = adrs.length;
        int n2 = 0;
        while (n2 < n) {
            String adr = stringArray[n2];
            list.add(new MACNumber(adr).toString());
            ++n2;
        }
        String[] tab = new String[list.size()];
        list.toArray(tab);
        list.clear();
        return tab;
    }

    @Pure
    public static String join(MACNumber ... addresses) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        MACNumber[] mACNumberArray = addresses;
        int n = addresses.length;
        int n2 = 0;
        while (n2 < n) {
            MACNumber number = mACNumberArray[n2];
            if (buf.length() > 0) {
                buf.append('/');
            }
            buf.append(number);
            ++n2;
        }
        return buf.toString();
    }

    @Pure
    public static Collection<MACNumber> getAllAdapters() {
        Enumeration<NetworkInterface> interfaces;
        ArrayList<MACNumber> av = new ArrayList<MACNumber>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException exception) {
            return av;
        }
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface inter = interfaces.nextElement();
                try {
                    byte[] addr = inter.getHardwareAddress();
                    if (addr == null) continue;
                    av.add(new MACNumber(addr));
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
        }
        return av;
    }

    @Pure
    public static Map<InetAddress, MACNumber> getAllMappings() {
        Enumeration<NetworkInterface> interfaces;
        HashMap<InetAddress, MACNumber> av = new HashMap<InetAddress, MACNumber>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException exception) {
            return av;
        }
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface inter = interfaces.nextElement();
                try {
                    byte[] addr = inter.getHardwareAddress();
                    if (addr == null) continue;
                    MACNumber mac = new MACNumber(addr);
                    Enumeration<InetAddress> inets = inter.getInetAddresses();
                    while (inets.hasMoreElements()) {
                        InetAddress inet = inets.nextElement();
                        av.put(inet, mac);
                    }
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
        }
        return av;
    }

    @Pure
    public static MACNumber getPrimaryAdapter() {
        Enumeration<NetworkInterface> interfaces;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException exception) {
            return null;
        }
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface inter = interfaces.nextElement();
                try {
                    byte[] addr = inter.getHardwareAddress();
                    if (addr == null) continue;
                    return new MACNumber(addr);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Pure
    public static Collection<InetAddress> getPrimaryAdapterAddresses() {
        Enumeration<NetworkInterface> interfaces;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException exception) {
            return Collections.emptyList();
        }
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface inter = interfaces.nextElement();
                try {
                    byte[] addr = inter.getHardwareAddress();
                    if (addr == null) continue;
                    ArrayList<InetAddress> inetList = new ArrayList<InetAddress>();
                    Enumeration<InetAddress> inets = inter.getInetAddresses();
                    while (inets.hasMoreElements()) {
                        inetList.add(inets.nextElement());
                    }
                    return inetList;
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
        }
        return Collections.emptyList();
    }

    @Pure
    public boolean equals(Object object) {
        if (!(object instanceof MACNumber)) {
            return false;
        }
        byte[] bao = ((MACNumber)object).bytes;
        if (bao.length != this.bytes.length) {
            return false;
        }
        int i = 0;
        while (i < bao.length) {
            if (bao[i] != this.bytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Pure
    public int hashCode() {
        int blen = this.bytes.length;
        int hash = 1;
        int i = 0;
        while (i < blen) {
            hash = 31 * hash + Byte.hashCode(this.bytes[i]);
            ++i;
        }
        return hash ^ hash >> 31;
    }

    @Pure
    public String toString() {
        int blen = this.bytes.length;
        StringBuilder sb = new StringBuilder(blen * 3);
        int i = 0;
        while (i < blen) {
            int lo = this.bytes[i];
            int hi = lo >> 4 & 0xF;
            lo &= 0xF;
            if (i != 0) {
                sb.append(':');
            }
            sb.append(Character.forDigit(hi, 16));
            sb.append(Character.forDigit(lo, 16));
            ++i;
        }
        return sb.toString();
    }

    @Pure
    public boolean isNull() {
        int i = 0;
        while (i < this.bytes.length) {
            if (this.bytes[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Pure
    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }
}

