/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.arakhne.afc.vmutil.URISchemeType;
import org.arakhne.afc.vmutil.locale.Locale;
import org.eclipse.xtext.xbase.lib.Pure;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.net.www.ParseUtil;

public class DynamicURLClassLoader
extends SecureClassLoader {
    protected URLClassPath ucp;
    protected AccessControlContext acc;

    protected DynamicURLClassLoader(ClassLoader parent, AccessControlContext acc, URL ... urls) {
        super(parent);
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(DynamicURLClassLoader.mergeClassPath(urls));
        this.acc = acc;
    }

    public void addURL(final URL url) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                DynamicURLClassLoader.this.ucp.addURL(url);
                return null;
            }
        }, this.acc);
    }

    public void addURLs(URL ... urls) {
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            this.addURL(url);
            ++n2;
        }
    }

    public void removeURLs(URL ... urls) {
        HashSet<URL> set = new HashSet<URL>();
        set.addAll(Arrays.asList(this.ucp.getURLs()));
        set.removeAll(Arrays.asList(urls));
        URL[] tab = new URL[set.size()];
        set.toArray(tab);
        this.ucp = new URLClassPath(tab);
    }

    public void removeURL(URL url) {
        this.removeURLs(url);
    }

    @Pure
    public URL[] getURLs() {
        return this.ucp.getURLs();
    }

    @Override
    @Pure
    protected Class<?> findClass(final String name) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    Resource res = DynamicURLClassLoader.this.ucp.getResource(path, false);
                    if (res != null) {
                        try {
                            return DynamicURLClassLoader.this.defineClass(name, res);
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                    }
                    throw new ClassNotFoundException(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    protected Class<?> defineClass(String name, Resource res) throws IOException {
        ByteBuffer bb;
        int i = name.lastIndexOf(46);
        URL url = res.getCodeSourceURL();
        if (i != -1) {
            String pkgname = name.substring(0, i);
            Package pkg = this.getPackage(pkgname);
            Manifest man = res.getManifest();
            if (pkg != null) {
                if (pkg.isSealed()) {
                    if (!pkg.isSealed(url)) {
                        throw new SecurityException(Locale.getString("E1", pkgname));
                    }
                } else if (man != null && DynamicURLClassLoader.isSealed(pkgname, man)) {
                    throw new SecurityException(Locale.getString("E2", pkgname));
                }
            } else if (man != null) {
                this.definePackage(pkgname, man, url);
            } else {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
        }
        if ((bb = res.getByteBuffer()) != null) {
            CodeSigner[] signers = res.getCodeSigners();
            CodeSource cs = new CodeSource(url, signers);
            return this.defineClass(name, bb, cs);
        }
        byte[] b = res.getBytes();
        CodeSigner[] signers = res.getCodeSigners();
        CodeSource cs = new CodeSource(url, signers);
        return this.defineClass(name, b, 0, b.length, cs);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        String path = name.replace('.', '/').concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(sealed)) {
            sealBase = url;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private static boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    @Override
    @Pure
    public URL findResource(final String name) {
        URL url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return DynamicURLClassLoader.this.ucp.findResource(name, true);
            }
        }, this.acc);
        return url != null ? this.ucp.checkURL(url) : null;
    }

    @Override
    @Pure
    public Enumeration<URL> findResources(String name) throws IOException {
        final Enumeration e = this.ucp.findResources(name, true);
        return new Enumeration<URL>(){
            private URL url;

            private boolean next() {
                URL u;
                if (this.url != null) {
                    return true;
                }
                while ((u = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                    @Override
                    public URL run() {
                        if (!e.hasMoreElements()) {
                            return null;
                        }
                        return (URL)e.nextElement();
                    }
                }, DynamicURLClassLoader.this.acc)) != null) {
                    this.url = DynamicURLClassLoader.this.ucp.checkURL(u);
                    if (this.url == null) continue;
                }
                return this.url != null;
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL u = this.url;
                this.url = null;
                return u;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }
        };
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        SecurityManager sm;
        String path;
        Permission permission;
        URLConnection urlConnection;
        PermissionCollection perms = super.getPermissions(codesource);
        URL url = codesource.getLocation();
        try {
            urlConnection = url.openConnection();
            permission = urlConnection.getPermission();
        }
        catch (IOException ioe) {
            permission = null;
            urlConnection = null;
        }
        if (permission != null && permission instanceof FilePermission) {
            path = permission.getName();
            if (path.endsWith(File.separator)) {
                path = String.valueOf(path) + "-";
                permission = new FilePermission(path, "read");
            }
        } else if (permission == null && URISchemeType.FILE.isURL(url)) {
            path = url.getFile().replace('/', File.separatorChar);
            if ((path = ParseUtil.decode(path)).endsWith(File.separator)) {
                path = String.valueOf(path) + "-";
            }
            permission = new FilePermission(path, "read");
        } else {
            String host;
            URL locUrl = url;
            if (urlConnection instanceof JarURLConnection) {
                locUrl = ((JarURLConnection)urlConnection).getJarFileURL();
            }
            if ((host = locUrl.getHost()) == null) {
                host = "localhost";
            }
            permission = new SocketPermission(host, "connect,accept");
        }
        if ((sm = System.getSecurityManager()) != null) {
            final Permission fp = permission;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() throws SecurityException {
                    sm.checkPermission(fp);
                    return null;
                }
            }, this.acc);
        }
        perms.add(permission);
        return perms;
    }

    @Pure
    public static DynamicURLClassLoader newInstance(final ClassLoader parent, final URL ... urls) {
        final AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction<DynamicURLClassLoader>(){

            @Override
            public DynamicURLClassLoader run() {
                return new FactoryDynamicURLClassLoader(parent, acc, urls);
            }
        });
    }

    private static URL[] mergeClassPath(URL ... urls) {
        String path = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        String[] parts = path.split(Pattern.quote(separator));
        URL[] u = new URL[parts.length + urls.length];
        int i = 0;
        while (i < parts.length) {
            try {
                u[i] = new File(parts[i]).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            ++i;
        }
        System.arraycopy(urls, 0, u, parts.length, urls.length);
        return u;
    }

    protected static final class FactoryDynamicURLClassLoader
    extends DynamicURLClassLoader {
        protected FactoryDynamicURLClassLoader(ClassLoader parent, AccessControlContext acc, URL ... urls) {
            super(parent, acc, urls);
        }

        @Override
        public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            int i;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null && (i = name.lastIndexOf(46)) != -1) {
                sm.checkPackageAccess(name.substring(0, i));
            }
            return super.loadClass(name, resolve);
        }
    }
}

