/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arakhne.afc.vmutil.locale.Locale;
import org.eclipse.xtext.xbase.lib.Pure;

public final class ColorNames {
    public static final String TRANSPARENT = "transparent";
    public static final String WHITE = "white";
    public static final String LIGHT_GRAY = "lightgray";
    public static final String GRAY = "gray";
    public static final String DARK_GRAY = "darkgray";
    public static final String BLACK = "black";
    public static final String RED = "red";
    public static final String PINK = "pink";
    public static final String ORANGE = "orange";
    public static final String YELLOW = "yellow";
    public static final String GREEN = "green";
    public static final String MAGENTA = "magenta";
    public static final String CYAN = "cyan";
    public static final String BLUE = "blue";
    private static final Map<String, Integer> COLOR_MATCHES = ColorNames.initializeColors();
    private static final String POSITIVE_INTEGER_NUMBER_PATTERN = "[0-9]+";
    private static final String COLOR_DEFINITION_PATTERN = "^\\s*([^:\\s*]+)\\s*:\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*$";
    private static final String EOL_PATTERN = "[ \t\n\r]*;[ \\t\\n\\r]*";

    private ColorNames() {
    }

    private static Map<String, Integer> initializeColors() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        String colors = Locale.getString(ColorNames.class, "COLOR_MATCHES", new Object[0]);
        if (colors != null) {
            Pattern pattern = Pattern.compile(COLOR_DEFINITION_PATTERN);
            String[] stringArray = colors.split(EOL_PATTERN);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String definition = stringArray[n2];
                Matcher matcher = pattern.matcher(definition);
                if (matcher.matches()) {
                    map.put(matcher.group(1).toLowerCase(), ColorNames.encodeRgbaColor(Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5))));
                }
                ++n2;
            }
        }
        ColorNames.ensureColorDefinition(map, TRANSPARENT);
        ColorNames.ensureColorDefinition(map, WHITE);
        ColorNames.ensureColorDefinition(map, LIGHT_GRAY);
        ColorNames.ensureColorDefinition(map, GRAY);
        ColorNames.ensureColorDefinition(map, DARK_GRAY);
        ColorNames.ensureColorDefinition(map, BLACK);
        ColorNames.ensureColorDefinition(map, RED);
        ColorNames.ensureColorDefinition(map, PINK);
        ColorNames.ensureColorDefinition(map, ORANGE);
        ColorNames.ensureColorDefinition(map, YELLOW);
        ColorNames.ensureColorDefinition(map, GREEN);
        ColorNames.ensureColorDefinition(map, MAGENTA);
        ColorNames.ensureColorDefinition(map, CYAN);
        ColorNames.ensureColorDefinition(map, BLUE);
        return map;
    }

    private static void ensureColorDefinition(Map<String, Integer> colors, String colorName) {
        if (!colors.containsKey(colorName)) {
            throw new IllegalStateException(MessageFormat.format("Missed color definition for ''{0}''", colorName));
        }
    }

    private static int encodeRgbaColor(int red, int green, int blue, int alpha) {
        int col = (alpha & 0xFF) << 24;
        col |= (red & 0xFF) << 16;
        col |= (green & 0xFF) << 8;
        return col |= blue & 0xFF;
    }

    @Pure
    public static Set<String> getColorNames() {
        return Collections.unmodifiableSet(COLOR_MATCHES.keySet());
    }

    @Pure
    public static Map<String, Integer> getColorDefinitions() {
        return Collections.unmodifiableMap(COLOR_MATCHES);
    }

    @Pure
    public static int getColorFromName(String colorName, int defaultValue) {
        Integer value = COLOR_MATCHES.get(Strings.nullToEmpty(colorName).toLowerCase());
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Pure
    public static Integer getColorFromName(String colorName) {
        return COLOR_MATCHES.get(colorName);
    }

    @Pure
    public static String getColorNameFromValue(int colorValue) {
        for (Map.Entry<String, Integer> entry : COLOR_MATCHES.entrySet()) {
            int knownValue = entry.getValue();
            if (colorValue != knownValue) continue;
            return entry.getKey();
        }
        return null;
    }
}

