/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.vmutil;

import org.eclipse.xtext.xbase.lib.Pure;

public final class ClassLoaderFinder {
    private static volatile ClassLoader dynamicLoader;

    private ClassLoaderFinder() {
    }

    @Pure
    public static ClassLoader findClassLoader() {
        if (dynamicLoader == null) {
            return ClassLoaderFinder.class.getClassLoader();
        }
        return dynamicLoader;
    }

    public static void setPreferredClassLoader(ClassLoader classLoader) {
        if (classLoader != dynamicLoader) {
            dynamicLoader = classLoader;
            Thread[] threads = new Thread[Thread.activeCount()];
            Thread.enumerate(threads);
            Thread[] threadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                Thread t = threadArray[n2];
                if (t != null) {
                    t.setContextClassLoader(classLoader);
                }
                ++n2;
            }
        }
    }

    public static void popPreferredClassLoader() {
        ClassLoader sysLoader = ClassLoaderFinder.class.getClassLoader();
        if (dynamicLoader == null || dynamicLoader == sysLoader) {
            dynamicLoader = null;
            Thread[] threads = new Thread[Thread.activeCount()];
            Thread.enumerate(threads);
            Thread[] threadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                Thread t = threadArray[n2];
                if (t != null) {
                    t.setContextClassLoader(sysLoader);
                }
                ++n2;
            }
            return;
        }
        ClassLoader parent = dynamicLoader.getParent();
        dynamicLoader = parent == sysLoader ? null : parent;
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        Thread[] threadArray = threads;
        int n = threads.length;
        int n3 = 0;
        while (n3 < n) {
            Thread t = threadArray[n3];
            if (t != null) {
                t.setContextClassLoader(parent);
            }
            ++n3;
        }
    }
}

