/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.util;

import java.util.ArrayList;
import java.util.Collection;
import org.arakhne.afc.util.InformedIterable;
import org.arakhne.afc.vmutil.ReflectionUtil;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public class InformedArrayList<E>
extends ArrayList<E>
implements InformedIterable<E> {
    private static final long serialVersionUID = -921267155141517977L;
    private Class<? extends E> clazz;
    private boolean updateWhenRemove;

    public InformedArrayList() {
    }

    public InformedArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public InformedArrayList(Collection<? extends E> collection) {
        super(collection);
        this.clazz = InformedArrayList.extractClassFrom(collection);
    }

    public InformedArrayList(Class<? extends E> clazz) {
        this.clazz = clazz;
    }

    public InformedArrayList(int initialCapacity, Class<? extends E> clazz) {
        super(initialCapacity);
        this.clazz = clazz;
    }

    public InformedArrayList(Collection<? extends E> collection, Class<? extends E> clazz) {
        super(collection);
        this.clazz = clazz;
    }

    protected static <E> Class<? extends E> extractClassFrom(Collection<? extends E> collection) {
        Class<?> clazz = null;
        for (E elt : collection) {
            clazz = ReflectionUtil.getCommonType(clazz, elt.getClass());
        }
        return clazz == null ? Object.class : clazz;
    }

    public boolean isTypeRecomputedAfterRemoval() {
        return this.updateWhenRemove;
    }

    public void setTypeRecomputedAfterRemoval(boolean update) {
        this.updateWhenRemove = update;
    }

    protected final void updateComponentType(E newElement) {
        Class<?> lclazz = newElement.getClass();
        this.clazz = ReflectionUtil.getCommonType(this.clazz, lclazz);
    }

    protected final void updateComponentType(Collection<? extends E> newElements) {
        Class<? extends E> lclazz = InformedArrayList.extractClassFrom(newElements);
        this.clazz = ReflectionUtil.getCommonType(this.clazz, lclazz);
    }

    @Deprecated
    @Pure
    @Inline(value="getElementType()")
    public Class<? extends E> getComponentType() {
        return this.getElementType();
    }

    @Override
    public Class<? extends E> getElementType() {
        return this.clazz;
    }

    public void setElementType(Class<? extends E> type) {
        this.clazz = type;
    }

    @Override
    public boolean add(E elt) {
        if (super.add(elt)) {
            if (elt != null) {
                this.updateComponentType(elt);
            }
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        if (element != null) {
            this.updateComponentType(element);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (super.addAll(collection)) {
            this.updateComponentType(collection);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        if (super.addAll(index, collection)) {
            this.updateComponentType(collection);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.clazz = null;
    }

    @Override
    public E remove(int index) {
        Object e = super.remove(index);
        if (this.isEmpty()) {
            this.clazz = null;
        } else if (this.isTypeRecomputedAfterRemoval()) {
            this.clazz = InformedArrayList.extractClassFrom(this);
        }
        return e;
    }

    @Override
    public boolean remove(Object obj) {
        if (super.remove(obj)) {
            if (this.isEmpty()) {
                this.clazz = null;
            } else if (this.isTypeRecomputedAfterRemoval()) {
                this.clazz = InformedArrayList.extractClassFrom(this);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        if (this.isEmpty()) {
            this.clazz = null;
        } else if (this.isTypeRecomputedAfterRemoval()) {
            this.clazz = InformedArrayList.extractClassFrom(this);
        }
    }

    @Override
    public E set(int index, E element) {
        E elt = super.set(index, element);
        if (element != null) {
            if (this.size() == 1) {
                this.clazz = element.getClass();
            } else {
                this.updateComponentType(element);
            }
        }
        return elt;
    }
}

