/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.progress;

import java.lang.ref.WeakReference;
import org.arakhne.afc.progress.DefaultProgression;
import org.arakhne.afc.progress.Progression;

class SubProgressionModel
extends DefaultProgression {
    private final int level;
    private final double minValueInParent;
    private final double maxValueInParent;
    private final double extentInParent;
    private WeakReference<DefaultProgression> parent;
    private final boolean overwriteCommentWhenDisconnect;

    SubProgressionModel(DefaultProgression parent, double minPValue, double maxPValue, int minValue, int maxValue, boolean isIndeterminate, boolean adjusting, boolean overwriteComment) {
        super(minValue, minValue, maxValue, adjusting);
        assert (parent != null);
        this.level = parent.getTaskDepth() + 1;
        double uptMaxPValue = maxPValue;
        if (minPValue > uptMaxPValue) {
            uptMaxPValue = minPValue;
        }
        this.minValueInParent = minPValue;
        this.maxValueInParent = uptMaxPValue;
        this.extentInParent = uptMaxPValue - minPValue;
        this.overwriteCommentWhenDisconnect = overwriteComment;
        this.parent = new WeakReference<DefaultProgression>(parent);
        this.setIndeterminate(isIndeterminate);
    }

    SubProgressionModel(DefaultProgression parent, double minPValue, double maxPValue, boolean isIndeterminate, boolean adjusting, boolean overwriteComment) {
        super((int)minPValue, (int)minPValue, (int)maxPValue);
        assert (parent != null);
        this.level = parent.getTaskDepth() + 1;
        double uptMaxPValue = maxPValue;
        if (minPValue > uptMaxPValue) {
            uptMaxPValue = minPValue;
        }
        this.minValueInParent = minPValue;
        this.maxValueInParent = uptMaxPValue;
        this.extentInParent = uptMaxPValue - minPValue;
        this.overwriteCommentWhenDisconnect = overwriteComment;
        this.parent = new WeakReference<DefaultProgression>(parent);
        this.setAdjusting(adjusting);
        this.setIndeterminate(isIndeterminate);
    }

    void disconnect() {
        DefaultProgression parentInstance = this.getParent();
        if (parentInstance != null) {
            parentInstance.disconnectSubTask(this, this.maxValueInParent, this.overwriteCommentWhenDisconnect);
        }
        this.parent = null;
    }

    public double getMinInParent() {
        return this.minValueInParent;
    }

    public double getMaxInParent() {
        return this.maxValueInParent;
    }

    protected DefaultProgression getParent() {
        return this.parent == null ? null : (DefaultProgression)this.parent.get();
    }

    @Override
    public void end() {
        super.end();
        this.disconnect();
    }

    @Override
    protected void fireValueChange() {
        super.fireValueChange();
        double factor = this.getProgressionFactor();
        if (factor < 1.0) {
            DefaultProgression parentInstance = this.getParent();
            if (parentInstance != null) {
                double valueInParent = this.extentInParent * factor + this.minValueInParent;
                if (valueInParent > this.maxValueInParent) {
                    valueInParent = this.maxValueInParent;
                }
                parentInstance.setValue(this, valueInParent, this.getComment());
            }
        } else {
            this.disconnect();
        }
    }

    @Override
    public boolean isRootModel() {
        return false;
    }

    @Override
    public Progression getSuperTask() {
        return this.getParent();
    }

    @Override
    public int getTaskDepth() {
        return this.level;
    }
}

