/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.progress;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.arakhne.afc.progress.Progression;

public class ProgressionInputStream
extends FilterInputStream {
    private final Progression monitor;
    private final int totalSize;
    private int read;

    public ProgressionInputStream(InputStream in, Progression progression) {
        super(in);
        int size;
        this.monitor = progression;
        try {
            size = this.in.available();
        }
        catch (IOException exception) {
            size = 0;
        }
        this.totalSize = size >= 0 ? size : 0;
        this.monitor.setProperties(0, 0, this.totalSize, false);
    }

    public ProgressionInputStream(InputStream in, int totalSize, Progression progression) {
        super(in);
        this.monitor = progression;
        this.totalSize = totalSize >= 0 ? totalSize : 0;
        this.monitor.setProperties(0, 0, this.totalSize, false);
    }

    public Progression getProgression() {
        return this.monitor;
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.monitor.setValue(++this.read);
        }
        return c;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        int nr = this.in.read(buffer);
        if (nr > 0) {
            this.read += nr;
            this.monitor.setValue(this.read);
        }
        return nr;
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        int nr = this.in.read(buffer, off, len);
        if (nr > 0) {
            this.read += nr;
            this.monitor.setValue(this.read);
        }
        return nr;
    }

    @Override
    public long skip(long number) throws IOException {
        long nr = this.in.skip(number);
        if (nr > 0L) {
            this.read = (int)((long)this.read + nr);
            this.monitor.setValue(this.read);
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.monitor.end();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.read = this.totalSize - this.in.available();
        this.monitor.setValue(this.read);
    }
}

